/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class InterruptThreadAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DebuggerContextImpl debuggerContext;
        DebugProcessImpl debugProcess;
        DebuggerTreeNodeImpl[] nodes = InterruptThreadAction.getSelectedNodes(e.getDataContext());
        if (nodes == null) {
            return;
        }
        final ArrayList<ThreadReferenceProxyImpl> threadsToInterrupt = new ArrayList<ThreadReferenceProxyImpl>();
        for (DebuggerTreeNodeImpl debuggerTreeNode : nodes) {
            NodeDescriptorImpl descriptor = debuggerTreeNode.getDescriptor();
            if (!(descriptor instanceof ThreadDescriptorImpl)) continue;
            threadsToInterrupt.add(((ThreadDescriptorImpl)descriptor).getThreadReference());
        }
        if (!threadsToInterrupt.isEmpty() && (debugProcess = (debuggerContext = InterruptThreadAction.getDebuggerContext(e.getDataContext())).getDebugProcess()) != null) {
            debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    boolean unsupported = false;
                    for (ThreadReferenceProxyImpl thread : threadsToInterrupt) {
                        try {
                            thread.getThreadReference().interrupt();
                        }
                        catch (UnsupportedOperationException ignored) {
                            unsupported = true;
                        }
                    }
                    if (unsupported) {
                        Project project = debugProcess.getProject();
                        XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(JavaDebuggerBundle.message((String)"thread.operation.interrupt.is.not.supported.by.vm", (Object[])new Object[0]), MessageType.INFO).notify(project);
                    }
                }
            });
        }
    }

    public void update(@NotNull AnActionEvent e) {
        DebuggerTreeNodeImpl[] selectedNodes = InterruptThreadAction.getSelectedNodes(e.getDataContext());
        boolean visible = false;
        boolean enabled = false;
        if (selectedNodes != null && selectedNodes.length > 0) {
            NodeDescriptorImpl threadDescriptor;
            visible = true;
            enabled = true;
            for (DebuggerTreeNodeImpl selectedNode : selectedNodes) {
                threadDescriptor = selectedNode.getDescriptor();
                if (threadDescriptor instanceof ThreadDescriptorImpl) continue;
                visible = false;
                break;
            }
            if (visible) {
                for (DebuggerTreeNodeImpl selectedNode : selectedNodes) {
                    threadDescriptor = (ThreadDescriptorImpl)selectedNode.getDescriptor();
                    if (!((ThreadDescriptorImpl)threadDescriptor).isFrozen() && !((ThreadDescriptorImpl)threadDescriptor).isSuspended()) continue;
                    enabled = false;
                    break;
                }
            }
        }
        Presentation presentation = e.getPresentation();
        presentation.setText(JavaDebuggerBundle.messagePointer((String)"action.interrupt.thread.text", (Object[])new Object[0]));
        presentation.setEnabledAndVisible(visible && enabled);
    }
}

