/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class EditSourceAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DebuggerContextImpl debuggerContext;
        DebugProcessImpl process2;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        final DebuggerTreeNodeImpl selectedNode = EditSourceAction.getSelectedNode(e.getDataContext());
        if (selectedNode != null && (process2 = (debuggerContext = EditSourceAction.getDebuggerContext(e.getDataContext())).getDebugProcess()) != null) {
            process2.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                    SourcePosition sourcePosition = EditSourceAction.getSourcePosition(selectedNode, debuggerContext);
                    if (sourcePosition != null) {
                        sourcePosition.navigate(true);
                    }
                }
            });
        }
    }

    private static SourcePosition getSourcePosition(DebuggerTreeNodeImpl selectedNode, DebuggerContextImpl debuggerContext) {
        DebuggerContextImpl context = debuggerContext;
        if (selectedNode == null || context == null) {
            return null;
        }
        Project project = selectedNode.getProject();
        DebuggerSession debuggerSession = context.getDebuggerSession();
        if (debuggerSession == null) {
            return null;
        }
        NodeDescriptorImpl nodeDescriptor = selectedNode.getDescriptor();
        if (nodeDescriptor instanceof WatchItemDescriptor) {
            Modifier modifier = ((WatchItemDescriptor)nodeDescriptor).getModifier();
            if (modifier == null) {
                return null;
            }
            nodeDescriptor = (NodeDescriptorImpl)modifier.getInspectItem(project);
        }
        NodeDescriptorImpl nodeDescriptor1 = nodeDescriptor;
        return (SourcePosition)ReadAction.compute(() -> SourcePositionProvider.getSourcePosition(nodeDescriptor1, project, context));
    }

    public void update(@NotNull AnActionEvent e) {
        final Project project = e.getProject();
        final DebuggerContextImpl debuggerContext = EditSourceAction.getDebuggerContext(e.getDataContext());
        final DebuggerTreeNodeImpl node = EditSourceAction.getSelectedNode(e.getDataContext());
        final Presentation presentation = e.getPresentation();
        if (debuggerContext.getDebugProcess() != null) {
            presentation.setEnabled(true);
            debuggerContext.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                    SourcePosition position = EditSourceAction.getSourcePosition(node, debuggerContext);
                    if (position == null) {
                        DebuggerInvocationUtil.swingInvokeLater(project, () -> presentation.setEnabled(false));
                    }
                }
            });
        } else {
            presentation.setEnabled(false);
        }
        e.getPresentation().setText(ActionManager.getInstance().getAction("EditSource").getTemplatePresentation().getText());
    }
}

