/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.util.ui.ItemRemovable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class ModuleOptionsTableModel
extends AbstractTableModel
implements ItemRemovable {
    private final List<Item> myItems = new ArrayList<Item>();

    @NotNull
    public Map<String, String> getModuleOptions() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (Item item : this.myItems) {
            map2.put(item.module.getName(), item.option);
        }
        return map2;
    }

    public void setModuleOptions(@NotNull Project project, @NotNull Map<String, String> moduleOptions) {
        this.myItems.clear();
        if (!moduleOptions.isEmpty()) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                String options = moduleOptions.get(module.getName());
                if (options == null) continue;
                this.myItems.add(new Item(module, options));
            }
            this.sortItems();
        }
        this.fireTableDataChanged();
    }

    public int addModulesToModel(@NotNull Project project, @NotNull Component parent) {
        HashSet<Module> existing = new HashSet<Module>();
        for (Item item : this.myItems) {
            existing.add(item.module);
        }
        ArrayList<Module> candidates = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (existing.contains(module)) continue;
            candidates.add(module);
        }
        if (!candidates.isEmpty()) {
            candidates.sort(Comparator.comparing(Module::getName));
            ChooseModulesDialog chooseModulesDialog = new ChooseModulesDialog(parent, candidates, "Choose module");
            chooseModulesDialog.show();
            List chosen = chooseModulesDialog.getChosenElements();
            if (!chosen.isEmpty()) {
                for (Module module : chosen) {
                    this.myItems.add(new Item(module));
                }
                this.sortItems();
                this.fireTableDataChanged();
                for (int i = 0; i < this.myItems.size(); ++i) {
                    if (!this.myItems.get(i).module.equals(chosen.get(0))) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private void sortItems() {
        this.myItems.sort(Comparator.comparing(o -> ((Item)o).module.getName()));
    }

    @Override
    public int getRowCount() {
        return this.myItems.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Item item = this.myItems.get(rowIndex);
        return columnIndex == 0 ? item.module : item.option;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Item item = this.myItems.get(rowIndex);
        item.option = ((String)aValue).trim();
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void removeRow(int idx) {
        this.myItems.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    private static class Item {
        private final Module module;
        private String option;

        Item(Module module) {
            this(module, "");
        }

        private Item(Module module, String option) {
            this.module = module;
            this.option = option;
        }
    }
}

