/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerEncodingService;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class CompilerEncodingServiceImpl
extends CompilerEncodingService {
    @NotNull
    private final Project myProject;
    private final CachedValue<Map<Module, Set<Charset>>> myModuleFileEncodings;

    public CompilerEncodingServiceImpl(@NotNull Project project) {
        this.myProject = project;
        this.myModuleFileEncodings = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Map<Module, Set<Charset>> result = this.computeModuleCharsetMap();
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.myProject), ((EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject)).getModificationTracker()});
        }, false);
    }

    @NotNull
    private Map<Module, Set<Charset>> computeModuleCharsetMap() {
        THashMap map2 = new THashMap();
        Map mappings = ((EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject)).getAllMappings();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        for (Map.Entry entry : mappings.entrySet()) {
            Module module;
            VirtualFile file = (VirtualFile)entry.getKey();
            Charset charset = (Charset)entry.getValue();
            if (file == null || charset == null || !file.isDirectory() && !compilerManager.isCompilableFileType(file.getFileType()) || !index.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) || (module = index.getModuleForFile(file)) == null) continue;
            LinkedHashSet<Charset> set = (LinkedHashSet<Charset>)map2.get(module);
            if (set == null) {
                set = new LinkedHashSet<Charset>();
                map2.put(module, set);
                VirtualFile sourceRoot = index.getSourceRootForFile(file);
                Charset parentCharset = null;
                for (VirtualFile current = file.getParent(); current != null; current = current.getParent()) {
                    Charset currentCharset = (Charset)mappings.get(current);
                    if (currentCharset != null) {
                        parentCharset = currentCharset;
                    }
                    if (current.equals(sourceRoot)) break;
                }
                if (parentCharset != null) {
                    set.add(parentCharset);
                }
            }
            set.add(charset);
        }
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (VirtualFile file : ModuleRootManager.getInstance((Module)module).getSourceRoots(true)) {
                Charset encoding = EncodingProjectManager.getInstance((Project)this.myProject).getEncoding(file, true);
                if (encoding == null) continue;
                LinkedHashSet<Charset> charsets = (LinkedHashSet<Charset>)map2.get(module);
                if (charsets == null) {
                    charsets = new LinkedHashSet<Charset>();
                    map2.put(module, charsets);
                }
                charsets.add(encoding);
            }
        }
        return map2;
    }

    @Nullable
    public Charset getPreferredModuleEncoding(@NotNull Module module) {
        Set encodings = (Set)((Map)this.myModuleFileEncodings.getValue()).get(module);
        return (Charset)ContainerUtil.getFirstItem((Collection)encodings, (Object)EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
    }

    @NotNull
    public Collection<Charset> getAllModuleEncodings(@NotNull Module module) {
        Set encodings = (Set)((Map)this.myModuleFileEncodings.getValue()).get(module);
        if (encodings != null) {
            return encodings;
        }
        return ContainerUtil.createMaybeSingletonList((Object)EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
    }
}

