/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceBase;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.backwardRefs.JavaBackwardReferenceIndexReaderFactory;
import com.intellij.compiler.backwardRefs.OccurrenceCounter;
import com.intellij.compiler.backwardRefs.ReferenceIndexUnavailableException;
import com.intellij.compiler.chainsSearch.ChainOpAndOccurrences;
import com.intellij.compiler.chainsSearch.MethodCall;
import com.intellij.compiler.chainsSearch.RefChainOperation;
import com.intellij.compiler.chainsSearch.TypeCast;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.compiler.server.CustomBuilderMessageHandler;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.DummyCompileContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.messages.SimpleMessageBusConnection;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.IntSummaryStatistics;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.CompilerRef;
import org.jetbrains.jps.backwardRefs.SignatureData;

public final class CompilerReferenceServiceImpl
extends CompilerReferenceServiceBase<JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader>
implements CompilerReferenceServiceEx {
    public CompilerReferenceServiceImpl(Project project) {
        super(project, JavaBackwardReferenceIndexReaderFactory.INSTANCE, (connection, compilationAffectedModules) -> connection.subscribe(CustomBuilderMessageHandler.TOPIC, (builderId, messageType, messageText) -> {
            if ("compiler.ref.index".equals(builderId)) {
                compilationAffectedModules.add(messageText);
            }
        }));
        SimpleMessageBusConnection connection2 = this.myProject.getMessageBus().simpleConnect();
        connection2.subscribe(BuildManagerListener.TOPIC, (Object)new BuildManagerListener(){

            @Override
            public void buildStarted(@NotNull Project project, @NotNull UUID sessionId, boolean isAutomake) {
                if (project == CompilerReferenceServiceImpl.this.myProject) {
                    CompilerReferenceServiceImpl.this.closeReaderIfNeeded(CompilerReferenceServiceBase.IndexCloseReason.COMPILATION_STARTED);
                }
            }
        });
        connection2.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

            public void compilationFinished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                this.compilationFinished(compileContext);
            }

            public void automakeCompilationFinished(int errors, int warnings, @NotNull CompileContext compileContext) {
                this.compilationFinished(compileContext);
            }

            private void compilationFinished(@NotNull CompileContext context) {
                if (!(context instanceof DummyCompileContext) && context.getProject() == CompilerReferenceServiceImpl.this.myProject) {
                    Runnable compilationFinished = () -> {
                        Module[] compilationModules = (Module[])ReadAction.compute(() -> {
                            if (CompilerReferenceServiceImpl.this.myProject.isDisposed()) {
                                return null;
                            }
                            CompileScope scope = context.getCompileScope();
                            return scope == null ? null : scope.getAffectedModules();
                        });
                        if (compilationModules == null) {
                            return;
                        }
                        CompilerReferenceServiceImpl.this.openReaderIfNeeded(CompilerReferenceServiceBase.IndexOpenReason.COMPILATION_FINISHED);
                    };
                    CompilerReferenceServiceBase.executeOnBuildThread(compilationFinished);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public SortedSet<ChainOpAndOccurrences<MethodCall>> findMethodReferenceOccurrences(@NotNull String rawReturnType2, @SignatureData.IteratorKind byte iteratorKind, @NotNull ChainCompletionContext context) {
        try {
            if (!this.myReadDataLock.tryLock()) {
                return Collections.emptySortedSet();
            }
            try {
                if (this.myReader == null) {
                    throw new ReferenceIndexUnavailableException();
                }
                int type2 = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getNameEnumerator().tryEnumerate((Object)rawReturnType2);
                if (type2 == 0) {
                    SortedSet<ChainOpAndOccurrences<MethodCall>> sortedSet = Collections.emptySortedSet();
                    return sortedSet;
                }
                SortedSet sortedSet = Stream.of(new SignatureData(type2, iteratorKind, true), new SignatureData(type2, iteratorKind, false)).flatMap(sd -> ((StreamEx)((StreamEx)StreamEx.of(((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getMembersFor((SignatureData)sd)).peek(r -> ProgressManager.checkCanceled())).select(CompilerRef.JavaCompilerMethodRef.class).flatMap(r -> {
                    CompilerRef.CompilerClassHierarchyElementDef[] hierarchy = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getHierarchy(r.getOwner(), false, false, 20);
                    return hierarchy == null ? Stream.empty() : Arrays.stream(hierarchy).map(c -> r.override(c.getName()));
                }).distinct()).map(r -> {
                    int count = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getOccurrenceCount((CompilerRef)r);
                    return count <= 1 ? null : new ChainOpAndOccurrences<MethodCall>(new MethodCall((CompilerRef.JavaCompilerMethodRef)r, (SignatureData)sd, context), count);
                })).filter(Objects::nonNull).collect(Collectors.groupingBy(x -> (MethodCall)x.getOperation(), Collectors.summarizingInt(x -> x.getOccurrenceCount()))).entrySet().stream().map(e -> new ChainOpAndOccurrences<RefChainOperation>((RefChainOperation)e.getKey(), (int)((IntSummaryStatistics)e.getValue()).getSum())).collect(Collectors.toCollection(TreeSet::new));
                return sortedSet;
            }
            finally {
                this.myReadDataLock.unlock();
            }
        }
        catch (Exception e2) {
            this.onException(e2, "find methods");
            return Collections.emptySortedSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public ChainOpAndOccurrences<TypeCast> getMostUsedTypeCast(@NotNull String operandQName) throws ReferenceIndexUnavailableException {
        try {
            if (!this.myReadDataLock.tryLock()) {
                return null;
            }
            try {
                if (this.myReader == null) {
                    throw new ReferenceIndexUnavailableException();
                }
                int nameId = this.getNameId(operandQName);
                if (nameId == 0) {
                    ChainOpAndOccurrences<TypeCast> chainOpAndOccurrences = null;
                    return chainOpAndOccurrences;
                }
                CompilerRef.JavaCompilerClassRef target = new CompilerRef.JavaCompilerClassRef(nameId);
                OccurrenceCounter<CompilerRef> typeCasts = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getTypeCastOperands((CompilerRef)target, null);
                CompilerRef bestCast = typeCasts.getBest();
                if (bestCast == null) {
                    ChainOpAndOccurrences<TypeCast> chainOpAndOccurrences = null;
                    return chainOpAndOccurrences;
                }
                ChainOpAndOccurrences<TypeCast> chainOpAndOccurrences = new ChainOpAndOccurrences<TypeCast>(new TypeCast((CompilerRef.CompilerClassHierarchyElementDef)bestCast, (CompilerRef.CompilerClassHierarchyElementDef)target, this), typeCasts.getBestOccurrences());
                return chainOpAndOccurrences;
            }
            finally {
                this.myReadDataLock.unlock();
            }
        }
        catch (Exception e) {
            this.onException(e, "best type cast search");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public CompilerRef.CompilerClassHierarchyElementDef mayCallOfTypeCast(@NotNull CompilerRef.JavaCompilerMethodRef method, int probabilityThreshold) throws ReferenceIndexUnavailableException {
        if (!this.myReadDataLock.tryLock()) {
            return null;
        }
        try {
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            IntSet ids = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getAllContainingFileIds((CompilerRef)method);
            CompilerRef.CompilerClassHierarchyElementDef owner2 = method.getOwner();
            OccurrenceCounter<CompilerRef> bestTypeCast = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getTypeCastOperands((CompilerRef)owner2, (IntCollection)ids);
            CompilerRef best = bestTypeCast.getBest();
            CompilerRef.CompilerClassHierarchyElementDef compilerClassHierarchyElementDef = best != null && ids.size() > probabilityThreshold * (ids.size() - bestTypeCast.getBestOccurrences()) ? (CompilerRef.CompilerClassHierarchyElementDef)best : null;
            this.myReadDataLock.unlock();
            return compilerClassHierarchyElementDef;
        }
        catch (Throwable throwable) {
            try {
                this.myReadDataLock.unlock();
                throw throwable;
            }
            catch (Exception e) {
                this.onException(e, "conditional probability");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mayHappen(@NotNull CompilerRef qualifier, @NotNull CompilerRef base, int probabilityThreshold) {
        try {
            if (!this.myReadDataLock.tryLock()) {
                return false;
            }
            try {
                if (this.myReader == null) {
                    throw new ReferenceIndexUnavailableException();
                }
                IntSet ids1 = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getAllContainingFileIds(qualifier);
                IntSet ids2 = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getAllContainingFileIds(base);
                IntSet intersection = CompilerReferenceServiceImpl.intersection(ids1, (IntCollection)ids2);
                if ((ids2.size() - intersection.size()) * probabilityThreshold < ids2.size()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.myReadDataLock.unlock();
            }
        }
        catch (Exception e) {
            this.onException(e, "conditional probability");
            return false;
        }
    }

    @Override
    @NotNull
    public String getName(int idx) throws ReferenceIndexUnavailableException {
        if (!this.myReadDataLock.tryLock()) {
            throw new ReferenceIndexUnavailableException();
        }
        try {
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            String string = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getNameEnumerator().getName(idx);
            this.myReadDataLock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.myReadDataLock.unlock();
                throw throwable;
            }
            catch (Exception e) {
                this.onException(e, "find methods");
                throw new ReferenceIndexUnavailableException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNameId(@NotNull String name2) throws ReferenceIndexUnavailableException {
        if (!this.myReadDataLock.tryLock()) {
            return 0;
        }
        try {
            int id;
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            int n = id = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getNameEnumerator().tryEnumerate((Object)name2);
            this.myReadDataLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.myReadDataLock.unlock();
                throw throwable;
            }
            catch (Exception e) {
                this.onException(e, "get name-id");
                throw new ReferenceIndexUnavailableException();
            }
        }
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
    CompilerRef.CompilerClassHierarchyElementDef @NotNull [] getDirectInheritors(@NotNull CompilerRef.CompilerClassHierarchyElementDef baseClass) throws ReferenceIndexUnavailableException {
        if (!this.myReadDataLock.tryLock()) {
            return CompilerRef.CompilerClassHierarchyElementDef.EMPTY_ARRAY;
        }
        try {
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            CompilerRef.CompilerClassHierarchyElementDef[] compilerClassHierarchyElementDefArray = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getDirectInheritors((CompilerRef)baseClass);
            this.myReadDataLock.unlock();
            return compilerClassHierarchyElementDefArray;
        }
        catch (Throwable throwable) {
            try {
                this.myReadDataLock.unlock();
                throw throwable;
            }
            catch (Exception e) {
                this.onException(e, "find methods");
                throw new ReferenceIndexUnavailableException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInheritorCount(@NotNull CompilerRef.CompilerClassHierarchyElementDef baseClass) throws ReferenceIndexUnavailableException {
        if (!this.myReadDataLock.tryLock()) {
            return -1;
        }
        try {
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            CompilerRef.CompilerClassHierarchyElementDef[] hierarchy = ((JavaBackwardReferenceIndexReaderFactory.BackwardReferenceReader)this.myReader).getHierarchy(baseClass, false, true, -1);
            int n = hierarchy == null ? -1 : hierarchy.length;
            this.myReadDataLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.myReadDataLock.unlock();
                throw throwable;
            }
            catch (Exception e) {
                this.onException(e, "inheritor count");
                throw new ReferenceIndexUnavailableException();
            }
        }
    }

    static final class InitializationActivity
    implements StartupActivity.DumbAware {
        InitializationActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (CompilerReferenceService.isEnabled()) {
                CompilerReferenceService.getInstance(project);
            }
        }
    }
}

