/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.streamToLoop.FunctionHelper;
import com.intellij.codeInspection.streamToLoop.Operation;
import com.intellij.codeInspection.streamToLoop.SourceOperation;
import com.intellij.codeInspection.streamToLoop.StreamToLoopReplacementContext;
import com.intellij.codeInspection.streamToLoop.TerminalOperation;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamToLoopInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(StreamToLoopInspection.class);
    private static final Set<String> SUPPORTED_TERMINALS = ContainerUtil.set((Object[])new String[]{"count", "sum", "summaryStatistics", "reduce", "collect", "findFirst", "findAny", "anyMatch", "allMatch", "noneMatch", "toArray", "average", "forEach", "forEachOrdered", "min", "max", "toList", "toSet", "toImmutableList", "toImmutableSet"});
    private static final CallMatcher ITERABLE_FOREACH = CallMatcher.instanceCall("java.lang.Iterable", "forEach").parameterTypes("java.util.function.Consumer");
    private static final CallMatcher MAP_FOREACH = CallMatcher.instanceCall("java.util.Map", "forEach").parameterTypes("java.util.function.BiConsumer");
    public boolean SUPPORT_UNKNOWN_SOURCES = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaBundle.message((String)"checkbox.iterate.unknown.stream.sources.via.stream.iterator", (Object[])new Object[0]), (InspectionProfileEntry)this, "SUPPORT_UNKNOWN_SOURCES");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                super.visitMethodCallExpression(call);
                PsiReferenceExpression expression2 = call.getMethodExpression();
                PsiElement nameElement = expression2.getReferenceNameElement();
                if (nameElement == null || !SUPPORTED_TERMINALS.contains(nameElement.getText())) {
                    return;
                }
                if (!CodeBlockSurrounder.canSurround((PsiExpression)call)) {
                    return;
                }
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream")) {
                    if (StreamToLoopInspection.extractOperations(ChainVariable.STUB, call, StreamToLoopInspection.this.SUPPORT_UNKNOWN_SOURCES) != null) {
                        this.register(call, nameElement, "Replace Stream API chain with loop");
                    }
                } else if (StreamToLoopInspection.extractIterableForEach(call) != null || StreamToLoopInspection.extractMapForEach(call) != null) {
                    this.register(call, nameElement, "Replace 'forEach' call with loop");
                }
            }

            private void register(PsiMethodCallExpression call, PsiElement nameElement, String message2) {
                TextRange range = isOnTheFly && InspectionProjectProfileManager.isInformationLevel((String)StreamToLoopInspection.this.getShortName(), (PsiElement)call) ? new TextRange(0, call.getTextLength()) : nameElement.getTextRange().shiftRight(-call.getTextOffset());
                holder.registerProblem((PsiElement)call, range, message2, new LocalQuickFix[]{new ReplaceStreamWithLoopFix(message2)});
            }
        };
    }

    @Nullable
    static Operation createOperationFromCall(ChainVariable outVar, PsiMethodCallExpression call, boolean supportUnknownSources) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        String name2 = method.getName();
        String className2 = aClass.getQualifiedName();
        if (className2 == null) {
            return null;
        }
        PsiType callType = call.getType();
        if (callType == null) {
            return null;
        }
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.BaseStream") && !method.getModifierList().hasExplicitModifier("static")) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier != null) {
                PsiType elementType = StreamApiUtil.getStreamElementType(qualifier.getType());
                if (!StreamToLoopInspection.isValidElementType(elementType, (PsiElement)call, false)) {
                    return null;
                }
                Operation op = Operation.createIntermediate(name2, args, outVar, elementType, supportUnknownSources);
                if (op != null) {
                    return op;
                }
                op = TerminalOperation.createTerminal(name2, args, elementType, callType, ExpressionUtils.isVoidContext((PsiExpression)call));
                if (op != null) {
                    return op;
                }
            }
            return null;
        }
        return SourceOperation.createSource(call, supportUnknownSources);
    }

    private static boolean isValidElementType(PsiType elementType, PsiElement context, boolean allowRaw) {
        PsiResolveHelper helper;
        if (elementType == null || !allowRaw && elementType instanceof PsiClassType && ((PsiClassType)elementType).isRaw()) {
            return false;
        }
        return !(elementType instanceof PsiImmediateClassType) || (helper = PsiResolveHelper.SERVICE.getInstance((Project)context.getProject())).resolveReferencedClass(elementType.getCanonicalText(), context) != null;
    }

    @Nullable
    static List<OperationRecord> extractIterableForEach(PsiMethodCallExpression terminalCall) {
        if (!ITERABLE_FOREACH.test(terminalCall) || !ExpressionUtils.isVoidContext((PsiExpression)terminalCall)) {
            return null;
        }
        PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(terminalCall.getMethodExpression());
        if (qualifier == null) {
            return null;
        }
        PsiType type2 = qualifier.getType();
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.stream.BaseStream")) {
            return null;
        }
        PsiExpression arg = terminalCall.getArgumentList().getExpressions()[0];
        FunctionHelper fn = FunctionHelper.create(arg, 1, true);
        if (fn == null) {
            return null;
        }
        PsiType elementType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.lang.Iterable", (int)0, (boolean)false);
        if (!StreamToLoopInspection.isValidElementType(elementType, (PsiElement)terminalCall, true)) {
            return null;
        }
        elementType = GenericsUtil.getVariableTypeByExpressionType((PsiType)elementType);
        TerminalOperation.ForEachTerminalOperation terminal = new TerminalOperation.ForEachTerminalOperation(fn);
        SourceOperation.ForEachSource source = new SourceOperation.ForEachSource(qualifier);
        OperationRecord terminalRecord = new OperationRecord();
        OperationRecord sourceRecord = new OperationRecord();
        terminalRecord.myOperation = terminal;
        sourceRecord.myOperation = source;
        sourceRecord.myOutVar = terminalRecord.myInVar = new ChainVariable(elementType);
        sourceRecord.myInVar = terminalRecord.myOutVar = ChainVariable.STUB;
        return Arrays.asList(sourceRecord, terminalRecord);
    }

    @Nullable
    static List<OperationRecord> extractMapForEach(PsiMethodCallExpression terminalCall) {
        if (!MAP_FOREACH.test(terminalCall) || !ExpressionUtils.isVoidContext((PsiExpression)terminalCall)) {
            return null;
        }
        PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(terminalCall.getMethodExpression());
        if (qualifier == null) {
            return null;
        }
        PsiType type2 = qualifier.getType();
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.stream.BaseStream")) {
            return null;
        }
        PsiExpression arg = terminalCall.getArgumentList().getExpressions()[0];
        FunctionHelper fn = FunctionHelper.create(arg, 2, true);
        if (fn == null) {
            return null;
        }
        PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)0, (boolean)false);
        PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)1, (boolean)false);
        if (!StreamToLoopInspection.isValidElementType(keyType, (PsiElement)terminalCall, true) || !StreamToLoopInspection.isValidElementType(valueType, (PsiElement)terminalCall, true)) {
            return null;
        }
        keyType = GenericsUtil.getVariableTypeByExpressionType((PsiType)keyType);
        valueType = GenericsUtil.getVariableTypeByExpressionType((PsiType)valueType);
        Project project = terminalCall.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass entryClass = facade.findClass("java.util.Map.Entry", terminalCall.getResolveScope());
        if (entryClass == null || entryClass.getTypeParameters().length != 2) {
            return null;
        }
        PsiClassType entryType = JavaPsiFacade.getElementFactory((Project)project).createType(entryClass, new PsiType[]{keyType, valueType});
        TerminalOperation.MapForEachTerminalOperation terminal = new TerminalOperation.MapForEachTerminalOperation(fn, keyType, valueType);
        SourceOperation.ForEachSource source = new SourceOperation.ForEachSource(qualifier, true);
        OperationRecord terminalRecord = new OperationRecord();
        OperationRecord sourceRecord = new OperationRecord();
        terminalRecord.myOperation = terminal;
        sourceRecord.myOperation = source;
        sourceRecord.myOutVar = terminalRecord.myInVar = new ChainVariable((PsiType)entryType);
        sourceRecord.myInVar = terminalRecord.myOutVar = ChainVariable.STUB;
        return Arrays.asList(sourceRecord, terminalRecord);
    }

    @Nullable
    static List<OperationRecord> extractOperations(ChainVariable outVar, PsiMethodCallExpression terminalCall, boolean supportUnknownSources) {
        ArrayList<OperationRecord> operations = new ArrayList<OperationRecord>();
        PsiMethodCallExpression currentCall = terminalCall;
        ChainVariable lastVar = outVar;
        Operation next = null;
        Operation op;
        while ((op = StreamToLoopInspection.createOperationFromCall(lastVar, currentCall, supportUnknownSources)) != null) {
            Operation combined;
            if (next != null && (combined = op.combineWithNext(next)) != null) {
                op = combined;
                operations.remove(operations.size() - 1);
            }
            OperationRecord or = new OperationRecord();
            or.myOperation = op;
            or.myOutVar = lastVar;
            operations.add(or);
            if (op instanceof SourceOperation) {
                or.myInVar = ChainVariable.STUB;
                Collections.reverse(operations);
                return operations;
            }
            if ((currentCall = MethodCallUtils.getQualifierMethodCall(currentCall)) == null) {
                return null;
            }
            if (op.changesVariable()) {
                PsiType type2 = StreamApiUtil.getStreamElementType(currentCall.getType());
                if (type2 == null) {
                    return null;
                }
                lastVar = new ChainVariable(type2);
            }
            or.myInVar = lastVar;
            next = op;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    static TerminalOperation getTerminal(List<? extends OperationRecord> operations) {
        if (operations == null || operations.isEmpty()) {
            return null;
        }
        OperationRecord record = operations.get(operations.size() - 1);
        if (record.myOperation instanceof TerminalOperation) {
            return (TerminalOperation)record.myOperation;
        }
        return null;
    }

    static class OperationRecord {
        Operation myOperation;
        ChainVariable myInVar;
        ChainVariable myOutVar;

        OperationRecord() {
        }
    }

    static enum ResultKind {
        FINAL,
        NON_FINAL,
        UNKNOWN;

    }

    static class ReplaceStreamWithLoopFix
    implements LocalQuickFix {
        private final String myMessage;

        ReplaceStreamWithLoopFix(String message2) {
            this.myMessage = message2;
        }

        @Nls
        @NotNull
        public String getName() {
            return this.myMessage;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"quickfix.family.replace.stream.api.chain.with.loop", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            TerminalOperation terminal;
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression terminalCall = (PsiMethodCallExpression)element;
            CodeBlockSurrounder surrounder = CodeBlockSurrounder.forExpression((PsiExpression)terminalCall);
            if (surrounder == null) {
                return;
            }
            CodeBlockSurrounder.SurroundResult surroundResult = surrounder.surround();
            terminalCall = (PsiMethodCallExpression)surroundResult.getExpression();
            PsiType resultType = terminalCall.getType();
            if (resultType == null) {
                return;
            }
            List<OperationRecord> operations = StreamToLoopInspection.extractOperations(ChainVariable.STUB, terminalCall, true);
            if (operations == null) {
                operations = StreamToLoopInspection.extractIterableForEach(terminalCall);
            }
            if (operations == null) {
                operations = StreamToLoopInspection.extractMapForEach(terminalCall);
            }
            if ((terminal = StreamToLoopInspection.getTerminal(operations)) == null) {
                return;
            }
            PsiStatement statement = surroundResult.getAnchor();
            CommentTracker ct = new CommentTracker();
            try {
                StreamToLoopReplacementContext context = new StreamToLoopReplacementContext(statement, operations, (PsiExpression)terminalCall, ct);
                ReplaceStreamWithLoopFix.registerVariables(operations, context);
                String replacement = "";
                for (OperationRecord or : StreamEx.ofReversed(operations)) {
                    replacement = or.myOperation.wrap(or.myInVar, or.myOutVar, replacement, context);
                }
                PsiElement firstAdded = null;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                for (PsiStatement addedStatement : ((PsiBlockStatement)factory.createStatementFromText("{" + replacement + "}", (PsiElement)statement)).getCodeBlock().getStatements()) {
                    PsiElement res = ReplaceStreamWithLoopFix.addStatement(project, statement, addedStatement);
                    if (firstAdded != null) continue;
                    firstAdded = res;
                }
                PsiElement result = context.makeFinalReplacement();
                if (result != null) {
                    result = ReplaceStreamWithLoopFix.normalize(project, result);
                    if (firstAdded == null) {
                        firstAdded = result;
                    }
                }
                if (firstAdded != null) {
                    ct.insertCommentsBefore(firstAdded);
                }
            }
            catch (Exception ex) {
                LOG.error("Error converting Stream to loop", (Throwable)ex, new Attachment[]{new Attachment("Stream_code.txt", terminalCall.getText())});
            }
        }

        private static PsiElement addStatement(@NotNull Project project, PsiStatement statement, PsiStatement context) {
            PsiElement element = statement.getParent().addBefore((PsiElement)context, (PsiElement)statement);
            return ReplaceStreamWithLoopFix.normalize(project, element);
        }

        private static PsiElement normalize(@NotNull Project project, PsiElement element) {
            element = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(element);
            RedundantCastUtil.getRedundantCastsInside(element).forEach(RemoveRedundantCastUtil::removeCast);
            return element;
        }

        private static StreamEx<OperationRecord> allOperations(List<OperationRecord> operations) {
            return StreamEx.of(operations).flatMap(or -> or.myOperation.nestedOperations().append(or));
        }

        private static void registerVariables(List<OperationRecord> operations, StreamToLoopReplacementContext context) {
            ReplaceStreamWithLoopFix.allOperations(operations).forEach(or -> or.myOperation.preprocessVariables(context, or.myInVar, or.myOutVar));
            ReplaceStreamWithLoopFix.allOperations(operations).map(or -> or.myOperation).forEach(op -> op.registerReusedElements(context::registerReusedElement));
            ((StreamEx)ReplaceStreamWithLoopFix.allOperations(operations).map(or -> or.myInVar).distinct()).forEach(var -> var.register(context));
        }
    }
}

