/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ChainContext {
    private final PsiElementFactory myFactory;
    private final List<String> myBeforeSteps = new ArrayList<String>();
    private final List<String> myAfterSteps = new ArrayList<String>();
    public PsiElement myChainExpression;
    final Set<String> myUsedNames;

    public ChainContext(@NotNull PsiElement chainExpression) {
        this.myChainExpression = chainExpression;
        this.myFactory = JavaPsiFacade.getElementFactory((Project)chainExpression.getProject());
        this.myUsedNames = new HashSet<String>();
    }

    public ChainContext(@NotNull ChainContext parentContext) {
        this.myChainExpression = parentContext.myChainExpression;
        this.myFactory = parentContext.myFactory;
        this.myUsedNames = parentContext.myUsedNames;
    }

    public String registerVarName(@NotNull Collection<String> variants) {
        if (variants.isEmpty()) {
            return this.registerVarName(Collections.singleton("val"));
        }
        int idx = 0;
        while (true) {
            for (String variant : variants) {
                String name2 = idx == 0 ? variant : variant + idx;
                if (this.isUsed(name2)) continue;
                this.myUsedNames.add(name2);
                return name2;
            }
            ++idx;
        }
    }

    public String declare(String desiredName, String type2, String initializer) {
        String name2 = this.registerVarName(Collections.singleton(desiredName));
        this.myBeforeSteps.add(type2 + " " + name2 + " = " + initializer + ";");
        return name2;
    }

    public void addBeforeStep(String beforeStatement) {
        this.myBeforeSteps.add(beforeStatement);
    }

    public String drainBeforeSteps() {
        String beforeSteps = String.join((CharSequence)"", this.myBeforeSteps);
        this.myBeforeSteps.clear();
        return beforeSteps;
    }

    public void addAfterStep(String afterStatement) {
        this.myAfterSteps.add(0, afterStatement);
    }

    public String drainAfterSteps() {
        String afterSteps = String.join((CharSequence)"", this.myAfterSteps);
        this.myAfterSteps.clear();
        return afterSteps;
    }

    public PsiExpression createExpression(String text2) {
        return this.myFactory.createExpressionFromText(text2, this.myChainExpression);
    }

    public PsiStatement createStatement(String text2) {
        return this.myFactory.createStatementFromText(text2, this.myChainExpression);
    }

    public PsiType createType(String text2) {
        return this.myFactory.createTypeFromText(text2, this.myChainExpression);
    }

    private boolean isUsed(String varName) {
        return this.myUsedNames.contains(varName) || JavaLexer.isKeyword(varName, LanguageLevel.HIGHEST) || !varName.equals(JavaCodeStyleManager.getInstance((Project)this.getProject()).suggestUniqueVariableName(varName, this.myChainExpression, v -> PsiTreeUtil.isAncestor((PsiElement)this.myChainExpression, (PsiElement)v, (boolean)true)));
    }

    public Project getProject() {
        return this.myChainExpression.getProject();
    }
}

