/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.streamMigration.CollectMigration;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FuseStreamOperationsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher STREAM_COLLECT = CallMatcher.instanceCall("java.util.stream.Stream", "collect").parameterTypes("java.util.stream.Collector");
    private static final CallMatcher COLLECT_TO_COLLECTION = CallMatcher.anyOf(CallMatcher.staticCall("java.util.stream.Collectors", "toList", "toSet").parameterCount(0), CallMatcher.staticCall("java.util.stream.Collectors", "toCollection").parameterCount(1));
    public boolean myStrictMode = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaBundle.message((String)"inspection.fuse.stream.operations.option.strict.mode", (Object[])new Object[0]), (InspectionProfileEntry)this, "myStrictMode");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (STREAM_COLLECT.test(call)) {
                    PsiMethodCallExpression arg = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getArgumentList().getExpressions()[0]), PsiMethodCallExpression.class);
                    if (COLLECT_TO_COLLECTION.test(arg)) {
                        CollectMigration.CollectTerminal newTerminal = FuseStreamOperationsInspection.extractTerminal(call);
                        if (newTerminal == null) {
                            return;
                        }
                        PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                        if (nameElement == null) {
                            return;
                        }
                        String fusedSteps = ((StreamEx)newTerminal.fusedElements().mapLastOrElse(s -> StreamEx.of((Object[])new String[]{", ", s}), s -> StreamEx.of((Object[])new String[]{" and ", s})).flatMap(Function.identity()).skip(1L)).joining();
                        holder.registerProblem(nameElement, JavaBundle.message((String)"inspection.fuse.stream.operations.message", (Object[])new Object[]{fusedSteps}), new LocalQuickFix[]{new FuseStreamOperationsFix(fusedSteps, FuseStreamOperationsInspection.this.myStrictMode)});
                    }
                }
            }
        };
    }

    @Nullable
    private static CollectMigration.CollectTerminal extractTerminal(PsiMethodCallExpression streamChain) {
        PsiElement nextElement;
        StreamCollectChain terminal;
        if (streamChain.getMethodExpression().getQualifierExpression() == null) {
            return null;
        }
        PsiMethodCallExpression collector = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ArrayUtil.getFirstElement((Object[])streamChain.getArgumentList().getExpressions()))), PsiMethodCallExpression.class);
        PsiLocalVariable var = (PsiLocalVariable)ObjectUtils.tryCast((Object)streamChain.getParent(), PsiLocalVariable.class);
        if (var == null) {
            terminal = new StreamCollectChainNoVar(streamChain, collector);
            nextElement = RefactoringUtil.getParentStatement((PsiElement)streamChain, false);
        } else {
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)var.getParent(), PsiDeclarationStatement.class);
            if (declaration2 == null || declaration2.getDeclaredElements().length != 1) {
                return null;
            }
            terminal = new StreamCollectChain(var, streamChain, collector);
            nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)declaration2);
        }
        CollectMigration.CollectTerminal newTerminal = CollectMigration.includePostStatements(terminal, nextElement);
        if (newTerminal == terminal) {
            return null;
        }
        return newTerminal;
    }

    private static class FuseStreamOperationsFix
    implements LocalQuickFix {
        private final String myFusedSteps;
        private final boolean myStrictMode;

        FuseStreamOperationsFix(String fusedSteps, boolean strictMode) {
            this.myFusedSteps = fusedSteps;
            this.myStrictMode = strictMode;
        }

        @Nls
        @NotNull
        public String getName() {
            return JavaBundle.message((String)"inspection.fuse.stream.operations.fix.name", (Object[])new Object[]{this.myFusedSteps});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.fuse.stream.operations.fix.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement result;
            PsiMethodCallExpression chain = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (chain == null) {
                return;
            }
            CollectMigration.CollectTerminal terminal = FuseStreamOperationsInspection.extractTerminal(chain);
            if (terminal == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String stream = terminal.generateIntermediate(ct) + terminal.generateTerminal(ct, this.myStrictMode);
            PsiElement toReplace = terminal.getElementToReplace();
            terminal.cleanUp(ct);
            if (toReplace != null) {
                result = ct.replaceAndRestoreComments(toReplace, stream);
            } else {
                PsiVariable variable = (PsiVariable)Objects.requireNonNull(terminal.getTargetVariable());
                PsiExpression initializer = Objects.requireNonNull(variable.getInitializer());
                result = ct.replaceAndRestoreComments((PsiElement)initializer, stream);
            }
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }
    }

    private static class StreamCollectChainNoVar
    extends StreamCollectChain {
        protected StreamCollectChainNoVar(PsiMethodCallExpression chain, PsiMethodCallExpression collector) {
            super(null, chain, collector);
        }

        StreamEx<PsiExpression> targetReferences() {
            return StreamEx.of((Object)this.myChain);
        }

        @Override
        boolean isTargetReference(PsiExpression expression2) {
            return expression2 == this.myChain;
        }
    }

    private static class StreamCollectChain
    extends CollectMigration.CollectTerminal {
        final PsiMethodCallExpression myCollector;
        final PsiMethodCallExpression myChain;

        protected StreamCollectChain(PsiLocalVariable variable, PsiMethodCallExpression chain, PsiMethodCallExpression collector) {
            super(variable, null, ControlFlowUtils.InitializerUsageStatus.DECLARED_JUST_BEFORE);
            this.myCollector = collector;
            this.myChain = chain;
        }

        @Override
        String generateIntermediate(CommentTracker ct) {
            PsiExpression qualifier = this.myChain.getMethodExpression().getQualifierExpression();
            return ct.text((PsiElement)Objects.requireNonNull(qualifier));
        }

        @Override
        String generateTerminal(CommentTracker ct, boolean strictMode) {
            return ".collect(" + ct.text((PsiElement)this.myCollector) + ")";
        }

        private static PsiClass resolveClassCreatedByFunction(PsiExpression function) {
            PsiJavaCodeReferenceElement classReference2;
            PsiExpression body2;
            PsiNewExpression newExpression;
            if ((function = PsiUtil.skipParenthesizedExprDown((PsiExpression)function)) instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)function).isConstructor()) {
                PsiElement target = ((PsiMethodReferenceExpression)function).resolve();
                return target instanceof PsiClass ? (PsiClass)target : (target instanceof PsiMethod ? ((PsiMethod)target).getContainingClass() : null);
            }
            if (function instanceof PsiLambdaExpression && (newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)(body2 = LambdaUtil.extractSingleExpressionFromBody((PsiElement)((PsiLambdaExpression)function).getBody()))), PsiNewExpression.class)) != null && newExpression.getAnonymousClass() == null && newExpression.getQualifier() == null && newExpression.getArgumentList() != null && newExpression.getArgumentList().isEmpty() && (classReference2 = newExpression.getClassReference()) != null) {
                return (PsiClass)ObjectUtils.tryCast((Object)classReference2.resolve(), PsiClass.class);
            }
            return null;
        }

        @Override
        String getIntermediateStepsFromCollection() {
            String name2 = this.myCollector.getMethodExpression().getReferenceName();
            if ("toList".equals(name2)) {
                return "";
            }
            if ("toSet".equals(name2)) {
                return ".distinct()";
            }
            if ("toCollection".equals(name2)) {
                PsiExpression collectionFunction = this.myCollector.getArgumentList().getExpressions()[0];
                PsiClass psiClass = StreamCollectChain.resolveClassCreatedByFunction(collectionFunction);
                if (psiClass == null) {
                    return null;
                }
                return CollectMigration.INTERMEDIATE_STEPS.get(psiClass.getQualifiedName());
            }
            return null;
        }
    }
}

