/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.reflectiveAccess.JavaReflectionInvocationInspection;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CheckBox;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.ui.UiUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReflectionMemberAccessInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<String> MEMBER_METHOD_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"getField", "getDeclaredField", "getMethod", "getDeclaredMethod", "getConstructor", "getDeclaredConstructor"});
    private final List<String> ignoredClassNames = new ArrayList<String>();
    public boolean checkMemberExistsInNonFinalClasses = true;
    public String ignoredClassNamesString = "java.lang.Object,java.lang.Throwable";

    public JavaReflectionMemberAccessInspection() {
        this.parseSettings();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        ListTable table = new ListTable(new ListWrappingTableModel(this.ignoredClassNames, JavaBundle.message((String)"inspection.reflection.member.access.check.exists.exclude", (Object[])new Object[0])));
        JPanel tablePanel = UiUtils.createAddRemoveTreeClassChooserPanel(table, JavaBundle.message((String)"inspection.reflection.member.access.check.exists.exclude.chooser", (Object[])new Object[0]), new String[0]);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        CheckBox checkBox = new CheckBox(JavaBundle.message((String)"inspection.reflection.member.access.check.exists", (Object[])new Object[0]), (InspectionProfileEntry)this, "checkMemberExistsInNonFinalClasses");
        panel2.add((Component)checkBox, constraints);
        constraints.weighty = 1.0;
        constraints.gridy = 1;
        constraints.fill = 1;
        panel2.add((Component)tablePanel, constraints);
        return panel2;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        this.parseSettings();
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.collectSettings();
        super.writeSettings(element);
    }

    private void parseSettings() {
        this.ignoredClassNames.clear();
        ContainerUtil.addAll(this.ignoredClassNames, (Object[])this.ignoredClassNamesString.split(","));
    }

    private void collectSettings() {
        this.ignoredClassNamesString = String.join((CharSequence)",", this.ignoredClassNames);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                PsiClass containingClass;
                PsiMethod method;
                super.visitMethodCallExpression(expression2);
                String referenceName = expression2.getMethodExpression().getReferenceName();
                if (referenceName != null && MEMBER_METHOD_NAMES.contains(referenceName) && (method = expression2.resolveMethod()) != null && (containingClass = method.getContainingClass()) != null && "java.lang.Class".equals(containingClass.getQualifiedName())) {
                    switch (referenceName) {
                        case "getField": {
                            JavaReflectionMemberAccessInspection.this.checkField(expression2, false, holder);
                            break;
                        }
                        case "getDeclaredField": {
                            JavaReflectionMemberAccessInspection.this.checkField(expression2, true, holder);
                            break;
                        }
                        case "getMethod": {
                            JavaReflectionMemberAccessInspection.this.checkMethod(expression2, false, holder);
                            break;
                        }
                        case "getDeclaredMethod": {
                            JavaReflectionMemberAccessInspection.this.checkMethod(expression2, true, holder);
                            break;
                        }
                        case "getConstructor": {
                            JavaReflectionMemberAccessInspection.this.checkConstructor(expression2, false, holder);
                            break;
                        }
                        case "getDeclaredConstructor": {
                            JavaReflectionMemberAccessInspection.this.checkConstructor(expression2, true, holder);
                        }
                    }
                }
            }
        };
    }

    private void checkField(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        PsiExpression nameExpression;
        String fieldName;
        PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
        if (arguments.length != 0 && (fieldName = JavaReflectionMemberAccessInspection.getMemberName(nameExpression = arguments[0])) != null && (ownerClass = JavaReflectionMemberAccessInspection.getOwnerClass(callExpression)) != null && ownerClass.isExact()) {
            PsiField field = ownerClass.getPsiClass().findFieldByName(fieldName, true);
            if (field == null) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.cannot.resolve.field", (Object[])new Object[]{fieldName}), new LocalQuickFix[0]);
                }
                return;
            }
            if (isDeclared && field.getContainingClass() != ownerClass.getPsiClass()) {
                UseAppropriateMethodFix fix = field.hasModifierProperty("public") ? new UseAppropriateMethodFix("getField") : null;
                holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.field.not.in.class", (Object[])new Object[]{fieldName, ownerClass.getPsiClass().getQualifiedName()}), new LocalQuickFix[]{fix});
                return;
            }
            if (!isDeclared && !field.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.field.not.public", (Object[])new Object[]{fieldName}), new LocalQuickFix[]{new UseAppropriateMethodFix("getDeclaredField")});
            }
        }
    }

    private void checkMethod(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        PsiExpression nameExpression;
        String methodName;
        PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
        if (arguments.length != 0 && (methodName = JavaReflectionMemberAccessInspection.getMemberName(nameExpression = arguments[0])) != null && (ownerClass = JavaReflectionMemberAccessInspection.getOwnerClass(callExpression)) != null && ownerClass.isExact()) {
            PsiMethod[] methods = ownerClass.getPsiClass().findMethodsByName(methodName, true);
            if (methods.length == 0) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.cannot.resolve.method", (Object[])new Object[]{methodName}), new LocalQuickFix[0]);
                }
                return;
            }
            PsiMethod matchingMethod = JavaReflectionMemberAccessInspection.matchMethod(methods, arguments, 1);
            if (matchingMethod == null) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.cannot.resolve.method.arguments", (Object[])new Object[]{methodName}), new LocalQuickFix[0]);
                }
                return;
            }
            if (isDeclared && matchingMethod.getContainingClass() != ownerClass.getPsiClass()) {
                UseAppropriateMethodFix fix = matchingMethod.hasModifierProperty("public") ? new UseAppropriateMethodFix("getMethod") : null;
                holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.method.not.in.class", (Object[])new Object[]{methodName, ownerClass.getPsiClass().getQualifiedName()}), new LocalQuickFix[]{fix});
                return;
            }
            if (!isDeclared && !matchingMethod.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)nameExpression, JavaBundle.message((String)"inspection.reflection.member.access.method.not.public", (Object[])new Object[]{methodName}), new LocalQuickFix[]{new UseAppropriateMethodFix("getDeclaredMethod")});
            }
        }
    }

    private void checkConstructor(@NotNull PsiMethodCallExpression callExpression, boolean isDeclared, @NotNull ProblemsHolder holder) {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass = JavaReflectionMemberAccessInspection.getOwnerClass(callExpression);
        if (ownerClass != null && ownerClass.isExact()) {
            PsiMethod constructorOrClass;
            PsiMethod[] methods = ownerClass.getPsiClass().getConstructors();
            PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
            if (methods.length != 0) {
                constructorOrClass = JavaReflectionMemberAccessInspection.matchMethod(methods, arguments, 0);
            } else {
                PsiClass psiClass = constructorOrClass = arguments.length == 0 ? ownerClass.getPsiClass() : null;
            }
            if (constructorOrClass == null) {
                if (this.reportUnresolvedMembersOf(ownerClass)) {
                    holder.registerProblem((PsiElement)callExpression.getArgumentList(), JavaBundle.message((String)"inspection.reflection.member.access.cannot.resolve.constructor.arguments", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
                return;
            }
            if (!isDeclared && !constructorOrClass.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)callExpression.getArgumentList(), JavaBundle.message((String)"inspection.reflection.member.access.constructor.not.public", (Object[])new Object[0]), new LocalQuickFix[]{new UseAppropriateMethodFix("getDeclaredConstructor")});
            }
        }
    }

    private boolean reportUnresolvedMembersOf(@NotNull JavaReflectionReferenceUtil.ReflectiveClass ownerClass) {
        return (this.checkMemberExistsInNonFinalClasses || ownerClass.getPsiClass().hasModifierProperty("final")) && !this.ignoredClassNames.contains(ownerClass.getPsiClass().getQualifiedName());
    }

    @Contract(value="null->null")
    @Nullable
    private static String getMemberName(@Nullable PsiExpression memberNameArgument) {
        return JavaReflectionReferenceUtil.computeConstantExpression(memberNameArgument, String.class);
    }

    @Nullable
    private static JavaReflectionReferenceUtil.ReflectiveClass getOwnerClass(@NotNull PsiMethodCallExpression callExpression) {
        return JavaReflectionReferenceUtil.getReflectiveClass(callExpression.getMethodExpression().getQualifierExpression());
    }

    @Nullable
    private static PsiMethod matchMethod(PsiMethod[] methods, PsiExpression[] arguments, int argumentOffset) {
        JavaReflectionInvocationInspection.Arguments methodArguments = JavaReflectionInvocationInspection.getActualMethodArguments(arguments, argumentOffset, true);
        if (methodArguments == null) {
            return null;
        }
        List argumentTypes = ContainerUtil.map((Object[])methodArguments.expressions, JavaReflectionReferenceUtil::getReflectiveType);
        return JavaLangClassMemberReference.matchMethod(methods, argumentTypes);
    }

    static final class UseAppropriateMethodFix
    implements LocalQuickFix {
        private final String myProperMethod;

        UseAppropriateMethodFix(String method) {
            this.myProperMethod = method;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.use", (Object[])new Object[]{this.myProperMethod + "()"});
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.reflection.member.access.fix.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiExpressionList.class});
            if (expressionList == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expressionList.getParent(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            ExpressionUtils.bindCallTo(call, this.myProperMethod);
        }
    }
}

