/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.optionalToIf.Instruction;
import com.intellij.codeInspection.optionalToIf.IntermediateOperation;
import com.intellij.codeInspection.optionalToIf.Operation;
import com.intellij.codeInspection.optionalToIf.OptionalToIfContext;
import com.intellij.codeInspection.optionalToIf.Simplifier;
import com.intellij.codeInspection.optionalToIf.SourceOperation;
import com.intellij.codeInspection.optionalToIf.TerminalOperation;
import com.intellij.codeInspection.streamToLoop.ChainVariable;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalToIfInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Set<String> SUPPORTED_TERMINALS = ContainerUtil.set((Object[])new String[]{"get", "orElse", "ifPresent", "orElseGet", "ifPresentOrElse", "isPresent", "isEmpty", "stream", "orElseThrow"});

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression terminalCall) {
                String methodName = terminalCall.getMethodExpression().getReferenceName();
                if (methodName == null || !SUPPORTED_TERMINALS.contains(methodName)) {
                    return;
                }
                List<Operation> operations = OptionalToIfInspection.extractOperations(terminalCall, true);
                if (operations == null || operations.size() < 1 || !(operations.get(0) instanceof SourceOperation)) {
                    return;
                }
                OptionalToIfContext context = OptionalToIfContext.create((PsiExpression)terminalCall);
                if (context == null) {
                    return;
                }
                holder.registerProblem((PsiElement)terminalCall, JavaBundle.message((String)"inspection.message.replace.optional.with.if.statements", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceOptionalWithIfFix()});
            }
        };
    }

    @Nullable
    static List<Operation> extractOperations(@NotNull PsiMethodCallExpression lastCall, boolean hasTerminalCall) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        PsiMethodCallExpression call = lastCall;
        while (call != null) {
            PsiType type2;
            PsiMethod method = call.resolveMethod();
            if (method == null || !OptionalToIfInspection.isOptionalMethod(method)) {
                return null;
            }
            PsiType psiType = type2 = call == lastCall && hasTerminalCall ? call.getType() : OptionalUtil.getOptionalElementType(call.getType());
            if (type2 == null) {
                return null;
            }
            String name2 = call.getMethodExpression().getReferenceName();
            if (name2 == null) {
                return null;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            Operation operation = OptionalToIfInspection.convertToOperation(name2, type2, args);
            if (operation == null) {
                return null;
            }
            operations.add(operation);
            call = MethodCallUtils.getQualifierMethodCall(call);
        }
        Collections.reverse(operations);
        return operations;
    }

    @Nullable
    private static Operation convertToOperation(@NotNull String name2, @NotNull PsiType type2, PsiExpression @NotNull [] args) {
        Operation operation = IntermediateOperation.create(name2, args);
        if (operation != null) {
            return operation;
        }
        operation = TerminalOperation.create(name2, args);
        if (operation != null) {
            return operation;
        }
        return SourceOperation.create(name2, type2, args);
    }

    private static boolean isOptionalMethod(@NotNull PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        return aClass != null && OptionalUtil.isJdkOptionalClassName(aClass.getQualifiedName());
    }

    private static StreamEx<OperationRecord> allOperations(List<OperationRecord> operations) {
        return StreamEx.of(operations).flatMap(or -> or.myOperation.nestedOperations().append(or));
    }

    @Nullable
    static String generateCode(@NotNull OptionalToIfContext context, @NotNull List<Operation> operations) {
        List<OperationRecord> records = OptionalToIfInspection.createRecords(operations);
        OptionalToIfInspection.allOperations(records).forEach(r -> r.myOperation.preprocessVariables(r.myInVar, r.myOutVar, context));
        ((StreamEx)((StreamEx)OptionalToIfInspection.allOperations(records).map(r -> r.myOutVar).distinct()).filter(v -> !v.isRegistered())).forEach(v -> v.register(context));
        return OptionalToIfInspection.wrapCode(context, records, "");
    }

    @Nullable
    static String wrapCode(@NotNull OptionalToIfContext context, @NotNull List<OperationRecord> records, @NotNull String code) {
        for (int i = records.size() - 1; i >= 0; --i) {
            OperationRecord record = records.get(i);
            Operation operation = record.myOperation;
            ChainVariable inVar = record.myInVar;
            ChainVariable outVar = record.myOutVar;
            if ((code = operation.generate(inVar, outVar, code, context)) == null) {
                return null;
            }
            if (!(operation instanceof IntermediateOperation.Or)) continue;
            context.addBeforeStep(outVar.getDeclaration("null"));
            context.setElseBranch(null);
            List<OperationRecord> rest = records.subList(0, i);
            String beforeCode = OptionalToIfInspection.wrapCode(context, rest, outVar.getName() + "=" + inVar.getName() + ";");
            if (beforeCode == null) {
                return null;
            }
            return beforeCode + code;
        }
        return code;
    }

    @NotNull
    public static List<OperationRecord> createRecords(@NotNull List<Operation> operations) {
        ChainVariable inVar = ChainVariable.STUB;
        ArrayList<OperationRecord> records = new ArrayList<OperationRecord>(operations.size());
        for (Operation operation : operations) {
            ChainVariable outVar = operation.getOutVar(inVar);
            records.add(new OperationRecord(inVar, outVar, operation));
            inVar = outVar;
        }
        return records;
    }

    @Nullable
    static List<Instruction> createInstructions(PsiStatement @NotNull [] statements) {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>(statements.length);
        for (PsiStatement statement : statements) {
            Instruction instruction = Instruction.create(statement);
            if (instruction == null) {
                return null;
            }
            instructions.add(instruction);
        }
        return instructions;
    }

    private static PsiStatement @NotNull [] addStatements(@NotNull PsiElementFactory factory, @NotNull PsiStatement chainStatement, @NotNull String code) {
        Object[] statements = ControlFlowUtils.unwrapBlock(factory.createStatementFromText("{\n" + code + "\n}", (PsiElement)chainStatement));
        PsiElement parent = chainStatement.getParent();
        return (PsiStatement[])ContainerUtil.map((Object[])statements, s -> (PsiStatement)parent.addBefore((PsiElement)s, (PsiElement)chainStatement), (Object[])PsiStatement.EMPTY_ARRAY);
    }

    private static class ReplaceOptionalWithIfFix
    implements LocalQuickFix {
        private ReplaceOptionalWithIfFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"quickfix.family.replace.optional.chain.with.if.statements", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            List<Instruction> instructions;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiMethodCallExpression chainExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiMethodCallExpression.class);
            if (chainExpression == null) {
                return;
            }
            PsiStatement chainStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)chainExpression, PsiStatement.class);
            if (chainStatement == null) {
                return;
            }
            List<Operation> operations = OptionalToIfInspection.extractOperations(chainExpression, true);
            if (operations == null || operations.size() == 0) {
                return;
            }
            OptionalToIfContext context = OptionalToIfContext.create((PsiExpression)chainExpression);
            if (context == null) {
                return;
            }
            String code = OptionalToIfInspection.generateCode(context, operations);
            if (code == null) {
                return;
            }
            code = context.addInitializer(code);
            PsiStatement firstStatement = chainStatement;
            PsiStatement[] statements = OptionalToIfInspection.addStatements(factory, chainStatement, code);
            if (statements.length > 0) {
                firstStatement = statements[0];
            }
            if ((instructions = OptionalToIfInspection.createInstructions(statements)) != null) {
                code = Simplifier.simplify(instructions);
                Arrays.stream(statements).forEach(PsiElement::delete);
                statements = OptionalToIfInspection.addStatements(factory, chainStatement, code);
                firstStatement = statements.length > 0 ? statements[0] : chainStatement;
            }
            CommentTracker tracker = new CommentTracker();
            tracker.grabComments((PsiElement)chainStatement);
            tracker.insertCommentsBefore((PsiElement)firstStatement);
            chainStatement.delete();
        }
    }

    static class OperationRecord {
        final Operation myOperation;
        ChainVariable myInVar;
        ChainVariable myOutVar;

        @Contract(pure=true)
        OperationRecord(ChainVariable inVar, ChainVariable outVar, Operation operation) {
            this.myInVar = inVar;
            this.myOutVar = outVar;
            this.myOperation = operation;
        }
    }
}

