/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.nullable.AnnotateOverriddenMethodParameterFix;
import com.intellij.codeInspection.nullable.ChangeNullableDefaultsFix;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.psi.impl.search.JavaOverridingMethodsSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullableStuffInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    @Deprecated
    public boolean REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = true;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_GETTER = true;
    public boolean IGNORE_EXTERNAL_SUPER_NOTNULL;
    public boolean REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_SETTER_PARAMETER = true;
    @Deprecated
    public boolean REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = true;
    public boolean REPORT_NULLS_PASSED_TO_NON_ANNOTATED_METHOD = true;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    private static final Logger LOG = Logger.getInstance(NullableStuffInspectionBase.class);

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        super.writeSettings(node);
        for (Element child : new ArrayList(node.getChildren())) {
            String name2 = child.getAttributeValue("name");
            String value2 = child.getAttributeValue("value");
            if (!("IGNORE_EXTERNAL_SUPER_NOTNULL".equals(name2) && "false".equals(value2) || "REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED".equals(name2) && "false".equals(value2) || "REQUIRE_NOTNULL_FIELDS_INITIALIZED".equals(name2) && "true".equals(value2)) && (!"REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER".equals(name2) || !"true".equals(value2))) continue;
            node.removeContent((Content)child);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        final PsiFile file = holder.getFile();
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) || NullableStuffInspectionBase.nullabilityAnnotationsNotAvailable(file)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                NullableStuffInspectionBase.this.checkNullableStuffForMethod(method, holder, isOnTheFly);
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                NullableStuffInspectionBase.this.checkMethodReference(expression2, holder);
                JavaResolveResult result = expression2.advancedResolve(false);
                PsiElement target = result.getElement();
                if (target instanceof PsiMethod) {
                    this.checkCollectionNullityOnAssignment((PsiElement)expression2, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression2), result.getSubstitutor().substitute(((PsiMethod)target).getReturnType()));
                }
            }

            public void visitField(PsiField field) {
                PsiType type2 = field.getType();
                Annotated annotated = NullableStuffInspectionBase.check((PsiModifierListOwner)field, holder, type2);
                if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2)) {
                    return;
                }
                Project project = holder.getProject();
                NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
                if (annotated.isDeclaredNotNull ^ annotated.isDeclaredNullable) {
                    String anno = annotated.isDeclaredNotNull ? manager.getDefaultNotNull() : manager.getDefaultNullable();
                    List annoToRemove = annotated.isDeclaredNotNull ? manager.getNullables() : manager.getNotNulls();
                    NullableStuffInspectionBase.this.checkAccessors(field, annotated, project, manager, anno, annoToRemove, holder);
                    NullableStuffInspectionBase.this.checkConstructorParameters(field, annotated, manager, anno, annoToRemove, holder);
                }
            }

            public void visitParameter(PsiParameter parameter2) {
                NullableStuffInspectionBase.check((PsiModifierListOwner)parameter2, holder, parameter2.getType());
            }

            public void visitTypeElement(PsiTypeElement type2) {
                NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)type2.getProject());
                List<PsiAnnotation> annotations = this.getExclusiveAnnotations(type2);
                NullableStuffInspectionBase.checkType(null, holder, type2.getType(), (PsiAnnotation)ContainerUtil.find(annotations, a -> manager.getNotNulls().contains(a.getQualifiedName())), (PsiAnnotation)ContainerUtil.find(annotations, a -> manager.getNullables().contains(a.getQualifiedName())));
            }

            private List<PsiAnnotation> getExclusiveAnnotations(PsiTypeElement type2) {
                PsiModifierList modifierList;
                ArrayList annotations = ContainerUtil.newArrayList((Object[])type2.getAnnotations());
                PsiTypeElement topMost = (PsiTypeElement)Objects.requireNonNull(SyntaxTraverser.psiApi().parents((Object)type2).filter(PsiTypeElement.class).last());
                PsiElement parent = topMost.getParent();
                if (parent instanceof PsiModifierListOwner && type2.getType().equals(topMost.getType().getDeepComponentType()) && (modifierList = ((PsiModifierListOwner)parent).getModifierList()) != null) {
                    PsiAnnotation.TargetType[] targets = (PsiAnnotation.TargetType[])ArrayUtil.remove((Object[])AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)modifierList), (Object)PsiAnnotation.TargetType.TYPE_USE);
                    annotations.addAll(ContainerUtil.filter((Object[])modifierList.getAnnotations(), a -> AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)a) && AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)a, (PsiAnnotation.TargetType[])targets) == null));
                }
                return annotations;
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiClass psiClass;
                if (!"org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiAnnotationMemberValue value2 = annotation.findDeclaredAttributeValue("exception");
                if (value2 instanceof PsiClassObjectAccessExpression && (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiClassObjectAccessExpression)value2).getOperand().getType())) != null && !this.hasStringConstructor(psiClass)) {
                    holder.registerProblem((PsiElement)value2, JavaAnalysisBundle.message((String)"custom.exception.class.should.have.a.constructor", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }

            private boolean hasStringConstructor(PsiClass aClass) {
                for (PsiMethod method : aClass.getConstructors()) {
                    PsiParameterList list = method.getParameterList();
                    if (list.getParametersCount() != 1 || !Objects.requireNonNull(list.getParameter(0)).getType().equalsToText("java.lang.String")) continue;
                    return true;
                }
                return false;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                String error;
                super.visitReferenceElement(reference);
                this.checkNullableNotNullInstantiationConflict(reference);
                PsiElement list = reference.getParent();
                PsiElement psiClass = list instanceof PsiReferenceList ? list.getParent() : null;
                PsiElement intf = reference.resolve();
                if (psiClass instanceof PsiClass && list == ((PsiClass)psiClass).getImplementsList() && intf instanceof PsiClass && ((PsiClass)intf).isInterface() && (error = NullableStuffInspectionBase.this.checkIndirectInheritance(psiClass, (PsiClass)intf)) != null) {
                    holder.registerProblem((PsiElement)reference, error, new LocalQuickFix[0]);
                }
            }

            private void checkNullableNotNullInstantiationConflict(PsiJavaCodeReferenceElement reference) {
                PsiElement element = reference.resolve();
                if (element instanceof PsiClass) {
                    PsiTypeParameter[] typeParameters = ((PsiClass)element).getTypeParameters();
                    PsiTypeElement[] typeArguments = this.getReferenceTypeArguments(reference);
                    if (typeParameters.length > 0 && typeParameters.length == typeArguments.length && !(typeArguments[0].getType() instanceof PsiDiamondType)) {
                        for (int i = 0; i < typeParameters.length; ++i) {
                            if (DfaPsiUtil.getTypeNullability((PsiType)JavaPsiFacade.getElementFactory((Project)element.getProject()).createType((PsiClass)typeParameters[i])) != Nullability.NOT_NULL || DfaPsiUtil.getTypeNullability(typeArguments[i].getType()) == Nullability.NOT_NULL) continue;
                            holder.registerProblem((PsiElement)typeArguments[i], JavaAnalysisBundle.message((String)"non.null.type.argument.is.expected", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                        }
                    }
                }
            }

            private PsiTypeElement[] getReferenceTypeArguments(PsiJavaCodeReferenceElement reference) {
                PsiReferenceParameterList typeArgList = reference.getParameterList();
                return typeArgList == null ? PsiTypeElement.EMPTY_ARRAY : typeArgList.getTypeParameterElements();
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                this.checkCollectionNullityOnAssignment((PsiElement)expression2.getOperationSign(), expression2.getLExpression().getType(), expression2.getRExpression());
            }

            public void visitLocalVariable(PsiLocalVariable variable) {
                PsiIdentifier identifier = variable.getNameIdentifier();
                if (identifier != null) {
                    this.checkCollectionNullityOnAssignment((PsiElement)identifier, variable.getType(), variable.getInitializer());
                }
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                PsiExpression returnValue = statement.getReturnValue();
                if (returnValue == null) {
                    return;
                }
                this.checkCollectionNullityOnAssignment((PsiElement)statement.getReturnValue(), PsiTypesUtil.getMethodReturnType((PsiElement)statement), returnValue);
            }

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                super.visitLambdaExpression(lambda2);
                PsiElement body2 = lambda2.getBody();
                if (body2 instanceof PsiExpression) {
                    this.checkCollectionNullityOnAssignment(body2, LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2), (PsiExpression)body2);
                }
            }

            public void visitCallExpression(PsiCallExpression callExpression) {
                PsiExpressionList argList = callExpression.getArgumentList();
                JavaResolveResult result = callExpression.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)result.getElement();
                if (method == null || argList == null) {
                    return;
                }
                PsiSubstitutor substitutor = result.getSubstitutor();
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                PsiExpression[] arguments = argList.getExpressions();
                for (int i = 0; i < arguments.length; ++i) {
                    PsiExpression argument = arguments[i];
                    if (i >= parameters2.length || i >= parameters2.length - 1 && MethodCallInstruction.isVarArgCall(method, substitutor, arguments, parameters2)) continue;
                    this.checkCollectionNullityOnAssignment((PsiElement)argument, substitutor.substitute(parameters2[i].getType()), argument);
                }
            }

            private void checkCollectionNullityOnAssignment(@NotNull PsiElement errorElement, @Nullable PsiType expectedType, @Nullable PsiExpression assignedExpression) {
                if (assignedExpression == null) {
                    return;
                }
                this.checkCollectionNullityOnAssignment(errorElement, expectedType, assignedExpression.getType());
            }

            private void checkCollectionNullityOnAssignment(@NotNull PsiElement errorElement, @Nullable PsiType expectedType, @Nullable PsiType assignedType) {
                if (NullableStuffInspectionBase.isNullableNotNullCollectionConflict(expectedType, assignedType, file, new HashSet())) {
                    holder.registerProblem(errorElement, JavaAnalysisBundle.message((String)"assigning.a.collection.of.nullable.elements", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
        };
    }

    private static boolean isNullableNotNullCollectionConflict(@Nullable PsiType expectedType, @Nullable PsiType assignedType, @NotNull PsiFile place, @NotNull Set<? super Couple<PsiType>> visited) {
        if (!visited.add((Couple<PsiType>)Couple.of((Object)expectedType, (Object)assignedType))) {
            return false;
        }
        GlobalSearchScope scope = place.getResolveScope();
        if (NullableStuffInspectionBase.isNullityConflict(JavaGenericsUtil.getCollectionItemType((PsiType)expectedType, (GlobalSearchScope)scope), JavaGenericsUtil.getCollectionItemType((PsiType)assignedType, (GlobalSearchScope)scope))) {
            return true;
        }
        for (int i = 0; i <= 1; ++i) {
            PsiType assignedArg;
            PsiType expectedArg = PsiUtil.substituteTypeParameter((PsiType)expectedType, (String)"java.util.Map", (int)i, (boolean)false);
            if (!NullableStuffInspectionBase.isNullityConflict(expectedArg, assignedArg = PsiUtil.substituteTypeParameter((PsiType)assignedType, (String)"java.util.Map", (int)i, (boolean)false)) && (expectedArg == null || assignedArg == null || !NullableStuffInspectionBase.isNullableNotNullCollectionConflict(expectedArg, assignedArg, place, visited))) continue;
            return true;
        }
        return false;
    }

    private static boolean isNullityConflict(PsiType expected, PsiType assigned) {
        return DfaPsiUtil.getTypeNullability(expected) == Nullability.NOT_NULL && DfaPsiUtil.getTypeNullability(assigned) == Nullability.NULLABLE;
    }

    @Nullable
    private String checkIndirectInheritance(PsiElement psiClass, PsiClass intf) {
        for (PsiMethod intfMethod : intf.getAllMethods()) {
            String error;
            PsiClass overridingMethodClass;
            PsiClass intfMethodClass = intfMethod.getContainingClass();
            PsiMethod overridingMethod = intfMethodClass == null ? null : JavaOverridingMethodsSearcher.findOverridingMethod((PsiClass)psiClass, intfMethod, intfMethodClass);
            PsiClass psiClass2 = overridingMethodClass = overridingMethod == null ? null : overridingMethod.getContainingClass();
            if (overridingMethodClass == null || overridingMethodClass == psiClass || (error = this.checkIndirectInheritance(intfMethod, intfMethodClass, overridingMethod, overridingMethodClass)) == null) continue;
            return error;
        }
        return null;
    }

    @Nullable
    private String checkIndirectInheritance(PsiMethod intfMethod, PsiClass intfMethodClass, PsiMethod overridingMethod, PsiClass overridingMethodClass) {
        PsiParameter[] superParameters;
        if (this.isNullableOverridingNotNull(Annotated.from((PsiModifierListOwner)overridingMethod), intfMethod)) {
            return "Nullable method '" + overridingMethod.getName() + "' from '" + overridingMethodClass.getName() + "' implements non-null method from '" + intfMethodClass.getName() + "'";
        }
        if (this.isNonAnnotatedOverridingNotNull(overridingMethod, intfMethod)) {
            return "Non-annotated method '" + overridingMethod.getName() + "' from '" + overridingMethodClass.getName() + "' implements non-null method from '" + intfMethodClass.getName() + "'";
        }
        PsiParameter[] overridingParameters = overridingMethod.getParameterList().getParameters();
        if (overridingParameters.length == (superParameters = intfMethod.getParameterList().getParameters()).length) {
            NullableNotNullManager manager = NullableStuffInspectionBase.getNullityManager(intfMethod);
            for (int i = 0; i < overridingParameters.length; ++i) {
                PsiParameter parameter2 = overridingParameters[i];
                List<PsiParameter> supers = Collections.singletonList(superParameters[i]);
                if (this.findNullableSuperForNotNullParameter(parameter2, supers) != null) {
                    return "Non-null parameter '" + parameter2.getName() + "' in method '" + overridingMethod.getName() + "' from '" + overridingMethodClass.getName() + "' should not override nullable parameter from '" + intfMethodClass.getName() + "'";
                }
                if (this.findNotNullSuperForNonAnnotatedParameter(manager, parameter2, supers) != null) {
                    return "Non-annotated parameter '" + parameter2.getName() + "' in method '" + overridingMethod.getName() + "' from '" + overridingMethodClass.getName() + "' should not override non-null parameter from '" + intfMethodClass.getName() + "'";
                }
                if (!this.isNotNullParameterOverridingNonAnnotated(manager, parameter2, supers)) continue;
                return "Non-null parameter '" + parameter2.getName() + "' in method '" + overridingMethod.getName() + "' from '" + overridingMethodClass.getName() + "' should not override non-annotated parameter from '" + intfMethodClass.getName() + "'";
            }
        }
        return null;
    }

    private void checkMethodReference(PsiMethodReferenceExpression expression2, @NotNull ProblemsHolder holder) {
        PsiMethod superMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)expression2);
        PsiMethod targetMethod = (PsiMethod)ObjectUtils.tryCast((Object)expression2.resolve(), PsiMethod.class);
        if (superMethod == null || targetMethod == null) {
            return;
        }
        PsiElement refName = expression2.getReferenceNameElement();
        assert (refName != null);
        if (this.isNullableOverridingNotNull(NullableStuffInspectionBase.check((PsiModifierListOwner)targetMethod, holder, expression2.getType()), superMethod)) {
            holder.registerProblem(refName, JavaAnalysisBundle.message((String)"inspection.nullable.problems.Nullable.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)targetMethod), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        } else if (this.isNonAnnotatedOverridingNotNull(targetMethod, superMethod)) {
            holder.registerProblem(refName, JavaAnalysisBundle.message((String)"not.annotated.method.is.used.as.an.override.for.a.method.annotated.with.0", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{NullableStuffInspectionBase.createFixForNonAnnotatedOverridesNotNull(targetMethod, superMethod)});
        }
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter2) {
        return null;
    }

    private static boolean nullabilityAnnotationsNotAvailable(PsiFile file) {
        Project project = file.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        return ContainerUtil.find((Iterable)NullableNotNullManager.getInstance((Project)project).getNullables(), s -> facade.findClass(s, scope) != null) == null;
    }

    private static boolean checkNonStandardAnnotations(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, @NotNull ProblemsHolder holder) {
        if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)field, (String)anno)) {
            String message2 = "Not '";
            PsiAnnotation annotation = Objects.requireNonNull(annotated.isDeclaredNullable ? annotated.nullable : annotated.notNull);
            message2 = message2 + annotation.getQualifiedName();
            message2 = message2 + "' but '" + anno + "' would be used for code generation.";
            PsiJavaCodeReferenceElement annotationNameReferenceElement = annotation.getNameReferenceElement();
            holder.registerProblem((PsiElement)(annotationNameReferenceElement != null && annotationNameReferenceElement.isPhysical() ? annotationNameReferenceElement : field.getNameIdentifier()), message2, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new ChangeNullableDefaultsFix(annotated.notNull, annotated.nullable, manager)});
            return false;
        }
        return true;
    }

    private void checkAccessors(PsiField field, Annotated annotated, Project project, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        PsiClass containingClass;
        PsiMethod setter;
        PsiIdentifier nameIdentifier;
        String propName = JavaCodeStyleManager.getInstance((Project)project).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
        boolean isStatic = field.hasModifierProperty("static");
        PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)field.getContainingClass(), (String)propName, (boolean)isStatic, (boolean)false);
        PsiIdentifier psiIdentifier = nameIdentifier = getter == null ? null : getter.getNameIdentifier();
        if (nameIdentifier != null && nameIdentifier.isPhysical() && PropertyUtil.getFieldOfGetter(getter) == field) {
            AnnotateMethodFix getterAnnoFix = new AnnotateMethodFix(anno, ArrayUtilRt.toStringArray(annoToRemove));
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)getter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)getter.getReturnType())) {
                holder.registerProblem((PsiElement)nameIdentifier, JavaAnalysisBundle.message((String)"inspection.nullable.problems.annotated.field.getter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{getterAnnoFix});
            }
            if (annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)getter, false) || annotated.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)getter, false, false)) {
                holder.registerProblem((PsiElement)nameIdentifier, JavaAnalysisBundle.message((String)"inspection.nullable.problems.annotated.field.getter.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)getter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{getterAnnoFix});
            }
        }
        if ((setter = PropertyUtilBase.findPropertySetter((PsiClass)(containingClass = field.getContainingClass()), (String)propName, (boolean)isStatic, (boolean)false)) != null && setter.isPhysical() && PropertyUtil.getFieldOfSetter(setter) == field) {
            PsiIdentifier parameterName;
            PsiParameter[] parameters2 = setter.getParameterList().getParameters();
            assert (parameters2.length == 1) : setter.getText();
            PsiParameter parameter2 = parameters2[0];
            LOG.assertTrue(parameter2 != null, (Object)setter.getText());
            AddAnnotationPsiFix addAnnoFix = NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter2);
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)parameter2) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter2.getType())) {
                parameterName = parameter2.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter2, parameterName);
                holder.registerProblem((PsiElement)parameterName, JavaAnalysisBundle.message((String)"inspection.nullable.problems.annotated.field.setter.parameter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{addAnnoFix});
            }
            if (PropertyUtil.isSimpleSetter(setter) && annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)parameter2, false)) {
                parameterName = parameter2.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter, parameter2, parameterName);
                holder.registerProblem((PsiElement)parameterName, JavaAnalysisBundle.message((String)"inspection.nullable.problems.annotated.field.setter.parameter.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter2)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{addAnnoFix});
            }
        }
    }

    @NotNull
    private static AddAnnotationPsiFix createAddAnnotationFix(String anno, List<String> annoToRemove, PsiParameter parameter2) {
        return new AddAnnotationPsiFix(anno, (PsiModifierListOwner)parameter2, PsiNameValuePair.EMPTY_ARRAY, ArrayUtilRt.toStringArray(annoToRemove));
    }

    @Contract(value="_,_,null -> fail")
    private static void assertValidElement(PsiMethod setter, PsiParameter parameter2, PsiIdentifier nameIdentifier1) {
        LOG.assertTrue(nameIdentifier1 != null && nameIdentifier1.isPhysical(), (Object)setter.getText());
        LOG.assertTrue(parameter2.isPhysical(), (Object)setter.getText());
    }

    private void checkConstructorParameters(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        List<PsiExpression> initializers = DfaPsiUtil.findAllConstructorInitializers(field);
        if (initializers.isEmpty()) {
            return;
        }
        ArrayList<PsiParameter> notNullParams = new ArrayList<PsiParameter>();
        boolean isFinal = field.hasModifierProperty("final");
        for (PsiExpression rhs : initializers) {
            PsiIdentifier nameIdentifier;
            PsiElement target;
            if (!(rhs instanceof PsiReferenceExpression) || !NullableStuffInspectionBase.isConstructorParameter(target = ((PsiReferenceExpression)rhs).resolve()) || !target.isPhysical()) continue;
            PsiParameter parameter2 = (PsiParameter)target;
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)parameter2) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter2.getType()) && (nameIdentifier = parameter2.getNameIdentifier()) != null && nameIdentifier.isPhysical()) {
                holder.registerProblem((PsiElement)nameIdentifier, JavaAnalysisBundle.message((String)"inspection.nullable.problems.annotated.field.constructor.parameter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter2)});
                continue;
            }
            if (!isFinal || !annotated.isDeclaredNullable || !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter2, false, false)) continue;
            notNullParams.add(parameter2);
        }
        if (notNullParams.size() != initializers.size()) {
            return;
        }
        PsiIdentifier nameIdentifier = field.getNameIdentifier();
        if (nameIdentifier.isPhysical()) {
            holder.registerProblem((PsiElement)nameIdentifier, JavaAnalysisBundle.message((String)"0.field.is.always.initialized.not.null", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{AddAnnotationPsiFix.createAddNotNullFix((PsiModifierListOwner)field)});
        }
    }

    private static boolean isConstructorParameter(@Nullable PsiElement parameter2) {
        return parameter2 instanceof PsiParameter && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiParameterList.class).withParent((ElementPattern)PsiJavaPatterns.psiMethod().constructor(true))).accepts((Object)parameter2.getParent());
    }

    @NotNull
    private static String getPresentableAnnoName(@NotNull PsiModifierListOwner owner2) {
        String name2;
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner2.getProject());
        NullabilityAnnotationInfo info = manager.findEffectiveNullabilityInfo(owner2);
        String string = name2 = info == null ? null : info.getAnnotation().getQualifiedName();
        if (name2 == null) {
            return "???";
        }
        return StringUtil.getShortName((String)name2);
    }

    public static String getPresentableAnnoName(@NotNull PsiAnnotation annotation) {
        return StringUtil.getShortName((String)StringUtil.notNullize((String)annotation.getQualifiedName(), (String)"???"));
    }

    private static Annotated check(PsiModifierListOwner owner2, ProblemsHolder holder, PsiType type2) {
        Annotated annotated = Annotated.from(owner2);
        NullableStuffInspectionBase.checkType(owner2, holder, type2, annotated.notNull, annotated.nullable);
        return annotated;
    }

    private static void checkType(@Nullable PsiModifierListOwner listOwner, ProblemsHolder holder, PsiType type2, @Nullable PsiAnnotation notNull, @Nullable PsiAnnotation nullable) {
        if (nullable != null && notNull != null) {
            NullableStuffInspectionBase.reportNullableNotNullConflict(holder, listOwner, nullable, notNull);
        }
        if ((notNull != null || nullable != null) && type2 != null && TypeConversionUtil.isPrimitive((String)type2.getCanonicalText())) {
            PsiAnnotation annotation;
            PsiAnnotation psiAnnotation = annotation = notNull == null ? nullable : notNull;
            if (listOwner == null || !annotation.isPhysical() || annotation.getOwner() == listOwner.getModifierList()) {
                NullableStuffInspectionBase.reportPrimitiveType(holder, annotation, listOwner);
            }
        }
        if (listOwner instanceof PsiParameter) {
            NullableStuffInspectionBase.checkLoopParameterNullability(holder, notNull, nullable, DfaPsiUtil.inferParameterNullability((PsiParameter)listOwner));
        }
    }

    private static void checkLoopParameterNullability(ProblemsHolder holder, @Nullable PsiAnnotation notNull, @Nullable PsiAnnotation nullable, Nullability expectedNullability) {
        if (notNull != null && expectedNullability == Nullability.NULLABLE) {
            holder.registerProblem((PsiElement)notNull, JavaAnalysisBundle.message((String)"parameter.can.be.null", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveAnnotationQuickFix(notNull, null)});
        } else if (nullable != null && expectedNullability == Nullability.NOT_NULL) {
            holder.registerProblem((PsiElement)nullable, JavaAnalysisBundle.message((String)"parameter.is.always.not.null", (Object[])new Object[0]), new LocalQuickFix[]{new RemoveAnnotationQuickFix(nullable, null)});
        }
    }

    private static void reportPrimitiveType(ProblemsHolder holder, PsiAnnotation annotation, @Nullable PsiModifierListOwner listOwner) {
        holder.registerProblem((PsiElement)(!annotation.isPhysical() && listOwner != null ? listOwner.getNavigationElement() : annotation), JavaAnalysisBundle.message((String)"inspection.nullable.problems.primitive.type.annotation", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(annotation, listOwner){

            @Override
            protected boolean shouldRemoveInheritors() {
                return true;
            }
        }});
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.probable.bugs", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "NullableProblems";
    }

    private void checkNullableStuffForMethod(PsiMethod method, ProblemsHolder holder, boolean isOnFly) {
        Annotated annotated = NullableStuffInspectionBase.check((PsiModifierListOwner)method, holder, method.getReturnType());
        List superMethods = ContainerUtil.map((Collection)method.findSuperMethodSignaturesIncludingStatic(true), MethodSignatureBackedByPsiMethod::getMethod);
        NullableNotNullManager nullableManager = NullableNotNullManager.getInstance((Project)holder.getProject());
        this.checkSupers(method, holder, annotated, superMethods);
        this.checkParameters(method, holder, superMethods, nullableManager, isOnFly);
        this.checkOverriders(method, holder, annotated, nullableManager);
    }

    private void checkSupers(PsiMethod method, ProblemsHolder holder, Annotated annotated, List<? extends PsiMethod> superMethods) {
        for (PsiMethod psiMethod : superMethods) {
            if (this.isNullableOverridingNotNull(annotated, psiMethod)) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Collection)NullableStuffInspectionBase.getNullityManager(method).getNullables(), (boolean)true);
                holder.registerProblem((PsiElement)(annotation != null ? annotation : method.getNameIdentifier()), JavaAnalysisBundle.message((String)"inspection.nullable.problems.Nullable.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)method), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)psiMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                break;
            }
            if (this.isNonAnnotatedOverridingNotNull(method, psiMethod)) {
                holder.registerProblem((PsiElement)method.getNameIdentifier(), JavaAnalysisBundle.message((String)"inspection.nullable.problems.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)psiMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{NullableStuffInspectionBase.createFixForNonAnnotatedOverridesNotNull(method, psiMethod)});
                break;
            }
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnTypeElement == null || !NullableStuffInspectionBase.isNullableNotNullCollectionConflict(psiMethod.getReturnType(), method.getReturnType(), holder.getFile(), new HashSet())) continue;
            holder.registerProblem((PsiElement)returnTypeElement, JavaAnalysisBundle.message((String)"nullable.stuff.error.overriding.notnull.with.nullable", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            break;
        }
    }

    private static NullableNotNullManager getNullityManager(PsiMethod method) {
        return NullableNotNullManager.getInstance((Project)method.getProject());
    }

    @Nullable
    private static LocalQuickFix createFixForNonAnnotatedOverridesNotNull(PsiMethod method, PsiMethod superMethod) {
        NullableNotNullManager nullableManager = NullableStuffInspectionBase.getNullityManager(method);
        return AnnotationUtil.isAnnotatingApplicable((PsiElement)method, (String)nullableManager.getDefaultNotNull()) ? AddAnnotationPsiFix.createAddNotNullFix((PsiModifierListOwner)method) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)superMethod);
    }

    private boolean isNullableOverridingNotNull(Annotated methodInfo, PsiMethod superMethod) {
        return this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && methodInfo.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superMethod, true, false);
    }

    private boolean isNonAnnotatedOverridingNotNull(PsiMethod method, PsiMethod superMethod) {
        return this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL && !(method.getReturnType() instanceof PsiPrimitiveType) && !method.isConstructor() && !NullableStuffInspectionBase.getNullityManager(method).hasNullability((PsiModifierListOwner)method) && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)superMethod, true, this.IGNORE_EXTERNAL_SUPER_NOTNULL) && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)superMethod);
    }

    private static boolean hasInheritableNotNull(PsiModifierListOwner owner2) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)owner2, (String)"javax.annotation.constraints.NotNull", (int)9);
    }

    private void checkParameters(PsiMethod method, ProblemsHolder holder, List<? extends PsiMethod> superMethods, NullableNotNullManager nullableManager, boolean isOnFly) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            if (parameter2.getType() instanceof PsiPrimitiveType) continue;
            List<PsiParameter> superParameters = NullableStuffInspectionBase.getSuperParameters(superMethods, parameters2, i);
            this.checkSuperParameterAnnotations(holder, nullableManager, parameter2, superParameters);
            this.checkNullLiteralArgumentOfNotNullParameterUsages(method, holder, nullableManager, isOnFly, i, parameter2);
        }
    }

    @NotNull
    private static List<PsiParameter> getSuperParameters(List<? extends PsiMethod> superMethods, PsiParameter[] parameters2, int i) {
        ArrayList<PsiParameter> superParameters = new ArrayList<PsiParameter>();
        for (PsiMethod psiMethod : superMethods) {
            PsiParameter[] _superParameters = psiMethod.getParameterList().getParameters();
            if (_superParameters.length != parameters2.length) continue;
            superParameters.add(_superParameters[i]);
        }
        return superParameters;
    }

    private void checkSuperParameterAnnotations(ProblemsHolder holder, NullableNotNullManager nullableManager, PsiParameter parameter2, List<PsiParameter> superParameters) {
        PsiTypeElement typeElement;
        PsiParameter notNullSuper;
        PsiParameter nullableSuper = this.findNullableSuperForNotNullParameter(parameter2, superParameters);
        if (nullableSuper != null) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter2, (Collection)nullableManager.getNotNulls(), (boolean)true);
            holder.registerProblem((PsiElement)(annotation != null ? annotation : parameter2.getNameIdentifier()), JavaAnalysisBundle.message((String)"inspection.nullable.problems.NotNull.parameter.overrides.Nullable", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter2), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)nullableSuper)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
        if ((notNullSuper = this.findNotNullSuperForNonAnnotatedParameter(nullableManager, parameter2, superParameters)) != null) {
            AddAnnotationPsiFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)parameter2, (String)nullableManager.getDefaultNotNull()) ? AddAnnotationPsiFix.createAddNotNullFix((PsiModifierListOwner)parameter2) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)notNullSuper);
            holder.registerProblem((PsiElement)parameter2.getNameIdentifier(), JavaAnalysisBundle.message((String)"inspection.nullable.problems.parameter.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)notNullSuper)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
        }
        if (this.isNotNullParameterOverridingNonAnnotated(nullableManager, parameter2, superParameters)) {
            NullabilityAnnotationInfo info = nullableManager.findOwnNullabilityInfo((PsiModifierListOwner)parameter2);
            assert (info != null);
            PsiAnnotation notNullAnnotation = info.getAnnotation();
            boolean physical = PsiTreeUtil.isAncestor((PsiElement)parameter2, (PsiElement)notNullAnnotation, (boolean)true);
            RemoveAnnotationQuickFix fix = physical ? new RemoveAnnotationQuickFix(notNullAnnotation, (PsiModifierListOwner)parameter2) : null;
            holder.registerProblem((PsiElement)(physical ? notNullAnnotation : parameter2.getNameIdentifier()), JavaAnalysisBundle.message((String)"inspection.nullable.problems.NotNull.parameter.overrides.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter2)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
        }
        if ((typeElement = parameter2.getTypeElement()) != null) {
            for (PsiParameter superParameter : superParameters) {
                if (!NullableStuffInspectionBase.isNullableNotNullCollectionConflict(parameter2.getType(), superParameter.getType(), holder.getFile(), new HashSet())) continue;
                holder.registerProblem((PsiElement)typeElement, JavaAnalysisBundle.message((String)"nullable.stuff.error.overriding.nullable.with.notnull", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                break;
            }
        }
    }

    @Nullable
    private PsiParameter findNotNullSuperForNonAnnotatedParameter(NullableNotNullManager nullableManager, PsiParameter parameter2, List<? extends PsiParameter> superParameters) {
        return this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL && !nullableManager.hasNullability((PsiModifierListOwner)parameter2) ? (PsiParameter)ContainerUtil.find(superParameters, sp -> NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)sp, false, this.IGNORE_EXTERNAL_SUPER_NOTNULL) && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)sp)) : null;
    }

    @Nullable
    private PsiParameter findNullableSuperForNotNullParameter(PsiParameter parameter2, List<? extends PsiParameter> superParameters) {
        return this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter2, false, false) ? (PsiParameter)ContainerUtil.find(superParameters, sp -> NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)sp, false)) : null;
    }

    private boolean isNotNullParameterOverridingNonAnnotated(NullableNotNullManager nullableManager, PsiParameter parameter2, List<? extends PsiParameter> superParameters) {
        if (!this.REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED) {
            return false;
        }
        NullabilityAnnotationInfo info = nullableManager.findOwnNullabilityInfo((PsiModifierListOwner)parameter2);
        return info != null && info.getNullability() == Nullability.NOT_NULL && !info.isInferred() && ContainerUtil.exists(superParameters, sp -> !nullableManager.hasNullability((PsiModifierListOwner)sp));
    }

    private void checkNullLiteralArgumentOfNotNullParameterUsages(PsiMethod method, ProblemsHolder holder, NullableNotNullManager nullableManager, boolean isOnFly, int parameterIdx, PsiParameter parameter2) {
        PsiIdentifier elementToHighlight;
        if (!this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER || !isOnFly) {
            return;
        }
        if (DfaPsiUtil.getTypeNullability(NullableStuffInspectionBase.getMemberType((PsiModifierListOwner)parameter2)) == Nullability.NOT_NULL) {
            elementToHighlight = parameter2.getNameIdentifier();
        } else {
            NullabilityAnnotationInfo info = nullableManager.findOwnNullabilityInfo((PsiModifierListOwner)parameter2);
            if (info == null || info.getNullability() != Nullability.NOT_NULL || info.isInferred()) {
                return;
            }
            PsiAnnotation notNullAnnotation = info.getAnnotation();
            boolean physical = PsiTreeUtil.isAncestor((PsiElement)parameter2, (PsiElement)notNullAnnotation, (boolean)true);
            Object object = elementToHighlight = physical ? notNullAnnotation : parameter2.getNameIdentifier();
        }
        if (elementToHighlight == null || !JavaNullMethodArgumentUtil.hasNullArgument(method, parameterIdx)) {
            return;
        }
        holder.registerProblem((PsiElement)elementToHighlight, JavaAnalysisBundle.message((String)"inspection.nullable.problems.NotNull.parameter.receives.null.literal", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter2)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.createNavigateToNullParameterUsagesFix(parameter2)});
    }

    private void checkOverriders(@NotNull PsiMethod method, @NotNull ProblemsHolder holder, @NotNull Annotated annotated, @NotNull NullableNotNullManager nullableManager) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS) {
            boolean checkReturnType;
            boolean[] checkParameter = new boolean[parameters2.length];
            boolean[] parameterQuickFixSuggested = new boolean[parameters2.length];
            boolean hasAnnotatedParameter = false;
            for (int i = 0; i < parameters2.length; ++i) {
                PsiParameter parameter2 = parameters2[i];
                checkParameter[i] = NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter2, false, false) && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)parameter2) && !(parameter2.getType() instanceof PsiPrimitiveType);
                hasAnnotatedParameter |= checkParameter[i];
            }
            boolean bl = checkReturnType = annotated.isDeclaredNotNull && !NullableStuffInspectionBase.hasInheritableNotNull((PsiModifierListOwner)method) && !(method.getReturnType() instanceof PsiPrimitiveType);
            if (hasAnnotatedParameter || checkReturnType) {
                String defaultNotNull = nullableManager.getDefaultNotNull();
                boolean superMethodApplicable = AnnotationUtil.isAnnotatingApplicable((PsiElement)method, (String)defaultNotNull);
                PsiMethod[] overridings = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY);
                boolean methodQuickFixSuggested = false;
                for (PsiMethod overriding : overridings) {
                    PsiAnnotation psiElement;
                    if (NullableStuffInspectionBase.shouldSkipOverriderAsGenerated(overriding)) continue;
                    if (!methodQuickFixSuggested && checkReturnType && !NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)overriding, false, false) && (NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)overriding, false) || !NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)overriding, true)) && AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)overriding, defaultNotNull)) {
                        PsiIdentifier identifier = method.getNameIdentifier();
                        NullabilityAnnotationInfo info = nullableManager.findOwnNullabilityInfo((PsiModifierListOwner)method);
                        LOG.assertTrue(info != null);
                        PsiAnnotation annotation = info.getAnnotation();
                        String[] annotationsToRemove = ArrayUtilRt.toStringArray((Collection)nullableManager.getNullables());
                        MyAnnotateMethodFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)overriding, (String)defaultNotNull) ? new MyAnnotateMethodFix(defaultNotNull, annotationsToRemove) : (superMethodApplicable ? null : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)method));
                        psiElement = annotation;
                        if (!annotation.isPhysical() && (psiElement = identifier) == null) continue;
                        holder.registerProblem((PsiElement)psiElement, JavaAnalysisBundle.message((String)"nullable.stuff.problems.overridden.methods.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                        methodQuickFixSuggested = true;
                    }
                    if (!hasAnnotatedParameter) continue;
                    PsiParameter[] psiParameters = overriding.getParameterList().getParameters();
                    for (int i = 0; i < psiParameters.length; ++i) {
                        if (parameterQuickFixSuggested[i]) continue;
                        PsiParameter parameter3 = psiParameters[i];
                        if (!checkParameter[i] || NullableStuffInspectionBase.isNotNullNotInferred((PsiModifierListOwner)parameter3, false, false) || NullableStuffInspectionBase.isNullableNotInferred((PsiModifierListOwner)parameter3, false) || !AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)parameter3, defaultNotNull)) continue;
                        PsiIdentifier identifier = parameters2[i].getNameIdentifier();
                        NullabilityAnnotationInfo info = nullableManager.findOwnNullabilityInfo((PsiModifierListOwner)parameters2[i]);
                        PsiAnnotation psiAnnotation = psiElement = info == null ? null : info.getAnnotation();
                        if ((psiElement == null || !psiElement.isPhysical()) && (psiElement = identifier) == null) continue;
                        AnnotateOverriddenMethodParameterFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)parameter3, (String)defaultNotNull) ? new AnnotateOverriddenMethodParameterFix(defaultNotNull, nullableManager.getDefaultNullable()) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)parameters2[i]);
                        holder.registerProblem((PsiElement)psiElement, JavaAnalysisBundle.message((String)"nullable.stuff.problems.overridden.method.parameters.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                        parameterQuickFixSuggested[i] = true;
                    }
                }
            }
        }
    }

    public static boolean shouldSkipOverriderAsGenerated(PsiMethod overriding) {
        if (Registry.is((String)"idea.report.nullity.missing.in.generated.overriders")) {
            return false;
        }
        PsiFile file = overriding.getContainingFile();
        VirtualFile virtualFile = file != null ? file.getVirtualFile() : null;
        return virtualFile != null && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile, (Project)overriding.getProject());
    }

    private static boolean isNotNullNotInferred(@NotNull PsiModifierListOwner owner2, boolean checkBases, boolean skipExternal) {
        Project project = owner2.getProject();
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
        if (!manager.isNotNull(owner2, checkBases)) {
            return false;
        }
        if (DfaPsiUtil.getTypeNullability(NullableStuffInspectionBase.getMemberType(owner2)) == Nullability.NOT_NULL) {
            return true;
        }
        PsiAnnotation anno = manager.getNotNullAnnotation(owner2, checkBases);
        if (anno == null || AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno)) {
            return false;
        }
        return !skipExternal || !AnnotationUtil.isExternalAnnotation((PsiAnnotation)anno);
    }

    public static boolean isNullableNotInferred(@NotNull PsiModifierListOwner owner2, boolean checkBases) {
        Project project = owner2.getProject();
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
        PsiAnnotation anno = manager.getNullableAnnotation(owner2, checkBases);
        if (anno == null) {
            return false;
        }
        return DfaPsiUtil.getTypeNullability(NullableStuffInspectionBase.getMemberType(owner2)) == Nullability.NULLABLE || !AnnotationUtil.isInferredAnnotation((PsiAnnotation)anno);
    }

    private static PsiType getMemberType(@NotNull PsiModifierListOwner owner2) {
        return owner2 instanceof PsiMethod ? ((PsiMethod)owner2).getReturnType() : (owner2 instanceof PsiVariable ? ((PsiVariable)owner2).getType() : null);
    }

    private static LocalQuickFix createChangeDefaultNotNullFix(NullableNotNullManager nullableManager, PsiModifierListOwner modifierListOwner) {
        JavaResolveResult resolveResult;
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierListOwner, (Collection)nullableManager.getNotNulls());
        if (annotation != null && (referenceElement = annotation.getNameReferenceElement()) != null && (resolveResult = referenceElement.advancedResolve(false)).getElement() != null && resolveResult.isValidResult() && !nullableManager.getDefaultNotNull().equals(annotation.getQualifiedName())) {
            return new ChangeNullableDefaultsFix(annotation.getQualifiedName(), null, nullableManager);
        }
        return null;
    }

    private static void reportNullableNotNullConflict(ProblemsHolder holder, PsiModifierListOwner listOwner, PsiAnnotation declaredNullable, PsiAnnotation declaredNotNull) {
        String bothNullableNotNullMessage = JavaAnalysisBundle.message((String)"inspection.nullable.problems.Nullable.NotNull.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName(declaredNullable), NullableStuffInspectionBase.getPresentableAnnoName(declaredNotNull)});
        holder.registerProblem((PsiElement)(declaredNotNull.isPhysical() ? declaredNotNull : listOwner.getNavigationElement()), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNotNull, listOwner)});
        holder.registerProblem((PsiElement)(declaredNullable.isPhysical() ? declaredNullable : listOwner.getNavigationElement()), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNullable, listOwner)});
    }

    public JComponent createOptionsPanel() {
        throw new RuntimeException("No UI in headless mode");
    }

    private static class MyAnnotateMethodFix
    extends AnnotateMethodFix {
        MyAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
            super(defaultNotNull, annotationsToRemove);
        }

        @Override
        @NotNull
        protected String getPreposition() {
            return "as";
        }

        @Override
        protected boolean annotateOverriddenMethods() {
            return true;
        }

        @Override
        protected boolean annotateSelf() {
            return false;
        }
    }

    private static class Annotated {
        private final boolean isDeclaredNotNull;
        private final boolean isDeclaredNullable;
        @Nullable
        private final PsiAnnotation notNull;
        @Nullable
        private final PsiAnnotation nullable;

        private Annotated(@Nullable PsiAnnotation notNull, @Nullable PsiAnnotation nullable) {
            this.isDeclaredNotNull = notNull != null;
            this.isDeclaredNullable = nullable != null;
            this.notNull = notNull;
            this.nullable = nullable;
        }

        @NotNull
        static Annotated from(@NotNull PsiModifierListOwner owner2) {
            NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner2.getProject());
            return new Annotated(manager.findExplicitNullabilityAnnotation(owner2, Nullability.NOT_NULL), manager.findExplicitNullabilityAnnotation(owner2, Nullability.NULLABLE));
        }
    }
}

