/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lambda;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RedundantLambdaParameterTypeInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(RedundantLambdaParameterTypeInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitParameterList(PsiParameterList parameterList) {
                super.visitParameterList(parameterList);
                if (RedundantLambdaParameterTypeInspection.isApplicable(parameterList)) {
                    holder.registerProblem((PsiElement)parameterList, JavaBundle.message((String)"inspection.message.lambda.parameter.type.is.redundant", (Object[])new Object[0]), new LocalQuickFix[]{new LambdaParametersFix()});
                }
            }
        };
    }

    private static boolean isApplicable(@NotNull PsiParameterList parameterList) {
        PsiParameter[] parameters2;
        PsiElement parent = parameterList.getParent();
        if (!(parent instanceof PsiLambdaExpression)) {
            return false;
        }
        PsiLambdaExpression expression2 = (PsiLambdaExpression)parent;
        for (PsiParameter parameter2 : parameters2 = parameterList.getParameters()) {
            PsiTypeElement typeElement = parameter2.getTypeElement();
            if (typeElement == null) {
                return false;
            }
            if (!(!PsiUtil.isLanguageLevel11OrHigher((PsiElement)parameterList) ? AnonymousCanBeLambdaInspection.hasRuntimeAnnotations((PsiModifierListOwner)parameter2, Collections.emptySet()) : typeElement.isInferredType() && RedundantLambdaParameterTypeInspection.keepVarType(parameter2))) continue;
            return false;
        }
        if (parameters2.length == 0) {
            return false;
        }
        PsiType functionalInterfaceType = expression2.getFunctionalInterfaceType();
        if (functionalInterfaceType != null) {
            PsiElement gParent;
            PsiElement lambdaParent = expression2.getParent();
            if (lambdaParent instanceof PsiExpressionList && (gParent = lambdaParent.getParent()) instanceof PsiCallExpression && ((PsiCallExpression)gParent).getTypeArguments().length == 0) {
                JavaResolveResult resolveResult = ((PsiCallExpression)gParent).resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method == null) {
                    return false;
                }
                int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)((PsiExpressionList)lambdaParent), (PsiElement)expression2);
                if (idx < 0) {
                    return false;
                }
                PsiCallExpression copy = (PsiCallExpression)gParent.copy();
                PsiLambdaExpression lambdaToStripTypeParameters = (PsiLambdaExpression)copy.getArgumentList().getExpressions()[idx];
                for (PsiParameter parameter3 : lambdaToStripTypeParameters.getParameterList().getParameters()) {
                    parameter3.getTypeElement().delete();
                }
                return functionalInterfaceType.equals(lambdaToStripTypeParameters.getFunctionalInterfaceType());
            }
            return true;
        }
        return false;
    }

    private static void removeTypes(PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression != null) {
            Object[] parameters2 = lambdaExpression.getParameterList().getParameters();
            if (PsiUtil.isLanguageLevel11OrHigher((PsiElement)lambdaExpression) && Arrays.stream(parameters2).anyMatch(parameter2 -> RedundantLambdaParameterTypeInspection.keepVarType(parameter2))) {
                for (Object parameter3 : parameters2) {
                    PsiTypeElement element = parameter3.getTypeElement();
                    if (element == null) continue;
                    new CommentTracker().replaceAndRestoreComments((PsiElement)element, "var");
                }
                return;
            }
            String text2 = parameters2.length == 1 ? parameters2[0].getName() : "(" + StringUtil.join((Object[])parameters2, PsiParameter::getName, (String)", ") + ")";
            PsiLambdaExpression expression2 = (PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)lambdaExpression.getProject()).createExpressionFromText(text2 + "->{}", (PsiElement)lambdaExpression);
            CommentTracker tracker = new CommentTracker();
            tracker.replaceAndRestoreComments((PsiElement)lambdaExpression.getParameterList(), (PsiElement)expression2.getParameterList());
        }
    }

    private static boolean keepVarType(PsiParameter parameter2) {
        return parameter2.hasModifierProperty("final") || parameter2.getAnnotations().length > 0;
    }

    private static class LambdaParametersFix
    implements LocalQuickFix {
        private LambdaParametersFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"quickfix.family.remove.redundant.parameter.types", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent instanceof PsiLambdaExpression) {
                RedundantLambdaParameterTypeInspection.removeTypes((PsiLambdaExpression)parent);
            }
        }
    }
}

