/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.util.PsiUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRequiresAutoModuleInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean TRANSITIVE_ONLY = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaAnalysisBundle.message((String)"inspection.requires.auto.module.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "TRANSITIVE_ONLY");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return !PsiUtil.isModuleFile((PsiFile)holder.getFile()) ? PsiElementVisitor.EMPTY_VISITOR : new JavaElementVisitor(){

            public void visitRequiresStatement(PsiRequiresStatement statement) {
                PsiJavaModule target;
                super.visitRequiresStatement(statement);
                PsiJavaModuleReferenceElement refElement = statement.getReferenceElement();
                if (refElement != null && (target = statement.resolve()) instanceof LightJavaModule) {
                    if (!JavaRequiresAutoModuleInspection.this.TRANSITIVE_ONLY) {
                        holder.registerProblem((PsiElement)refElement, JavaAnalysisBundle.message((String)"inspection.requires.auto.module.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                    } else if (statement.hasModifierProperty("transitive")) {
                        holder.registerProblem((PsiElement)refElement, JavaAnalysisBundle.message((String)"inspection.requires.auto.module.transitive", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }
}

