/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OptionalGetWithoutIsPresentInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (nameElement == null) {
                    return;
                }
                if (!OptionalUtil.OPTIONAL_GET.test(call)) {
                    return;
                }
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
                if (qualifier == null) {
                    return;
                }
                PsiClass optionalClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
                if (optionalClass == null) {
                    return;
                }
                CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(qualifier);
                if (result == null || !result.expressionWasAnalyzed(qualifier)) {
                    return;
                }
                DfType dfType = SpecialField.OPTIONAL_VALUE.getFromQualifier(result.getDfType(qualifier));
                if (dfType != DfTypes.TOP && !(dfType instanceof DfReferenceType)) {
                    return;
                }
                DfaNullability nullability = DfaNullability.fromDfType(dfType);
                if (!(nullability != DfaNullability.UNKNOWN && nullability != DfaNullability.NULLABLE || this.isPresentCallWithSameQualifierExists(qualifier))) {
                    holder.registerProblem(nameElement, JavaBundle.message((String)"inspection.optional.get.without.is.present.message", (Object[])new Object[]{optionalClass.getName()}), new LocalQuickFix[]{OptionalGetWithoutIsPresentInspection.tryCreateFix(call)});
                }
            }

            public boolean isPresentCallWithSameQualifierExists(PsiExpression qualifier) {
                PsiElement context;
                if (qualifier instanceof PsiMethodCallExpression && (context = PsiTreeUtil.getParentOfType((PsiElement)qualifier, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class})) != null) {
                    return !PsiTreeUtil.processElements((PsiElement)context, e -> {
                        if (e == qualifier || !(e instanceof PsiMethodCallExpression)) {
                            return true;
                        }
                        PsiMethodCallExpression call = (PsiMethodCallExpression)e;
                        String name2 = call.getMethodExpression().getReferenceName();
                        if (!"isPresent".equals(name2) && !"isEmpty".equals(name2) || !call.getArgumentList().isEmpty()) {
                            return true;
                        }
                        PsiExpression isPresentQualifier = call.getMethodExpression().getQualifierExpression();
                        return isPresentQualifier == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)isPresentQualifier);
                    });
                }
                return false;
            }
        };
    }

    private static LocalQuickFix tryCreateFix(PsiMethodCallExpression call) {
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiClass optionalClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
        if (optionalClass == null || !"java.util.Optional".equals(optionalClass.getQualifiedName())) {
            return null;
        }
        PsiType optionalElementType = OptionalUtil.getOptionalElementType(qualifier.getType());
        if (optionalElementType == null) {
            return null;
        }
        PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
        if (nextCall != null && optionalClass.equals(PsiUtil.resolveClassInClassTypeOnly((PsiType)nextCall.getType()))) {
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)nextCall)) {
                PsiMethodCallExpression copy = (PsiMethodCallExpression)nextCall.copy();
                PsiExpression copyQualifier = Objects.requireNonNull(copy.getMethodExpression().getQualifierExpression());
                try {
                    copyQualifier.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)call.getProject()).createExpressionFromText("((" + optionalElementType.getCanonicalText() + ")null)", (PsiElement)copyQualifier));
                }
                catch (IncorrectOperationException e) {
                    return null;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)copy)) {
                    return null;
                }
            }
            return new UseFlatMapFix();
        }
        return null;
    }

    private static class UseFlatMapFix
    implements LocalQuickFix {
        private UseFlatMapFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"quickfix.family.use.flatmap", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType elementType = OptionalUtil.getOptionalElementType(qualifier.getType());
            PsiMethodCallExpression nextCall = ExpressionUtils.getCallForQualifier((PsiExpression)call);
            if (nextCall == null) {
                return;
            }
            String name2 = new VariableNameGenerator((PsiElement)qualifier, VariableKind.PARAMETER).byExpression(qualifier).byType(elementType).byName("value").generate(true);
            CommentTracker ct = new CommentTracker();
            PsiReferenceExpression methodExpression = nextCall.getMethodExpression();
            ct.markRangeUnchanged(Objects.requireNonNull(methodExpression.getQualifierExpression()).getNextSibling(), methodExpression.getLastChild());
            ct.markRangeUnchanged(methodExpression.getNextSibling(), nextCall.getLastChild());
            PsiMethodCallExpression newNextCall = (PsiMethodCallExpression)nextCall.copy();
            PsiExpression newQualifier = Objects.requireNonNull(newNextCall.getMethodExpression().getQualifierExpression());
            newQualifier.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(name2, (PsiElement)newNextCall));
            String lambda2 = name2 + "->" + newNextCall.getText();
            String replacement = ct.text((PsiElement)qualifier) + ".flatMap(" + lambda2 + ")";
            PsiMethodCallExpression result = (PsiMethodCallExpression)ct.replaceAndRestoreComments((PsiElement)nextCall, replacement);
            LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference((PsiLambdaExpression)result.getArgumentList().getExpressions()[0]);
        }
    }
}

