/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8MapForEachInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String JAVA_UTIL_MAP_ENTRY = "java.util.Map.Entry";
    private static final CallMatcher ITERABLE_FOREACH = CallMatcher.instanceCall("java.lang.Iterable", "forEach").parameterTypes("java.util.function.Consumer");
    private static final CallMatcher MAP_ENTRY_SET = CallMatcher.instanceCall("java.util.Map", "entrySet").parameterCount(0);
    private static final CallMatcher ENTRY_GETTER = CallMatcher.instanceCall("java.util.Map.Entry", "getValue", "getKey").parameterCount(0);
    public boolean DO_NOT_HIGHLIGHT_LOOP = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaBundle.message((String)"inspection.map.foreach.option.no.loops", (Object[])new Object[0]), (InspectionProfileEntry)this, "DO_NOT_HIGHLIGHT_LOOP");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!JavaFeature.ADVANCED_COLLECTIONS_API.isFeatureSupported(holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (!ITERABLE_FOREACH.test(call)) {
                    return;
                }
                PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
                if (!MAP_ENTRY_SET.test(qualifierCall)) {
                    return;
                }
                PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)call.getArgumentList().getExpressions()[0], PsiLambdaExpression.class);
                if (lambda2 == null) {
                    return;
                }
                PsiParameter[] lambdaParameters = lambda2.getParameterList().getParameters();
                if (lambdaParameters.length != 1) {
                    return;
                }
                PsiParameter entry = lambdaParameters[0];
                if (!this.allUsagesAllowed(entry)) {
                    return;
                }
                PsiElement nameElement = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                holder.registerProblem(nameElement, JavaAnalysisBundle.message((String)"inspection.can.be.replaced.with.message", (Object[])new Object[]{"Map.forEach()"}), new LocalQuickFix[]{new ReplaceWithMapForEachFix()});
            }

            private boolean allUsagesAllowed(@NotNull PsiParameter entry) {
                return ReferencesSearch.search((PsiElement)entry).allMatch(entryRef -> {
                    PsiMethodCallExpression entryCall = ExpressionUtils.getCallForQualifier((PsiExpression)ObjectUtils.tryCast((Object)entryRef.getElement(), PsiExpression.class));
                    return ENTRY_GETTER.test(entryCall);
                });
            }

            public void visitForeachStatement(PsiForeachStatement loop) {
                if (Java8MapForEachInspection.this.DO_NOT_HIGHLIGHT_LOOP && !isOnTheFly) {
                    return;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)loop.getIteratedValue()), PsiMethodCallExpression.class);
                if (MAP_ENTRY_SET.test(call) && LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)loop.getBody()) && this.allUsagesAllowed(loop.getIterationParameter())) {
                    TextRange range;
                    PsiElement toHighlight;
                    ProblemHighlightType type2 = Java8MapForEachInspection.this.DO_NOT_HIGHLIGHT_LOOP ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    boolean wholeStatement = isOnTheFly && (Java8MapForEachInspection.this.DO_NOT_HIGHLIGHT_LOOP || InspectionProjectProfileManager.isInformationLevel((String)Java8MapForEachInspection.this.getShortName(), (PsiElement)loop));
                    PsiJavaToken rParenth = loop.getRParenth();
                    PsiElement firstChild = loop.getFirstChild();
                    if (wholeStatement && rParenth != null) {
                        toHighlight = loop;
                        range = new TextRange(firstChild.getStartOffsetInParent(), rParenth.getStartOffsetInParent() + 1);
                    } else {
                        toHighlight = firstChild;
                        range = new TextRange(0, firstChild.getTextLength());
                    }
                    holder.registerProblem(toHighlight, JavaAnalysisBundle.message((String)"inspection.can.be.replaced.with.message", (Object[])new Object[]{"Map.forEach()"}), type2, range, new LocalQuickFix[]{new ReplaceWithMapForEachFix()});
                }
            }
        };
    }

    private static class ReplaceWithMapForEachFix
    implements LocalQuickFix {
        private ReplaceWithMapForEachFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Map.forEach()"});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement foreach;
            PsiElement element = descriptor.getStartElement();
            PsiElement psiElement = foreach = element instanceof PsiForeachStatement ? element : element.getParent();
            if (foreach instanceof PsiForeachStatement) {
                ReplaceWithMapForEachFix.fixInForeach((PsiForeachStatement)foreach);
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiMethodCallExpression entrySetCall = MethodCallUtils.getQualifierMethodCall(call);
            if (entrySetCall == null) {
                return;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)ObjectUtils.tryCast((Object)args[0], PsiLambdaExpression.class);
            if (lambda2 == null) {
                return;
            }
            PsiElement body2 = lambda2.getBody();
            if (body2 == null) {
                return;
            }
            PsiParameterList parameterList = lambda2.getParameterList();
            PsiParameter[] lambdaParameters = parameterList.getParameters();
            if (lambdaParameters.length != 1) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiParameter entryParameter = lambdaParameters[0];
            String replacement = ReplaceWithMapForEachFix.createReplacementExpression(entrySetCall, entryParameter, body2, ct);
            ct.replaceAndRestoreComments((PsiElement)call, replacement);
        }

        /*
         * WARNING - void declaration
         */
        private static String createReplacementExpression(PsiMethodCallExpression entrySetCall, PsiParameter entryParameter, PsiElement body2, CommentTracker ct) {
            void var9_13;
            PsiType entryType = entryParameter.getType();
            ParameterCandidate key2 = new ParameterCandidate(entryType, true);
            ParameterCandidate value2 = new ParameterCandidate(entryType, false);
            List<PsiReferenceExpression> references = VariableAccessUtils.getVariableReferences((PsiVariable)entryParameter, body2);
            for (PsiReferenceExpression psiReferenceExpression : references) {
                PsiMethodCallExpression psiMethodCallExpression = ExpressionUtils.getCallForQualifier((PsiExpression)psiReferenceExpression);
                if (!ENTRY_GETTER.test(psiMethodCallExpression)) continue;
                ParameterCandidate.select(psiMethodCallExpression, key2, value2).accept(psiMethodCallExpression);
            }
            key2.createName(body2, ct);
            value2.createName(body2, ct);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)entrySetCall.getProject());
            for (PsiExpression psiExpression : references) {
                if (!psiExpression.isValid()) continue;
                PsiMethodCallExpression entryCall = ExpressionUtils.getCallForQualifier(psiExpression);
                if (!ENTRY_GETTER.test(entryCall)) continue;
                ct.replace((PsiElement)entryCall, (PsiElement)factory.createIdentifier(ParameterCandidate.select((PsiMethodCallExpression)entryCall, (ParameterCandidate)key2, (ParameterCandidate)value2).myName));
            }
            if (body2 instanceof PsiExpression || body2 instanceof PsiCodeBlock || body2 instanceof PsiBlockStatement) {
                String string = ct.text(body2);
            } else {
                String string = "{" + ct.text(body2) + "}";
            }
            PsiLambdaExpression psiLambdaExpression = (PsiLambdaExpression)factory.createExpressionFromText("(" + key2.myName + "," + value2.myName + ")->" + (String)var9_13, body2);
            LambdaRefactoringUtil.simplifyToExpressionLambda(psiLambdaExpression);
            entrySetCall.getArgumentList().add((PsiElement)psiLambdaExpression);
            ExpressionUtils.bindCallTo(entrySetCall, "forEach");
            return ct.text((PsiElement)entrySetCall);
        }

        private static void fixInForeach(PsiForeachStatement loop) {
            PsiMethodCallExpression entrySetCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)loop.getIteratedValue()), PsiMethodCallExpression.class);
            if (entrySetCall == null) {
                return;
            }
            PsiStatement body2 = loop.getBody();
            if (body2 == null) {
                return;
            }
            PsiParameter entryParameter = loop.getIterationParameter();
            CommentTracker ct = new CommentTracker();
            String replacementExpression = ReplaceWithMapForEachFix.createReplacementExpression(entrySetCall, entryParameter, (PsiElement)body2, ct);
            ct.replaceAndRestoreComments((PsiElement)loop, replacementExpression + ";");
        }

        private static class ParameterCandidate {
            PsiVariable myOriginalVar;
            final PsiType myType;
            String myName;

            ParameterCandidate(PsiType entryType, boolean isKey) {
                this.myName = isKey ? "key" : "value";
                this.myType = GenericsUtil.getVariableTypeByExpressionType((PsiType)PsiUtil.substituteTypeParameter((PsiType)entryType, (String)Java8MapForEachInspection.JAVA_UTIL_MAP_ENTRY, (int)(isKey ? 0 : 1), (boolean)true));
            }

            private void createName(PsiElement context, CommentTracker ct) {
                if (this.myOriginalVar != null) {
                    this.myName = this.myOriginalVar.getName();
                    ct.delete((PsiElement)this.myOriginalVar);
                } else {
                    this.myName = JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestUniqueVariableName(this.myName, context, true);
                }
            }

            public void accept(PsiMethodCallExpression call) {
                if (this.myOriginalVar != null) {
                    return;
                }
                PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiLocalVariable.class);
                if (variable != null && EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(variable.getType(), this.myType)) {
                    this.myOriginalVar = variable;
                }
            }

            static ParameterCandidate select(PsiMethodCallExpression entryCall, ParameterCandidate key2, ParameterCandidate value2) {
                String methodName = entryCall.getMethodExpression().getReferenceName();
                return "getKey".equals(methodName) ? key2 : value2;
            }
        }
    }
}

