/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.java18StreamApi.PseudoLambdaReplaceTemplate;
import com.intellij.codeInspection.java18StreamApi.StaticPseudoFunctionalStyleMethodOptions;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import java.util.Collection;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticPseudoFunctionalStyleMethodInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(StaticPseudoFunctionalStyleMethodInspection.class);
    private final StaticPseudoFunctionalStyleMethodOptions myOptions = new StaticPseudoFunctionalStyleMethodOptions();

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        this.myOptions.readExternal(node);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.myOptions.writeExternal(node);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.myOptions.createPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!JavaFeature.STREAMS.isFeatureSupported(holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
                String qName = methodCallExpression.getMethodExpression().getQualifiedName();
                if (qName == null) {
                    return;
                }
                qName = StringUtil.getShortName((String)qName);
                Collection<StaticPseudoFunctionalStyleMethodOptions.PipelineElement> handlerInfos = StaticPseudoFunctionalStyleMethodInspection.this.myOptions.findElementsByMethodName(qName);
                if (handlerInfos.isEmpty()) {
                    return;
                }
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return;
                }
                String classQualifiedName = aClass.getQualifiedName();
                if (classQualifiedName == null) {
                    return;
                }
                StaticPseudoFunctionalStyleMethodOptions.PipelineElement suitableHandler = null;
                for (StaticPseudoFunctionalStyleMethodOptions.PipelineElement h : handlerInfos) {
                    if (!h.getHandlerClass().equals(classQualifiedName)) continue;
                    suitableHandler = h;
                    break;
                }
                if (suitableHandler == null) {
                    return;
                }
                PseudoLambdaReplaceTemplate.ValidationInfo validationInfo = suitableHandler.getTemplate().validate(methodCallExpression);
                if (validationInfo != null) {
                    holder.registerProblem((PsiElement)methodCallExpression.getMethodExpression(), JavaBundle.message((String)"inspection.message.pseudo.functional.style.code", (Object[])new Object[0]), new LocalQuickFix[]{new ReplacePseudoLambdaWithLambda(suitableHandler)});
                }
            }
        };
    }

    public static class ReplacePseudoLambdaWithLambda
    implements LocalQuickFix {
        private final StaticPseudoFunctionalStyleMethodOptions.PipelineElement myHandler;

        private ReplacePseudoLambdaWithLambda(StaticPseudoFunctionalStyleMethodOptions.PipelineElement handler) {
            this.myHandler = handler;
        }

        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"quickfix.family.replace.with.java.stream.api.pipeline", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement parent;
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof PsiReferenceExpression && (parent = psiElement.getParent()) instanceof PsiMethodCallExpression) {
                this.myHandler.getTemplate().convertToStream((PsiMethodCallExpression)parent, null, false);
            }
        }
    }
}

