/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.codeInspection.deprecation.DeprecatedApiUsageProcessor;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MarkedForRemovalInspection
extends DeprecationInspectionBase {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file = holder.getFile();
        if (file instanceof PsiJavaFile && ((PsiJavaFile)file).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9)) {
            HighlightSeverity severity = MarkedForRemovalInspection.getCurrentSeverity(file);
            return ApiUsageUastVisitor.createPsiElementVisitor(new DeprecatedApiUsageProcessor(holder, false, false, false, false, this.IGNORE_IN_SAME_OUTERMOST_CLASS, true, severity));
        }
        return PsiElementVisitor.EMPTY_VISITOR;
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public String getShortName() {
        return "MarkedForRemoval";
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    @NonNls
    public String getID() {
        return "removal";
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        MarkedForRemovalInspection.addSameOutermostClassCheckBox(panel2);
        return panel2;
    }

    private static HighlightSeverity getCurrentSeverity(@NotNull PsiFile file) {
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.find((String)"MarkedForRemoval");
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)file.getProject()).getCurrentProfile();
        HighlightDisplayLevel displayLevel = profile.getErrorLevel(highlightDisplayKey, (PsiElement)file);
        return displayLevel.getSeverity();
    }
}

