/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.deprecation.DeprecationInspectionBase;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;

public final class DeprecatedApiUsageProcessor
implements ApiUsageProcessor {
    private final ProblemsHolder myHolder;
    private final boolean myIgnoreInsideDeprecated;
    private final boolean myIgnoreAbstractDeprecatedOverrides;
    private final boolean myIgnoreImportStatements;
    private final boolean myIgnoreMethodsOfDeprecated;
    private final boolean myIgnoreInSameOutermostClass;
    private final boolean myForRemoval;
    private final ProblemHighlightType myHighlightType;

    public DeprecatedApiUsageProcessor(@NotNull ProblemsHolder holder, boolean ignoreInsideDeprecated, boolean ignoreAbstractDeprecatedOverrides, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, boolean ignoreInSameOutermostClass, boolean forRemoval, @Nullable HighlightSeverity severity) {
        this.myHolder = holder;
        this.myIgnoreInsideDeprecated = ignoreInsideDeprecated;
        this.myIgnoreAbstractDeprecatedOverrides = ignoreAbstractDeprecatedOverrides;
        this.myIgnoreImportStatements = ignoreImportStatements;
        this.myIgnoreMethodsOfDeprecated = ignoreMethodsOfDeprecated;
        this.myIgnoreInSameOutermostClass = ignoreInSameOutermostClass;
        this.myForRemoval = forRemoval;
        this.myHighlightType = forRemoval && severity == HighlightSeverity.ERROR ? ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL : ProblemHighlightType.LIKE_DEPRECATED;
    }

    @Override
    public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
        this.checkTargetDeprecated(sourceNode, target);
    }

    @Override
    public void processImportReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target) {
        this.checkTargetDeprecated(sourceNode, target);
    }

    private void checkTargetDeprecated(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target) {
        PsiElement elementToHighlight = sourceNode.getSourcePsi();
        if (elementToHighlight != null) {
            this.checkTargetDeprecated(elementToHighlight, target);
        }
    }

    private void checkTargetDeprecated(@NotNull PsiElement elementToHighlight, @NotNull PsiModifierListOwner target) {
        DeprecationInspectionBase.checkDeprecated(target, elementToHighlight, null, this.myIgnoreInsideDeprecated, this.myIgnoreImportStatements, this.myIgnoreMethodsOfDeprecated, this.myIgnoreInSameOutermostClass, this.myHolder, this.myForRemoval, this.myHighlightType);
    }

    @Override
    public void processConstructorInvocation(@NotNull UElement sourceNode, @NotNull PsiClass instantiatedClass, @Nullable PsiMethod constructor, @Nullable UClass subclassDeclaration) {
        if (constructor != null && PsiImplUtil.isDeprecated((PsiElement)constructor) && this.myForRemoval == DeprecationInspectionBase.isForRemovalAttributeSet((PsiModifierListOwner)constructor)) {
            this.checkTargetDeprecated(sourceNode, (PsiModifierListOwner)constructor);
            return;
        }
        if (this.isDefaultConstructorDeprecated(instantiatedClass)) {
            PsiElement elementToHighlight = sourceNode.getSourcePsi();
            if (elementToHighlight == null) {
                return;
            }
            String description = JavaErrorBundle.message(this.myForRemoval ? "marked.for.removal.default.constructor" : "deprecated.default.constructor", instantiatedClass.getQualifiedName());
            this.myHolder.registerProblem(elementToHighlight, DeprecationInspectionBase.getDescription(description, this.myForRemoval, this.myHighlightType), this.myHighlightType, new LocalQuickFix[0]);
        }
    }

    @Override
    public void processMethodOverriding(@NotNull UMethod method, @NotNull PsiMethod overriddenMethod) {
        PsiClass aClass = overriddenMethod.getContainingClass();
        if (aClass == null) {
            return;
        }
        PsiElement methodNameElement = UElementKt.getSourcePsiElement((UElement)method.getUastAnchor());
        if (methodNameElement == null) {
            return;
        }
        if (this.myIgnoreAbstractDeprecatedOverrides && !aClass.isDeprecated() && overriddenMethod.hasModifierProperty("abstract")) {
            return;
        }
        if (overriddenMethod.isDeprecated() && this.myForRemoval == DeprecationInspectionBase.isForRemovalAttributeSet((PsiModifierListOwner)overriddenMethod)) {
            String description = JavaErrorBundle.message(this.myForRemoval ? "overrides.marked.for.removal.method" : "overrides.deprecated.method", DeprecationInspectionBase.getPresentableName((PsiElement)aClass));
            this.myHolder.registerProblem(methodNameElement, DeprecationInspectionBase.getDescription(description, this.myForRemoval, this.myHighlightType), this.myHighlightType, new LocalQuickFix[0]);
        }
    }

    @Override
    public void processJavaModuleReference(@NotNull PsiJavaModuleReference javaModuleReference, @NotNull PsiJavaModule target) {
        this.checkTargetDeprecated(javaModuleReference.getElement(), (PsiModifierListOwner)target);
    }

    private boolean isDefaultConstructorDeprecated(@NotNull PsiClass aClass) {
        List externalDeprecated = ExternalAnnotationsManager.getInstance((Project)aClass.getProject()).findDefaultConstructorExternalAnnotations(aClass, "java.lang.Deprecated");
        return externalDeprecated != null && ContainerUtil.exists((Iterable)externalDeprecated, annotation -> DeprecationInspectionBase.isForRemovalAttributeSet(annotation) == this.myForRemoval);
    }
}

