/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.deadCode.DeadHTMLComposer;
import com.intellij.codeInspection.deadCode.DummyEntryPointsEP;
import com.intellij.codeInspection.deadCode.UnreferencedFilter;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionRVContentProvider;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.codeInspection.ui.EntryPointsNode;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeModel;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.codeInspection.util.RefFilter;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ArrayUtil;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedDeclarationPresentation
extends DefaultInspectionToolPresentation {
    private final Map<RefEntity, UnusedDeclarationHint> myFixedElements = ConcurrentCollectionFactory.createMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    private final Set<RefEntity> myExcludedElements = ConcurrentCollectionFactory.createConcurrentSet((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    private final WeakUnreferencedFilter myFilter;
    private DeadHTMLComposer myComposer;
    private final AtomicNotNullLazyValue<InspectionToolWrapper> myDummyWrapper = new AtomicNotNullLazyValue<InspectionToolWrapper>(){

        @NotNull
        protected InspectionToolWrapper compute() {
            GlobalInspectionToolWrapper toolWrapper = new GlobalInspectionToolWrapper((InspectionEP)new DummyEntryPointsEP());
            toolWrapper.initialize((GlobalInspectionContext)UnusedDeclarationPresentation.this.myContext);
            return toolWrapper;
        }
    };
    @NonNls
    private static final String DELETE = "delete";
    @NonNls
    private static final String COMMENT = "comment";
    private final QuickFixAction[] myQuickFixActions;

    public UnusedDeclarationPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        super(toolWrapper, context);
        this.myQuickFixActions = this.createQuickFixes(toolWrapper);
        this.myFilter = new WeakUnreferencedFilter(this.getTool(), this.getContext());
        ((EntryPointsManagerBase)this.getEntryPointsManager()).setAddNonJavaEntries(this.getTool().ADD_NONJAVA_TO_ENTRIES);
    }

    @NotNull
    public RefFilter getFilter() {
        return this.myFilter;
    }

    @NotNull
    private UnusedDeclarationInspectionBase getTool() {
        return (UnusedDeclarationInspectionBase)this.getToolWrapper().getTool();
    }

    @NotNull
    public DeadHTMLComposer getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DeadHTMLComposer((InspectionToolPresentation)this);
        }
        return this.myComposer;
    }

    public boolean isExcluded(@NotNull RefEntity entity) {
        return this.myExcludedElements.contains(entity);
    }

    public void amnesty(@NotNull RefEntity element) {
        this.myExcludedElements.remove(element);
    }

    public void exclude(@NotNull RefEntity element) {
        this.myExcludedElements.add(element);
    }

    public void exportResults(@NotNull Consumer<? super org.jdom.Element> resultConsumer, @NotNull RefEntity refEntity, @NotNull Predicate<? super CommonProblemDescriptor> excludedDescriptions) {
        if (!(refEntity instanceof RefJavaElement)) {
            return;
        }
        RefFilter filter = this.getFilter();
        if (!this.myFixedElements.containsKey(refEntity) && filter.accepts((RefJavaElement)refEntity)) {
            refEntity = this.getRefManager().getRefinedElement(refEntity);
            if (!refEntity.isValid()) {
                return;
            }
            RefJavaElement refElement = (RefJavaElement)refEntity;
            if (!UnusedDeclarationPresentation.compareVisibilities(refElement, this.getTool().getSharedLocalInspectionTool())) {
                return;
            }
            if (this.skipEntryPoints(refElement)) {
                return;
            }
            org.jdom.Element element = refEntity.getRefManager().export(refEntity, -1);
            if (element == null) {
                return;
            }
            org.jdom.Element problemClassElement = new org.jdom.Element("problem_class");
            HighlightSeverity severity = this.getSeverity((RefElement)refElement);
            String attributeKey = HighlightInfoType.UNUSED_SYMBOL.getAttributesKey().getExternalName();
            problemClassElement.setAttribute("severity", severity.myName);
            problemClassElement.setAttribute("attribute_key", attributeKey);
            problemClassElement.addContent(AnalysisBundle.message((String)"inspection.export.results.dead.code", (Object[])new Object[0]));
            element.addContent(problemClassElement);
            org.jdom.Element hintsElement = new org.jdom.Element("hints");
            for (UnusedDeclarationHint hint : UnusedDeclarationHint.values()) {
                org.jdom.Element hintElement = new org.jdom.Element("hint");
                hintElement.setAttribute("value", StringUtil.toLowerCase((String)hint.toString()));
                hintsElement.addContent(hintElement);
            }
            element.addContent(hintsElement);
            org.jdom.Element descriptionElement = new org.jdom.Element("description");
            StringBuilder buf = new StringBuilder();
            DeadHTMLComposer.appendProblemSynopsis((RefElement)refEntity, buf);
            descriptionElement.addContent(buf.toString());
            element.addContent(descriptionElement);
            resultConsumer.accept((org.jdom.Element)element);
        }
        super.exportResults(resultConsumer, refEntity, excludedDescriptions);
    }

    public QuickFixAction @NotNull [] getQuickFixes(RefEntity ... refElements) {
        return Arrays.stream(refElements).anyMatch(element -> element instanceof RefJavaElement && this.getFilter().accepts((RefJavaElement)element) && !this.myFixedElements.containsKey(element) && element.isValid()) ? this.myQuickFixActions : QuickFixAction.EMPTY;
    }

    private QuickFixAction @NotNull [] createQuickFixes(@NotNull InspectionToolWrapper toolWrapper) {
        return new QuickFixAction[]{new PermanentDeleteAction(toolWrapper), new CommentOutBin(toolWrapper), new MoveToEntries(toolWrapper)};
    }

    private EntryPointsManager getEntryPointsManager() {
        return ((GlobalJavaInspectionContext)this.getContext().getExtension(GlobalJavaInspectionContext.CONTEXT)).getEntryPointsManager(this.getContext().getRefManager());
    }

    private static void commentOutDead(PsiElement psiElement) {
        Document doc;
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile != null && (doc = PsiDocumentManager.getInstance((Project)psiElement.getProject()).getDocument(psiFile)) != null) {
            int line2;
            TextRange textRange = psiElement.getTextRange();
            String date = DateFormatUtil.formatDateTime((Date)new Date());
            int startOffset = textRange.getStartOffset();
            CharSequence chars = doc.getCharsSequence();
            while (CharArrayUtil.regionMatches((CharSequence)chars, (int)startOffset, (CharSequence)AnalysisBundle.message((String)"inspection.dead.code.comment", (Object[])new Object[0]))) {
                int line = doc.getLineNumber(startOffset) + 1;
                if (line >= doc.getLineCount()) continue;
                startOffset = doc.getLineStartOffset(line);
                startOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
            }
            int endOffset = textRange.getEndOffset();
            int line1 = doc.getLineNumber(startOffset);
            if (line1 == (line2 = doc.getLineNumber(endOffset - 1))) {
                doc.insertString(startOffset, (CharSequence)AnalysisBundle.message((String)"inspection.dead.code.date.comment", (Object[])new Object[]{date}));
            } else {
                for (int i = line1; i <= line2; ++i) {
                    doc.insertString(doc.getLineStartOffset(i), (CharSequence)"//");
                }
                doc.insertString(doc.getLineStartOffset(Math.min(line2 + 1, doc.getLineCount() - 1)), (CharSequence)AnalysisBundle.message((String)"inspection.dead.code.stop.comment", (Object[])new Object[]{date}));
                doc.insertString(doc.getLineStartOffset(line1), (CharSequence)AnalysisBundle.message((String)"inspection.dead.code.start.comment", (Object[])new Object[]{date}));
            }
        }
    }

    public void patchToolNode(@NotNull InspectionTreeNode node, @NotNull InspectionRVContentProvider provider, boolean showStructure, boolean groupByStructure) {
        InspectionTreeModel model = this.myContext.getView().getTree().getInspectionTreeModel();
        EntryPointsNode epNode = (EntryPointsNode)model.createCustomNode(this.myDummyWrapper.getValue(), () -> new EntryPointsNode((InspectionToolWrapper)this.myDummyWrapper.getValue(), this.myContext, node), node);
        InspectionToolPresentation presentation = this.myContext.getPresentation((InspectionToolWrapper)this.myDummyWrapper.getValue());
        presentation.updateContent();
        provider.appendToolNodeContent(this.myContext, (InspectionToolWrapper)this.myDummyWrapper.getValue(), (InspectionTreeNode)epNode, showStructure, groupByStructure);
    }

    @NotNull
    public RefElementNode createRefNode(@Nullable RefEntity entity, @NotNull InspectionTreeModel model, @NotNull InspectionTreeNode parent) {
        return new UnusedDeclarationRefElementNode(entity, this, parent);
    }

    public boolean isProblemResolved(@Nullable RefEntity entity) {
        return this.myFixedElements.containsKey(entity);
    }

    public synchronized void updateContent() {
        this.getTool().checkForReachableRefs((GlobalInspectionContext)this.getContext());
        this.myContents.clear();
        final UnusedSymbolLocalInspectionBase localInspectionTool = this.getTool().getSharedLocalInspectionTool();
        this.getContext().getRefManager().iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (!(refEntity instanceof RefJavaElement)) {
                    return;
                }
                RefJavaElement refElement = (RefJavaElement)refEntity;
                if (!UnusedDeclarationPresentation.compareVisibilities(refElement, localInspectionTool)) {
                    return;
                }
                if ((!UnusedDeclarationPresentation.this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS || !UnusedDeclarationPresentation.this.myFixedElements.containsKey(refElement) && !UnusedDeclarationPresentation.this.isExcluded(refEntity) && !UnusedDeclarationPresentation.this.isSuppressed((RefEntity)refElement)) && refElement.isValid() && UnusedDeclarationPresentation.this.getFilter().accepts(refElement)) {
                    if (UnusedDeclarationPresentation.this.skipEntryPoints(refElement)) {
                        return;
                    }
                    UnusedDeclarationPresentation.this.registerContentEntry(refEntity, RefJavaUtil.getInstance().getPackageName(refEntity));
                }
            }
        });
        this.updateProblemElements();
    }

    protected boolean skipEntryPoints(RefJavaElement refElement) {
        return this.getTool().isEntryPoint((RefElement)refElement);
    }

    @PsiModifier.ModifierConstant
    private static String getAcceptedVisibility(UnusedSymbolLocalInspectionBase tool, RefJavaElement element) {
        if (element instanceof RefImplicitConstructor) {
            element = ((RefImplicitConstructor)element).getOwnerClass();
        }
        if (element instanceof RefClass) {
            return element.getOwner() instanceof RefClass ? tool.getInnerClassVisibility() : tool.getClassVisibility();
        }
        if (element instanceof RefField) {
            return tool.getFieldVisibility();
        }
        if (element instanceof RefMethod) {
            PsiElement psi;
            String methodVisibility = tool.getMethodVisibility();
            if (methodVisibility != null && tool.isIgnoreAccessors() && (psi = element.getPsiElement()) instanceof PsiMethod && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)psi))) {
                return null;
            }
            return methodVisibility;
        }
        if (element instanceof RefParameter) {
            return tool.getParameterVisibility();
        }
        return "public";
    }

    private static boolean compareVisibilities(RefJavaElement listOwner, UnusedSymbolLocalInspectionBase localInspectionTool) {
        return UnusedDeclarationPresentation.compareVisibilities(listOwner, UnusedDeclarationPresentation.getAcceptedVisibility(localInspectionTool, listOwner));
    }

    static boolean compareVisibilities(RefJavaElement listOwner, String acceptedVisibility) {
        if (acceptedVisibility != null) {
            while (listOwner != null) {
                if (VisibilityUtil.compare((String)listOwner.getAccessModifier(), (String)acceptedVisibility) >= 0) {
                    return true;
                }
                RefEntity parent = listOwner.getOwner();
                if (!(parent instanceof RefJavaElement)) break;
                listOwner = (RefJavaElement)parent;
            }
        }
        return false;
    }

    public void ignoreElement(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] descriptors;
        RefEntity owner2 = refEntity;
        if (refEntity instanceof RefParameter) {
            owner2 = refEntity.getOwner();
        }
        if ((descriptors = (CommonProblemDescriptor[])this.getProblemElements().get((Object)owner2)) != null) {
            PsiElement psiElement = (PsiElement)ReadAction.compute(() -> ((RefElement)refEntity).getPsiElement());
            ArrayList<CommonProblemDescriptor> foreignDescriptors = new ArrayList<CommonProblemDescriptor>();
            for (CommonProblemDescriptor descriptor : descriptors) {
                PsiElement problemElement;
                if (descriptor instanceof ProblemDescriptor && (problemElement = (PsiElement)ReadAction.compute(() -> {
                    PsiElement element = ((ProblemDescriptor)descriptor).getPsiElement();
                    if (element instanceof PsiIdentifier) {
                        element = element.getParent();
                    }
                    return element;
                })) == psiElement) continue;
                foreignDescriptors.add(descriptor);
            }
            if (foreignDescriptors.size() == descriptors.length) {
                return;
            }
        }
        super.ignoreElement(owner2);
    }

    public void cleanup() {
        super.cleanup();
        this.myFixedElements.clear();
    }

    @Nullable
    public QuickFix findQuickFixes(@NotNull CommonProblemDescriptor descriptor, RefEntity entity, String hint) {
        if (entity instanceof RefElement) {
            if (DELETE.equals(hint)) {
                return new PermanentDeleteFix((RefElement)entity);
            }
            if (COMMENT.equals(hint)) {
                return new CommentOutFix((RefElement)entity);
            }
            if (entity instanceof RefParameter) {
                return super.findQuickFixes(descriptor, entity, hint);
            }
        }
        return null;
    }

    @NotNull
    public JComponent getCustomPreviewPanel(@NotNull RefEntity entity) {
        final Project project = entity.getRefManager().getProject();
        JEditorPane htmlView = new JEditorPane(){

            @Override
            public String getToolTipText(MouseEvent evt) {
                String objectPackage;
                HTMLDocument hdoc;
                Element e;
                AttributeSet a;
                SimpleAttributeSet value2;
                int pos = this.viewToModel(evt.getPoint());
                if (pos >= 0 && (value2 = (SimpleAttributeSet)(a = (e = (hdoc = (HTMLDocument)this.getDocument()).getCharacterElement(pos)).getAttributes()).getAttribute(HTML.Tag.A)) != null && (objectPackage = (String)value2.getAttribute("qualifiedname")) != null) {
                    return objectPackage;
                }
                return null;
            }
        };
        htmlView.setContentType("text/html");
        htmlView.setEditable(false);
        htmlView.setOpaque(false);
        htmlView.setBackground(UIUtil.getLabelBackground());
        htmlView.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                URL url = e.getURL();
                if (url == null) {
                    return;
                }
                String ref = url.getRef();
                int offset = Integer.parseInt(ref);
                String fileURL = url.toExternalForm();
                fileURL = fileURL.substring(0, fileURL.indexOf(35));
                VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(fileURL);
                if (vFile == null) {
                    vFile = VfsUtil.findFileByURL((URL)url);
                }
                if (vFile != null) {
                    Navigatable descriptor = PsiNavigationSupport.getInstance().createNavigatable(project, vFile, offset);
                    descriptor.navigate(true);
                }
            }
        });
        StyleSheet css = ((HTMLEditorKit)htmlView.getEditorKit()).getStyleSheet();
        css.addRule("p.problem-description-group {text-indent: " + JBUIScale.scale((int)9) + "px;font-weight:bold;}");
        css.addRule("div.problem-description {margin-left: " + JBUIScale.scale((int)9) + "px;}");
        css.addRule("ul {margin-left:" + JBUIScale.scale((int)10) + "px;text-indent: 0}");
        css.addRule("code {font-family:" + StartupUiUtil.getLabelFont().getFamily() + "}");
        StringBuilder buf = new StringBuilder();
        this.getComposer().compose(buf, entity, false);
        String text2 = buf.toString();
        SingleInspectionProfilePanel.readHTML((JEditorPane)htmlView, (String)SingleInspectionProfilePanel.toHTML((JEditorPane)htmlView, (String)text2, (boolean)false));
        return ScrollPaneFactory.createScrollPane((Component)htmlView, (boolean)true);
    }

    public boolean showProblemCount() {
        return false;
    }

    @ApiStatus.Internal
    protected static class UnusedDeclarationRefElementNode
    extends RefElementNode {
        UnusedDeclarationRefElementNode(@Nullable RefEntity entity, @NotNull UnusedDeclarationPresentation presentation, @NotNull InspectionTreeNode parent) {
            super(entity, (InspectionToolPresentation)presentation, parent);
        }

        @Nullable
        public String getTailText() {
            UnusedDeclarationHint hint = (UnusedDeclarationHint)((Object)((UnusedDeclarationPresentation)this.getPresentation()).myFixedElements.get(this.getElement()));
            if (hint != null) {
                return hint.getDescription();
            }
            return super.getTailText();
        }

        public boolean isQuickFixAppliedFromView() {
            return ((UnusedDeclarationPresentation)this.getPresentation()).myFixedElements.containsKey(this.getElement());
        }

        protected void visitProblemSeverities(@NotNull TObjectIntHashMap<HighlightDisplayLevel> counter) {
            if (!this.isExcluded() && this.isLeaf() && !this.getPresentation().isProblemResolved(this.getElement()) && !this.getPresentation().isSuppressed(this.getElement())) {
                HighlightSeverity severity = InspectionToolResultExporter.getSeverity((RefEntity)this.getElement(), null, (InspectionToolResultExporter)this.getPresentation());
                HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
                if (!counter.adjustValue((Object)level, 1)) {
                    counter.put((Object)level, 1);
                }
                return;
            }
            super.visitProblemSeverities(counter);
        }
    }

    private static class PermanentDeleteFix
    implements QuickFix {
        private final RefElement myElement;

        private PermanentDeleteFix(@Nullable RefElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getFamilyName() {
            return AnalysisBundle.message((String)"inspection.dead.code.safe.delete.quickfix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            if (this.myElement != null && this.myElement.isValid()) {
                SafeDeleteHandler.invoke((Project)project, (PsiElement[])new PsiElement[]{this.myElement.getPsiElement()}, (boolean)false);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }

    private static class CommentOutFix
    implements QuickFix {
        private final RefElement myElement;

        private CommentOutFix(RefElement element) {
            this.myElement = element;
        }

        @NotNull
        public String getFamilyName() {
            return AnalysisBundle.message((String)"inspection.dead.code.comment.quickfix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            PsiElement element;
            if (this.myElement != null && (element = this.myElement.getPsiElement()) != null) {
                UnusedDeclarationPresentation.commentOutDead(element);
            }
        }

        public boolean startInWriteAction() {
            return true;
        }
    }

    class CommentOutBin
    extends QuickFixAction {
        CommentOutBin(InspectionToolWrapper toolWrapper) {
            super(AnalysisBundle.message((String)"inspection.dead.code.comment.quickfix", (Object[])new Object[0]), null, KeyStroke.getKeyStroke(47, SystemInfo.isMac ? 4 : 2), toolWrapper);
        }

        protected boolean applyFix(RefEntity @NotNull [] refElements) {
            if (!super.applyFix(refElements)) {
                return false;
            }
            ArrayList deletedRefs = new ArrayList(1);
            RefFilter filter = UnusedDeclarationPresentation.this.getFilter();
            for (RefEntity refElement : refElements) {
                PsiElement psiElement;
                PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null;
                if (psiElement == null || filter.getElementProblemCount((RefJavaElement)refElement) == 0) continue;
                RefEntity owner2 = refElement.getOwner();
                if (!(owner2 instanceof RefJavaElement) || filter.getElementProblemCount((RefJavaElement)owner2) == 0 || ArrayUtil.find((Object[])refElements, (Object)owner2) <= -1) {
                    UnusedDeclarationPresentation.commentOutDead(psiElement);
                }
                refElement.getRefManager().removeRefElement((RefElement)refElement, deletedRefs);
            }
            EntryPointsManager entryPointsManager = UnusedDeclarationPresentation.this.getEntryPointsManager();
            for (RefElement refElement : deletedRefs) {
                entryPointsManager.removeEntryPoint(refElement);
            }
            for (RefElement ref : deletedRefs) {
                UnusedDeclarationPresentation.this.myFixedElements.put(ref, UnusedDeclarationHint.COMMENT);
            }
            return true;
        }
    }

    class MoveToEntries
    extends QuickFixAction {
        MoveToEntries(InspectionToolWrapper toolWrapper) {
            super(AnalysisBundle.message((String)"inspection.dead.code.entry.point.quickfix", (Object[])new Object[0]), null, null, toolWrapper);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            if (e.getPresentation().isEnabledAndVisible()) {
                RefEntity[] elements;
                for (RefEntity element : elements = MoveToEntries.getInvoker((AnActionEvent)e).getTree().getSelectedElements()) {
                    if (((RefElement)element).isEntry()) continue;
                    return;
                }
                e.getPresentation().setEnabled(false);
            }
        }

        protected boolean applyFix(RefEntity @NotNull [] refElements) {
            EntryPointsManager entryPointsManager = UnusedDeclarationPresentation.this.getEntryPointsManager();
            for (RefEntity refElement : refElements) {
                if (!(refElement instanceof RefElement)) continue;
                entryPointsManager.addEntryPoint((RefElement)refElement, true);
            }
            return true;
        }
    }

    class PermanentDeleteAction
    extends QuickFixAction {
        PermanentDeleteAction(InspectionToolWrapper toolWrapper) {
            super(AnalysisBundle.message((String)"inspection.dead.code.safe.delete.quickfix", (Object[])new Object[0]), AllIcons.Actions.Cancel, null, toolWrapper);
            this.copyShortcutFrom(ActionManager.getInstance().getAction("SafeDelete"));
        }

        protected boolean applyFix(RefEntity @NotNull [] refElements) {
            if (!super.applyFix(refElements)) {
                return false;
            }
            RefElement[] filteredRefElements = (RefElement[])Arrays.stream(refElements).filter(entry -> entry instanceof RefJavaElement && UnusedDeclarationPresentation.this.getFilter().accepts((RefJavaElement)entry)).toArray(RefElement[]::new);
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project = UnusedDeclarationPresentation.this.getContext().getProject();
                if (UnusedDeclarationPresentation.this.isDisposed() || project.isDisposed()) {
                    return;
                }
                Set classes2 = Arrays.stream(filteredRefElements).filter(refElement -> refElement instanceof RefClass).collect(Collectors.toSet());
                PsiElement[] elements = (PsiElement[])Arrays.stream(filteredRefElements).filter(e -> {
                    RefEntity owner2 = e.getOwner();
                    return owner2 == null || !classes2.contains(owner2);
                }).map(e -> e.getPsiElement()).filter(e -> e != null).toArray(PsiElement[]::new);
                SafeDeleteHandler.invoke((Project)project, (PsiElement[])elements, (boolean)false, () -> {
                    PermanentDeleteAction.removeElements((RefEntity[])filteredRefElements, (Project)project, (InspectionToolWrapper)this.myToolWrapper);
                    for (RefElement ref : filteredRefElements) {
                        UnusedDeclarationPresentation.this.myFixedElements.put(ref, UnusedDeclarationHint.DELETE);
                    }
                });
            });
            return false;
        }
    }

    private static class WeakUnreferencedFilter
    extends UnreferencedFilter {
        private WeakUnreferencedFilter(@NotNull UnusedDeclarationInspectionBase tool, @NotNull GlobalInspectionContextImpl context) {
            super(tool, (GlobalInspectionContext)context);
        }

        @Override
        public int getElementProblemCount(@NotNull RefJavaElement refElement) {
            int problemCount = super.getElementProblemCount(refElement);
            if (problemCount > -1) {
                return problemCount;
            }
            if (!((RefElementImpl)refElement).hasSuspiciousCallers() || ((RefJavaElementImpl)refElement).isSuspiciousRecursive()) {
                return 1;
            }
            for (RefElement element : refElement.getInReferences()) {
                if (refElement instanceof RefFile) {
                    return 1;
                }
                if (!((UnusedDeclarationInspectionBase)this.myTool).isEntryPoint(element)) continue;
                return 1;
            }
            return 0;
        }
    }

    private static enum UnusedDeclarationHint {
        COMMENT("Commented out"),
        DELETE("Deleted");

        private final String myDescription;

        private UnusedDeclarationHint(String description) {
            this.myDescription = description;
        }

        public String getDescription() {
            return this.myDescription;
        }
    }
}

