/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deadCode;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.deadCode.UnusedDeclarationPresentation;
import com.intellij.codeInspection.deadCode.UnusedParametersInspection;
import com.intellij.codeInspection.ex.EntryPointsManagerImpl;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspection;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspectionBase;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;

public class UnusedDeclarationInspection
extends UnusedDeclarationInspectionBase {
    private final UnusedParametersInspection myUnusedParameters = new UnusedParametersInspection();

    public UnusedDeclarationInspection() {
    }

    public UnusedDeclarationInspection(boolean enabledInEditor) {
        super(enabledInEditor);
    }

    @Nullable
    public String getAlternativeID() {
        return "UnusedParameters";
    }

    @Override
    public void runInspection(final @NotNull AnalysisScope scope, final @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (this.myLocalInspectionBase.PARAMETER) {
            globalContext.getRefManager().iterate(new RefVisitor(){

                public void visitElement(@NotNull RefEntity refEntity) {
                    if (!(refEntity instanceof RefMethod && globalContext.shouldCheck(refEntity, (GlobalInspectionTool)UnusedDeclarationInspection.this) && UnusedDeclarationPresentation.compareVisibilities((RefJavaElement)((RefMethod)refEntity), UnusedDeclarationInspection.this.myLocalInspectionBase.getParameterVisibility()))) {
                        return;
                    }
                    CommonProblemDescriptor[] descriptors = UnusedDeclarationInspection.this.myUnusedParameters.checkElement(refEntity, scope, manager, globalContext, problemDescriptionsProcessor);
                    if (descriptors != null) {
                        problemDescriptionsProcessor.addProblemElement(refEntity, descriptors);
                    }
                }
            });
        }
        super.runInspection(scope, manager, globalContext, problemDescriptionsProcessor);
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        return new UnusedVariablesGraphAnnotator(InspectionManager.getInstance((Project)refManager.getProject()), refManager);
    }

    @Override
    public boolean queryExternalUsagesRequests(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        boolean requests = super.queryExternalUsagesRequests(manager, globalContext, problemDescriptionsProcessor);
        if (!requests) {
            this.myUnusedParameters.queryExternalUsagesRequests(manager, globalContext, problemDescriptionsProcessor);
        }
        return requests;
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        return this.myUnusedParameters.getHint(fix);
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return this.myUnusedParameters.getQuickFix(hint);
    }

    @Override
    protected UnusedSymbolLocalInspectionBase createUnusedSymbolLocalInspection() {
        return new UnusedSymbolLocalInspection();
    }

    public JComponent createOptionsPanel() {
        JBTabbedPane tabs = new JBTabbedPane(1);
        tabs.add(JavaBundle.message((String)"tab.title.members.to.report", (Object[])new Object[0]), ScrollPaneFactory.createScrollPane((Component)this.myLocalInspectionBase.createOptionsPanel(), (boolean)true));
        tabs.add(JavaBundle.message((String)"tab.title.entry.points", (Object[])new Object[0]), ScrollPaneFactory.createScrollPane((Component)new OptionsPanel(), (boolean)true));
        return tabs;
    }

    private class UnusedVariablesGraphAnnotator
    extends RefGraphAnnotator {
        private final InspectionManager myInspectionManager;
        private final GlobalInspectionContextImpl myContext;
        private final Map<String, Tools> myTools;

        UnusedVariablesGraphAnnotator(InspectionManager inspectionManager, RefManager refManager) {
            this.myInspectionManager = inspectionManager;
            this.myContext = (GlobalInspectionContextImpl)((RefManagerImpl)refManager).getContext();
            this.myTools = this.myContext.getTools();
        }

        public void onReferencesBuild(RefElement refElement) {
            UExpression body2;
            UDeclaration element;
            if (refElement instanceof RefClass) {
                UClass uClass = ((RefClass)refElement).getUastElement();
                if (uClass != null) {
                    for (UClassInitializer initializer : uClass.getInitializers()) {
                        this.findUnusedLocalVariables(initializer.getUastBody(), refElement);
                    }
                }
            } else if (refElement instanceof RefMethod && (element = ((RefMethod)refElement).getUastElement()) instanceof UMethod && (body2 = ((UMethod)element).getUastBody()) != null) {
                this.findUnusedLocalVariables(body2, refElement);
            }
        }

        private void findUnusedLocalVariables(UExpression body2, RefElement refElement) {
            if (body2 == null) {
                return;
            }
            PsiCodeBlock bodySourcePsi = (PsiCodeBlock)ObjectUtils.tryCast((Object)body2.getSourcePsi(), PsiCodeBlock.class);
            if (bodySourcePsi == null) {
                return;
            }
            Tools tools = this.myTools.get(UnusedDeclarationInspection.this.getShortName());
            if (tools.isEnabled((PsiElement)bodySourcePsi)) {
                InspectionToolWrapper toolWrapper = tools.getInspectionTool((PsiElement)bodySourcePsi);
                InspectionToolPresentation presentation = this.myContext.getPresentation(toolWrapper);
                if (((UnusedDeclarationInspection)toolWrapper.getTool()).getSharedLocalInspectionTool().LOCAL_VARIABLE) {
                    ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
                    THashSet usedVariables = new THashSet();
                    List<DefUseUtil.Info> unusedDefs = DefUseUtil.getUnusedDefs(bodySourcePsi, (Set<? super PsiVariable>)usedVariables);
                    if (unusedDefs != null && !unusedDefs.isEmpty()) {
                        for (DefUseUtil.Info info : unusedDefs) {
                            PsiElement parent = info.getContext();
                            PsiVariable psiVariable = info.getVariable();
                            if (!(parent instanceof PsiDeclarationStatement) && !(parent instanceof PsiResourceVariable) || info.isRead() || SuppressionUtil.inspectionResultSuppressed((PsiElement)psiVariable, (InspectionProfileEntry)UnusedDeclarationInspection.this)) continue;
                            descriptors.add(this.createProblemDescriptor(psiVariable));
                        }
                    }
                    bodySourcePsi.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((Set)usedVariables, descriptors){
                        final /* synthetic */ Set val$usedVariables;
                        final /* synthetic */ List val$descriptors;
                        {
                            this.val$usedVariables = set;
                            this.val$descriptors = list;
                        }

                        public void visitClass(PsiClass aClass) {
                        }

                        public void visitLambdaExpression(PsiLambdaExpression expression2) {
                        }

                        public void visitLocalVariable(PsiLocalVariable variable) {
                            if (!this.val$usedVariables.contains(variable) && variable.getInitializer() == null && !SuppressionUtil.inspectionResultSuppressed((PsiElement)variable, (InspectionProfileEntry)UnusedDeclarationInspection.this)) {
                                this.val$descriptors.add(UnusedVariablesGraphAnnotator.this.createProblemDescriptor((PsiVariable)variable));
                            }
                        }
                    });
                    if (!descriptors.isEmpty()) {
                        presentation.addProblemElement((RefEntity)refElement, descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY));
                    }
                }
            }
        }

        private ProblemDescriptor createProblemDescriptor(PsiVariable psiVariable) {
            PsiElement toHighlight = (PsiElement)ObjectUtils.notNull((Object)psiVariable.getNameIdentifier(), (Object)psiVariable);
            return this.myInspectionManager.createProblemDescriptor(toHighlight, JavaBundle.message((String)"inspection.unused.assignment.problem.descriptor1", (Object[])new Object[]{"<code>#ref</code> #loc"}), (LocalQuickFix)null, ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
        }
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myMainsCheckbox;
        private final JCheckBox myAppletToEntries;
        private final JCheckBox myServletToEntries;
        private final JCheckBox myNonJavaCheckbox;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 18;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 2;
            this.add((Component)new JBLabel(JavaBundle.message((String)"label.unused.declaration.reachable.from.tests.option", (Object[])new Object[0])), gc);
            ++gc.gridy;
            JBRadioButton asEntryPoint = new JBRadioButton(JavaBundle.message((String)"radio.button.unused.declaration.used.option", (Object[])new Object[0]), UnusedDeclarationInspection.this.isTestEntryPoints());
            JBRadioButton asUnused = new JBRadioButton(JavaBundle.message((String)"radio.button.unused.declaration.unused.option", (Object[])new Object[0]), !UnusedDeclarationInspection.this.isTestEntryPoints());
            ButtonGroup group = new ButtonGroup();
            group.add((AbstractButton)asEntryPoint);
            group.add((AbstractButton)asUnused);
            ActionListener listener = e -> UnusedDeclarationInspection.this.setTestEntryPoints(asEntryPoint.isSelected());
            asEntryPoint.addActionListener(listener);
            asUnused.addActionListener(listener);
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            this.add((Component)asEntryPoint, gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.add((Component)asUnused, gc);
            gc.gridx = 0;
            ++gc.gridy;
            gc.gridwidth = 2;
            this.add((Component)new TitledSeparator(), gc);
            ++gc.gridy;
            this.add((Component)new JBLabel(JavaBundle.message((String)"label.entry.points", (Object[])new Object[0])), gc);
            gc.insets = JBUI.insets((int)5, (int)0, (int)0, (int)0);
            ++gc.gridy;
            this.add((Component)this.createBtnPanel(), gc);
            ++gc.gridy;
            gc.insets = JBUI.insets((int)0, (int)5, (int)2, (int)0);
            this.myMainsCheckbox = new JCheckBox(JavaBundle.message((String)"inspection.dead.code.option.main", (Object[])new Object[0]));
            this.myMainsCheckbox.setSelected(UnusedDeclarationInspection.this.ADD_MAINS_TO_ENTRIES);
            this.myMainsCheckbox.addActionListener(e -> {
                UnusedDeclarationInspection.this.ADD_MAINS_TO_ENTRIES = this.myMainsCheckbox.isSelected();
            });
            this.add((Component)this.myMainsCheckbox, gc);
            ++gc.gridy;
            this.myAppletToEntries = new JCheckBox(JavaBundle.message((String)"inspection.dead.code.option.applet", (Object[])new Object[0]));
            this.myAppletToEntries.setSelected(UnusedDeclarationInspection.this.ADD_APPLET_TO_ENTRIES);
            this.myAppletToEntries.addActionListener(e -> {
                UnusedDeclarationInspection.this.ADD_APPLET_TO_ENTRIES = this.myAppletToEntries.isSelected();
            });
            this.add((Component)this.myAppletToEntries, gc);
            ++gc.gridy;
            this.myServletToEntries = new JCheckBox(JavaBundle.message((String)"inspection.dead.code.option.servlet", (Object[])new Object[0]));
            this.myServletToEntries.setSelected(UnusedDeclarationInspection.this.ADD_SERVLET_TO_ENTRIES);
            this.myServletToEntries.addActionListener(e -> {
                UnusedDeclarationInspection.this.ADD_SERVLET_TO_ENTRIES = this.myServletToEntries.isSelected();
            });
            this.add((Component)this.myServletToEntries, gc);
            ++gc.gridy;
            for (EntryPoint extension : UnusedDeclarationInspection.this.getExtensions()) {
                if (!extension.showUI()) continue;
                JCheckBox extCheckbox = new JCheckBox(extension.getDisplayName());
                extCheckbox.setSelected(extension.isSelected());
                extCheckbox.addActionListener(e -> extension.setSelected(extCheckbox.isSelected()));
                this.add((Component)extCheckbox, gc);
                ++gc.gridy;
            }
            this.myNonJavaCheckbox = new JCheckBox(JavaBundle.message((String)"inspection.dead.code.option.external", (Object[])new Object[0]));
            this.myNonJavaCheckbox.setSelected(UnusedDeclarationInspection.this.ADD_NONJAVA_TO_ENTRIES);
            this.myNonJavaCheckbox.addActionListener(e -> {
                UnusedDeclarationInspection.this.ADD_NONJAVA_TO_ENTRIES = this.myNonJavaCheckbox.isSelected();
            });
            gc.weighty = 1.0;
            this.add((Component)this.myNonJavaCheckbox, gc);
        }

        private JPanel createBtnPanel() {
            JPanel btnPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.weightx = 0.0;
            btnPanel.add((Component)EntryPointsManagerImpl.createConfigureClassPatternsButton(), constraints);
            constraints.gridx = 1;
            btnPanel.add((Component)EntryPointsManagerImpl.createConfigureAnnotationsButton(), constraints);
            constraints.fill = 2;
            constraints.weightx = 1.0;
            btnPanel.add((Component)Box.createHorizontalBox(), constraints);
            return btnPanel;
        }
    }
}

