/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaTypeValue
extends DfaValue {
    @NotNull
    private final DfType myType;

    DfaTypeValue(@NotNull DfaValueFactory factory, @NotNull DfType type2) {
        super(factory);
        this.myType = type2;
    }

    @Override
    @NotNull
    public DfType getDfType() {
        return this.myType;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return DfaTypeValue.toPsiType(this.myFactory.getProject(), this.myType);
    }

    public static boolean isUnknown(DfaValue value2) {
        return value2 instanceof DfaTypeValue && value2.getDfType() == DfTypes.TOP;
    }

    public String toString() {
        return this.myType.toString();
    }

    @Contract(value="null -> false")
    public static boolean isContractFail(DfaValue value2) {
        return value2 instanceof DfaTypeValue && value2.getDfType() == DfTypes.FAIL;
    }

    @Nullable
    public static PsiType toPsiType(Project project, DfType dfType) {
        if (dfType instanceof DfPrimitiveType) {
            return ((DfPrimitiveType)dfType).getPsiType();
        }
        if (dfType instanceof DfReferenceType) {
            return ((DfReferenceType)dfType).getConstraint().getPsiType(project);
        }
        return null;
    }

    static class Factory {
        private final DfaValueFactory myFactory;
        private final Map<DfType, DfaTypeValue> myValues = new HashMap<DfType, DfaTypeValue>();

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        @NotNull
        DfaTypeValue create(@NotNull DfType type2) {
            return this.myValues.computeIfAbsent(type2, t -> new DfaTypeValue(this.myFactory, (DfType)t));
        }
    }
}

