/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntRangeType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DfIntType
extends DfIntegralType {
    @Override
    @NotNull
    public LongRangeSet getRange();

    @Override
    @NotNull
    default public DfType join(@NotNull DfType other) {
        if (!(other instanceof DfIntType)) {
            return DfTypes.TOP;
        }
        return DfTypes.intRange(((DfIntType)other).getRange().unite(this.getRange()));
    }

    @Override
    @NotNull
    default public DfType meet(@NotNull DfType other) {
        if (other == DfTypes.TOP) {
            return this;
        }
        if (!(other instanceof DfIntType)) {
            return DfTypes.BOTTOM;
        }
        return DfTypes.intRange(((DfIntType)other).getRange().intersect(this.getRange()));
    }

    @Override
    @NotNull
    default public DfType meetRange(@NotNull LongRangeSet range) {
        return this.meet(DfTypes.intRangeClamped(range));
    }

    @Override
    @NotNull
    default public PsiPrimitiveType getPsiType() {
        return PsiType.INT;
    }

    @Override
    @Nullable
    default public DfType tryNegate() {
        LongRangeSet range = this.getRange();
        LongRangeSet res = DfIntRangeType.FULL_RANGE.subtract(range);
        return res.intersects(range) ? null : DfTypes.intRange(res);
    }

    @NotNull
    public static LongRangeSet extractRange(@NotNull DfType type2) {
        return type2 instanceof DfIntegralType ? ((DfIntegralType)type2).getRange().intersect(DfIntRangeType.FULL_RANGE) : DfIntRangeType.FULL_RANGE;
    }
}

