/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringExpressionHelper {
    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression2) {
        return StringExpressionHelper.evaluateExpression(expression2, new HashSet<PsiElement>());
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression2, @NotNull Collection<PsiElement> visited) {
        Pair<PsiElement, String> expr2;
        PsiExpression initializer;
        PsiElement resolve2;
        if (!visited.add(expression2)) {
            return null;
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return StringExpressionHelper.evaluatePsiLiteralExpression(expression2);
        }
        if (expression2 instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiVariable && (initializer = ((PsiVariable)resolve2).getInitializer()) != null && (expr2 = StringExpressionHelper.evaluateExpression((PsiElement)initializer, visited)) != null) {
            return expr2;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiElement element = ((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
            if (element instanceof PsiMethod) {
                PsiCodeBlock body2 = ((PsiMethod)element).getBody();
                if (body2 != null) {
                    final HashSet returns = new HashSet();
                    body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitClass(PsiClass aClass) {
                        }

                        public void visitLambdaExpression(PsiLambdaExpression expression2) {
                        }

                        public void visitReturnStatement(PsiReturnStatement statement) {
                            PsiExpression returnValue = statement.getReturnValue();
                            if (returnValue != null) {
                                returns.add(returnValue);
                            }
                        }
                    });
                    for (PsiExpression psiExpression : returns) {
                        Pair<PsiElement, String> pair2 = StringExpressionHelper.evaluateExpression((PsiElement)psiExpression, visited);
                        if (pair2 == null) continue;
                        return pair2;
                    }
                }
                return StringExpressionHelper.evaluateExpression(element, visited);
            }
            return null;
        }
        Pair<PsiElement, String> constantExpression = StringExpressionHelper.evaluateConstantExpression(expression2);
        if (constantExpression != null) {
            return constantExpression;
        }
        if (expression2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            return StringExpressionHelper.evaluatePolyadicExpressions(expression2, visited, binaryExpression.getLOperand(), binaryExpression.getROperand());
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            return StringExpressionHelper.evaluatePolyadicExpressions(expression2, visited, ((PsiPolyadicExpression)expression2).getOperands());
        }
        Collection<PsiExpression> elements = DfaUtil.getPossibleInitializationElements(expression2);
        for (PsiElement psiElement : elements) {
            Pair<PsiElement, String> expr3 = StringExpressionHelper.evaluateExpression(psiElement, visited);
            if (expr3 == null) continue;
            return expr3;
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, String> evaluatePolyadicExpressions(@NotNull PsiElement expression2, @NotNull Collection<PsiElement> visited, PsiExpression ... operands2) {
        StringBuilder sb = new StringBuilder();
        for (PsiExpression operand2 : operands2) {
            Pair<PsiElement, String> pair2 = StringExpressionHelper.evaluateExpression((PsiElement)operand2, visited);
            if (pair2 == null) {
                return null;
            }
            sb.append((String)pair2.second);
        }
        return Pair.create((Object)expression2, (Object)sb.toString());
    }

    @NotNull
    private static Pair<PsiElement, String> evaluatePsiLiteralExpression(@NotNull PsiElement expression2) {
        return Pair.create((Object)expression2, (Object)ElementManipulators.getValueText((PsiElement)expression2));
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateConstantExpression(@NotNull PsiElement expression2) {
        PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getConstantEvaluationHelper();
        Object result = helper.computeConstantExpression(expression2);
        if (result instanceof String) {
            return Pair.create((Object)expression2, (Object)((String)result));
        }
        return null;
    }

    @NotNull
    public static Set<Pair<PsiElement, String>> searchStringExpressions(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope, int expNum) {
        HashSet<Pair<PsiElement, String>> pairs = new HashSet<Pair<PsiElement, String>>();
        for (PsiCall methodCallExpression : StringExpressionHelper.searchMethodCalls(psiMethod, searchScope)) {
            PsiExpression expression2;
            Pair<PsiElement, String> pair2;
            PsiExpression[] expressions2;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList == null || (expressions2 = argumentList.getExpressions()).length <= expNum || (pair2 = StringExpressionHelper.evaluateExpression((PsiElement)(expression2 = expressions2[expNum]))) == null) continue;
            pairs.add(pair2);
        }
        return pairs;
    }

    @NotNull
    public static Set<PsiCall> searchMethodCalls(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope) {
        HashSet<PsiCall> callExpressions = new HashSet<PsiCall>();
        CommonProcessors.CollectUniquesProcessor consumer = new CommonProcessors.CollectUniquesProcessor();
        MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope, (boolean)true).forEach((Processor)consumer);
        for (PsiReference psiReference : consumer.getResults()) {
            PsiCall methodCallExpression = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiCall.class);
            if (methodCallExpression == null) continue;
            callExpressions.add(methodCallExpression);
        }
        return callExpressions;
    }
}

