/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushFieldsInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import org.jetbrains.annotations.NotNull;

public class SideEffectVisitor
extends StandardInstructionVisitor {
    protected boolean isModificationAllowed(DfaVariableValue variable) {
        return false;
    }

    @Override
    public DfaInstructionState[] visitFlushFields(FlushFieldsInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        runner.cancel();
        return super.visitFlushFields(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitFlushVariable(FlushVariableInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        if (!this.isModificationAllowed(instruction.getVariable())) {
            runner.cancel();
        }
        return super.visitFlushVariable(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState @NotNull [] visitControlTransfer(@NotNull ControlTransferInstruction instruction, @NotNull DataFlowRunner runner, @NotNull DfaMemoryState state) {
        if (instruction instanceof ReturnInstruction && (((ReturnInstruction)instruction).getAnchor() != null || ((ReturnInstruction)instruction).isViaException())) {
            runner.cancel();
        }
        return super.visitControlTransfer(instruction, runner, state);
    }

    @Override
    public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        if (!instruction.getMutationSignature().isPure()) {
            runner.cancel();
        }
        return super.visitMethodCall(instruction, runner, memState);
    }

    @Override
    public DfaInstructionState[] visitAssign(AssignInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
        DfaValue dest = memState.pop();
        DfaValue src = memState.peek();
        memState.push(dest);
        if (!(src instanceof DfaVariableValue) || !this.isModificationAllowed((DfaVariableValue)src)) {
            runner.cancel();
        }
        return super.visitAssign(instruction, runner, memState);
    }
}

