/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.value.DfaBoxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaUtil {
    @NotNull
    public static Collection<PsiExpression> getVariableValues(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        if (variable == null || context == null) {
            return Collections.emptyList();
        }
        PsiCodeBlock codeBlock = (PsiCodeBlock)ObjectUtils.tryCast((Object)DfaUtil.getEnclosingCodeBlock(variable, context), PsiCodeBlock.class);
        if (codeBlock == null) {
            return Collections.emptyList();
        }
        PsiElement[] defs = DefUseUtil.getDefs(codeBlock, variable, context);
        ArrayList<PsiExpression> results = new ArrayList<PsiExpression>();
        for (PsiElement def : defs) {
            if (def instanceof PsiLocalVariable) {
                ContainerUtil.addIfNotNull(results, (Object)((PsiLocalVariable)def).getInitializer());
                continue;
            }
            if (def instanceof PsiReferenceExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)def.getParent(), PsiAssignmentExpression.class);
                if (assignment == null || assignment.getLExpression() != def) continue;
                ContainerUtil.addIfNotNull(results, (Object)DfaUtil.unrollConcatenation(assignment, variable, codeBlock));
                continue;
            }
            if (!(def instanceof PsiExpression)) continue;
            results.add((PsiExpression)def);
        }
        return results;
    }

    private static PsiElement getEnclosingCodeBlock(PsiVariable variable, PsiElement context) {
        PsiAnonymousClass anon;
        PsiElement codeBlock;
        if (variable instanceof PsiParameter) {
            codeBlock = ((PsiParameter)variable).getDeclarationScope();
            if (codeBlock instanceof PsiMethod) {
                codeBlock = ((PsiMethod)codeBlock).getBody();
            }
        } else {
            codeBlock = variable instanceof PsiLocalVariable ? PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class) : DfaPsiUtil.getTopmostBlockInSameClass(context);
        }
        while (codeBlock != null && (anon = (PsiAnonymousClass)PsiTreeUtil.getParentOfType((PsiElement)codeBlock, PsiAnonymousClass.class)) != null) {
            codeBlock = PsiTreeUtil.getParentOfType((PsiElement)anon, PsiCodeBlock.class);
        }
        return codeBlock;
    }

    private static PsiExpression unrollConcatenation(PsiAssignmentExpression assignment, PsiVariable variable, PsiCodeBlock block) {
        ArrayList<PsiExpression> operands2;
        block8: {
            operands2 = new ArrayList<PsiExpression>();
            while (true) {
                if (assignment == null) {
                    return null;
                }
                PsiExpression rExpression = assignment.getRExpression();
                if (rExpression == null) {
                    return null;
                }
                operands2.add(rExpression);
                IElementType type2 = assignment.getOperationTokenType();
                if (type2.equals(JavaTokenType.EQ)) break block8;
                if (!type2.equals(JavaTokenType.PLUSEQ)) {
                    return null;
                }
                PsiElement[] previous = DefUseUtil.getDefs(block, variable, (PsiElement)assignment);
                if (previous.length != 1) {
                    return null;
                }
                PsiElement def = previous[0];
                if (def instanceof PsiLocalVariable) {
                    PsiExpression initializer = ((PsiLocalVariable)def).getInitializer();
                    if (initializer == null) {
                        return null;
                    }
                    operands2.add(initializer);
                    break block8;
                }
                if (!(def instanceof PsiReferenceExpression)) break;
                assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)def.getParent(), PsiAssignmentExpression.class);
            }
            return null;
        }
        if (operands2.size() == 1) {
            return (PsiExpression)operands2.get(0);
        }
        return JavaPsiFacade.getElementFactory((Project)block.getProject()).createExpressionFromText(StreamEx.ofReversed(operands2).map(op -> ParenthesesUtils.getText(op, 6)).joining((CharSequence)"+"), (PsiElement)assignment);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @NotNull
    public static Nullability checkNullability(@Nullable PsiVariable variable, @Nullable PsiElement context) {
        if (context instanceof PsiExpression) {
            return NullabilityUtil.getExpressionNullability((PsiExpression)context, true);
        }
        return Nullability.UNKNOWN;
    }

    @NotNull
    public static Collection<PsiExpression> getPossibleInitializationElements(@NotNull PsiElement qualifierExpression2) {
        if (qualifierExpression2 instanceof PsiMethodCallExpression) {
            return Collections.singletonList((PsiMethodCallExpression)qualifierExpression2);
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement targetElement = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (!(targetElement instanceof PsiVariable)) {
                return Collections.emptyList();
            }
            Collection<PsiExpression> variableValues = DfaUtil.getVariableValues((PsiVariable)targetElement, qualifierExpression2);
            if (variableValues.isEmpty()) {
                return DfaPsiUtil.getVariableAssignmentsInFile((PsiVariable)targetElement, false, qualifierExpression2);
            }
            return variableValues;
        }
        if (qualifierExpression2 instanceof PsiLiteralExpression) {
            return Collections.singletonList((PsiLiteralExpression)qualifierExpression2);
        }
        return Collections.emptyList();
    }

    @NotNull
    public static Nullability inferMethodNullability(PsiMethod method) {
        if (PsiUtil.resolveClassInType((PsiType)method.getReturnType()) == null) {
            return Nullability.UNKNOWN;
        }
        return DfaUtil.inferBlockNullability((PsiParameterListOwner)method, DfaUtil.suppressNullable(method));
    }

    private static boolean suppressNullable(PsiMethod method) {
        if (method.getParameterList().isEmpty()) {
            return false;
        }
        for (StandardMethodContract contract : JavaMethodContractUtil.getMethodContracts(method)) {
            if (!contract.getReturnValue().isNull()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Nullability inferLambdaNullability(PsiLambdaExpression lambda2) {
        if (LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda2) == null) {
            return Nullability.UNKNOWN;
        }
        return DfaUtil.inferBlockNullability((PsiParameterListOwner)lambda2, false);
    }

    @NotNull
    private static Nullability inferBlockNullability(@NotNull PsiParameterListOwner owner2, boolean suppressNullable) {
        BlockNullabilityVisitor visitor2;
        PsiElement body2 = owner2.getBody();
        if (body2 == null) {
            return Nullability.UNKNOWN;
        }
        DataFlowRunner dfaRunner = new DataFlowRunner(owner2.getProject());
        class BlockNullabilityVisitor
        extends StandardInstructionVisitor {
            boolean hasNulls = false;
            boolean hasNotNulls = false;
            boolean hasUnknowns = false;
            final /* synthetic */ PsiParameterListOwner val$owner;

            BlockNullabilityVisitor(PsiParameterListOwner psiParameterListOwner) {
                this.val$owner = psiParameterListOwner;
            }

            @Override
            protected void checkReturnValue(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @NotNull PsiParameterListOwner context, @NotNull DfaMemoryState state) {
                if (context == this.val$owner) {
                    if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expression2.getType()) || state.isNotNull(value2)) {
                        this.hasNotNulls = true;
                    } else if (state.isNull(value2)) {
                        this.hasNulls = true;
                    } else {
                        this.hasUnknowns = true;
                    }
                }
            }
        }
        RunnerResult rc = dfaRunner.analyzeMethod(body2, visitor2 = new BlockNullabilityVisitor(owner2));
        if (rc == RunnerResult.OK) {
            if (visitor2.hasNulls) {
                return suppressNullable ? Nullability.UNKNOWN : Nullability.NULLABLE;
            }
            if (visitor2.hasNotNulls && !visitor2.hasUnknowns) {
                return Nullability.NOT_NULL;
            }
        }
        return Nullability.UNKNOWN;
    }

    static DfaValue getPossiblyNonInitializedValue(@NotNull DfaValueFactory factory, @NotNull PsiField target, @NotNull PsiElement context) {
        if (target.getType() instanceof PsiPrimitiveType) {
            return null;
        }
        PsiMethod placeMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class, (boolean)false, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        if (placeMethod == null) {
            return null;
        }
        PsiClass placeClass = placeMethod.getContainingClass();
        if (placeClass == null || placeClass != target.getContainingClass()) {
            return null;
        }
        if (!placeMethod.hasModifierProperty("static") && target.hasModifierProperty("static")) {
            return null;
        }
        if (DfaUtil.getAccessOffset(placeMethod) >= DfaUtil.getWriteOffset(target)) {
            return null;
        }
        return factory.getObjectType(target.getType(), Nullability.NULLABLE);
    }

    private static int getWriteOffset(PsiField target) {
        boolean isFinal = target.hasModifierProperty("final");
        int offset = Integer.MAX_VALUE;
        if (target.getInitializer() != null) {
            offset = target.getInitializer().getTextRange().getStartOffset();
            if (isFinal) {
                return offset;
            }
        }
        PsiClass aClass = Objects.requireNonNull(target.getContainingClass());
        PsiClassInitializer[] initializers = aClass.getInitializers();
        Predicate<PsiElement> writesToTarget = element -> !PsiTreeUtil.processElements((PsiElement)element, e -> !(e instanceof PsiExpression) || !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)e)) || !ExpressionUtils.isReferenceTo((PsiExpression)e, (PsiVariable)target));
        Predicate<PsiElement> hasSideEffectCall = element -> !PsiTreeUtil.findChildrenOfType((PsiElement)element, PsiMethodCallExpression.class).stream().map(PsiCall::resolveMethod).allMatch(method -> method != null && JavaMethodContractUtil.isPure(method));
        for (PsiClassInitializer psiClassInitializer : initializers) {
            if (psiClassInitializer.hasModifierProperty("static") != target.hasModifierProperty("static")) continue;
            if (!isFinal && hasSideEffectCall.test((PsiElement)psiClassInitializer)) {
                offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
                break;
            }
            if (!writesToTarget.test((PsiElement)psiClassInitializer)) continue;
            offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
            if (!isFinal) break;
            return offset;
        }
        if (!isFinal) {
            for (PsiClassInitializer psiClassInitializer : aClass.getFields()) {
                if (psiClassInitializer.hasModifierProperty("static") != target.hasModifierProperty("static") || !hasSideEffectCall.test((PsiElement)psiClassInitializer.getInitializer()) && !writesToTarget.test((PsiElement)psiClassInitializer)) continue;
                offset = Math.min(offset, psiClassInitializer.getTextRange().getStartOffset());
                break;
            }
        }
        return offset;
    }

    private static int getAccessOffset(PsiMethod referrer) {
        PsiClass aClass = Objects.requireNonNull(referrer.getContainingClass());
        boolean isStatic = referrer.hasModifierProperty("static");
        for (PsiField field : aClass.getFields()) {
            Predicate<PsiExpression> callToMethod;
            PsiExpression initializer;
            if (field.hasModifierProperty("static") != isStatic || !ExpressionUtils.isMatchingChildAlwaysExecuted(initializer = field.getInitializer(), callToMethod = e -> {
                if (!(e instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression call = (PsiMethodCallExpression)e;
                return call.getMethodExpression().isReferenceTo((PsiElement)referrer) && (isStatic || ExpressionUtil.isEffectivelyUnqualified(call.getMethodExpression()));
            })) continue;
            return field.getTextRange().getStartOffset();
        }
        return Integer.MAX_VALUE;
    }

    public static boolean hasInitializationHacks(@NotNull PsiField field) {
        PsiClass containingClass = field.getContainingClass();
        return containingClass != null && System.class.getName().equals(containingClass.getQualifiedName());
    }

    public static boolean ignoreInitializer(PsiVariable variable) {
        if (variable instanceof PsiField && variable.hasModifierProperty("final") && variable.getType().equals(PsiType.BOOLEAN)) {
            PsiLiteralExpression initializer = (PsiLiteralExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()), PsiLiteralExpression.class);
            return initializer != null && initializer.getValue() instanceof Boolean;
        }
        return false;
    }

    static boolean isEffectivelyUnqualified(DfaVariableValue variableValue) {
        return variableValue.getQualifier() == null || variableValue.getQualifier().getDescriptor() instanceof DfaExpressionFactory.ThisDescriptor;
    }

    public static boolean hasImplicitImpureSuperCall(PsiClass aClass, PsiMethod constructor) {
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null) {
            return false;
        }
        PsiElement superCtor = JavaResolveUtil.resolveImaginarySuperCallInThisPlace((PsiMember)constructor, constructor.getProject(), superClass);
        if (!(superCtor instanceof PsiMethod)) {
            return false;
        }
        return !JavaMethodContractUtil.isPure((PsiMethod)superCtor);
    }

    @Nullable
    static PsiElement getDataflowContext(PsiExpression expression2) {
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMember.class);
        while (member instanceof PsiAnonymousClass && PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)member).getArgumentList(), (PsiElement)expression2, (boolean)true)) {
            member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)member, PsiMember.class);
        }
        if (member instanceof PsiField || member instanceof PsiClassInitializer) {
            return member.getContainingClass();
        }
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).isConstructor() ? member.getContainingClass() : ((PsiMethod)member).getBody();
        }
        return null;
    }

    @Nullable
    public static Boolean evaluateCondition(@Nullable PsiExpression condition2) {
        CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(condition2);
        if (result == null) {
            return null;
        }
        return (Boolean)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem(result.getExpressionValues(condition2)), Boolean.class);
    }

    public static DfaValue boxUnbox(DfaValue value2, @Nullable PsiType type2) {
        if (TypeConversionUtil.isPrimitiveWrapper((PsiType)type2) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)value2.getType())) {
            DfaValue boxed = value2.getFactory().getBoxedFactory().createBoxed(value2, type2);
            return boxed == null ? value2.getFactory().getUnknown() : boxed;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2)) {
            if (value2 instanceof DfaBoxedValue || TypeConversionUtil.isPrimitiveWrapper((PsiType)value2.getType())) {
                return SpecialField.UNBOX.createValue(value2.getFactory(), value2);
            }
            if (value2.getDfType() instanceof DfReferenceType) {
                return value2.getFactory().getObjectType(type2, Nullability.NOT_NULL);
            }
        }
        return value2;
    }

    @NotNull
    public static List<? extends MethodContract> addRangeContracts(@Nullable PsiMethod method, @NotNull List<? extends MethodContract> contracts2) {
        if (method == null) {
            return contracts2;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        ArrayList<MethodContract> rangeContracts = new ArrayList<MethodContract>();
        for (int i = 0; i < parameters2.length; ++i) {
            MethodContract contract;
            PsiParameter parameter2 = parameters2[i];
            LongRangeSet fromType = LongRangeSet.fromType(parameter2.getType());
            if (fromType == null) continue;
            LongRangeSet fromAnnotation = LongRangeSet.fromPsiElement((PsiModifierListOwner)parameter2);
            if (fromAnnotation.min() > fromType.min()) {
                contract = MethodContract.singleConditionContract(ContractValue.argument(i), RelationType.LT, ContractValue.constant(fromAnnotation.min(), parameter2.getType()), ContractReturnValue.fail());
                rangeContracts.add(contract);
            }
            if (fromAnnotation.max() >= fromType.max()) continue;
            contract = MethodContract.singleConditionContract(ContractValue.argument(i), RelationType.GT, ContractValue.constant(fromAnnotation.max(), parameter2.getType()), ContractReturnValue.fail());
            rangeContracts.add(contract);
        }
        return ContainerUtil.concat(rangeContracts, contracts2);
    }

    public static boolean isEmptyCollectionConstantField(@Nullable PsiVariable var) {
        if (!(var instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)var;
        return field.getName().startsWith("EMPTY_") && field.getContainingClass() != null && "java.util.Collections".equals(field.getContainingClass().getQualifiedName());
    }

    public static boolean isNaN(Object value2) {
        return value2 instanceof Double && ((Double)value2).isNaN() || value2 instanceof Float && ((Float)value2).isNaN();
    }
}

