/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaOptionalSupport {
    @Nullable
    static LocalQuickFix registerReplaceOptionalOfWithOfNullableFix(@NotNull PsiExpression qualifier) {
        PsiClass containingClass;
        PsiMethodCallExpression call = DfaOptionalSupport.findCallExpression((PsiElement)qualifier);
        PsiMethod method = call == null ? null : call.resolveMethod();
        PsiClass psiClass = containingClass = method == null ? null : method.getContainingClass();
        if (containingClass != null && "of".equals(method.getName())) {
            String qualifiedName = containingClass.getQualifiedName();
            if ("java.util.Optional".equals(qualifiedName)) {
                return new ReplaceOptionalCallFix("ofNullable", false);
            }
            if ("com.google.common.base.Optional".equals(qualifiedName)) {
                return new ReplaceOptionalCallFix("fromNullable", false);
            }
        }
        return null;
    }

    private static PsiMethodCallExpression findCallExpression(@NotNull PsiElement anchor) {
        PsiElement parent;
        PsiElement argList = PsiUtil.skipParenthesizedExprUp((PsiElement)anchor).getParent();
        if (argList instanceof PsiExpressionList && (parent = argList.getParent()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)parent;
        }
        return null;
    }

    @Nullable
    static LocalQuickFix createReplaceOptionalOfNullableWithEmptyFix(@NotNull PsiElement anchor) {
        PsiMethodCallExpression parent = DfaOptionalSupport.findCallExpression(anchor);
        if (parent == null) {
            return null;
        }
        boolean jdkOptional = OptionalUtil.JDK_OPTIONAL_OF_NULLABLE.test(parent);
        return new ReplaceOptionalCallFix(jdkOptional ? "empty" : "absent", true);
    }

    @Nullable
    static LocalQuickFix createReplaceOptionalOfNullableWithOfFix(@NotNull PsiElement anchor) {
        PsiMethodCallExpression parent = DfaOptionalSupport.findCallExpression(anchor);
        if (parent == null) {
            return null;
        }
        return new ReplaceOptionalCallFix("of", false);
    }

    @NotNull
    public static DfType getOptionalValue(boolean present) {
        DfReferenceType valueType = present ? DfTypes.NOT_NULL_OBJECT : DfTypes.NULL;
        return SpecialField.OPTIONAL_VALUE.asDfType(valueType);
    }

    private static class ReplaceOptionalCallFix
    implements LocalQuickFix {
        private final String myTargetMethodName;
        private final boolean myClearArguments;

        ReplaceOptionalCallFix(String targetMethodName, boolean clearArguments) {
            this.myTargetMethodName = targetMethodName;
            this.myClearArguments = clearArguments;
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"." + this.myTargetMethodName + "()"});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethodCallExpression.class);
            if (methodCallExpression != null) {
                PsiExpressionList argList;
                PsiExpression[] args;
                ExpressionUtils.bindCallTo(methodCallExpression, this.myTargetMethodName);
                if (this.myClearArguments && (args = (argList = methodCallExpression.getArgumentList()).getExpressions()).length > 0) {
                    argList.deleteChildRange((PsiElement)args[0], (PsiElement)args[args.length - 1]);
                }
            }
        }
    }
}

