/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DfaCallArguments {
    final DfaValue myQualifier;
    final DfaValue[] myArguments;
    @NotNull
    final MutationSignature myMutation;

    DfaCallArguments(DfaValue qualifier, DfaValue[] arguments, @NotNull MutationSignature mutation) {
        this.myQualifier = qualifier;
        this.myArguments = arguments;
        this.myMutation = mutation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DfaCallArguments)) {
            return false;
        }
        DfaCallArguments that = (DfaCallArguments)o;
        return this.myQualifier == that.myQualifier && this.myMutation.equals(that.myMutation) && Arrays.equals(this.myArguments, that.myArguments);
    }

    public int hashCode() {
        return (Objects.hashCode(this.myQualifier) * 31 + Arrays.hashCode(this.myArguments)) * 31 + this.myMutation.hashCode();
    }

    public void flush(DfaMemoryState state) {
        if (this.myMutation.isPure()) {
            return;
        }
        if (this.myMutation == MutationSignature.UNKNOWN || this.myArguments == null) {
            state.flushFields();
            return;
        }
        HashSet<DfaValue> qualifiers = new HashSet<DfaValue>();
        if (this.myQualifier != null && this.myMutation.mutatesThis()) {
            qualifiers.add(this.myQualifier);
        }
        for (int i = 0; i < this.myArguments.length; ++i) {
            if (!this.myMutation.mutatesArg(i)) continue;
            qualifiers.add(this.myArguments[i]);
        }
        state.flushFieldsQualifiedBy(qualifiers);
    }

    @Nullable
    static DfaCallArguments fromCall(DfaValueFactory factory, PsiCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        DfaValue qualifierValue = null;
        if (call instanceof PsiMethodCallExpression) {
            PsiExpression qualifier = ((PsiMethodCallExpression)call).getMethodExpression().getQualifierExpression();
            qualifierValue = factory.createValue(qualifier);
        }
        if (qualifierValue == null) {
            qualifierValue = factory.getUnknown();
        }
        boolean varArgCall = MethodCallUtils.isVarArgCall((PsiCall)call);
        PsiExpression[] args = argumentList.getExpressions();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        DfaValue[] argValues = new DfaValue[parameters2.length];
        for (int i = 0; i < parameters2.length; ++i) {
            DfaValue argValue = null;
            if (!(i >= args.length || varArgCall && i >= parameters2.length - 1)) {
                argValue = factory.createValue(args[i]);
            }
            if (argValue == null) {
                argValue = factory.getUnknown();
            }
            argValues[i] = argValue;
        }
        DfaCallArguments arguments = new DfaCallArguments(qualifierValue, argValues, MutationSignature.fromCall((PsiCall)call));
        return arguments;
    }
}

