/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ContractChecker;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContractInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiAnnotation annotation = JavaMethodContractUtil.findContractAnnotation(method);
                if (annotation == null || !ApplicationManager.getApplication().isInternal() && AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation)) {
                    return;
                }
                boolean ownContract = annotation.getOwner() == method.getModifierList();
                for (StandardMethodContract contract : JavaMethodContractUtil.getMethodContracts(method)) {
                    Map<PsiElement, String> errors = ContractChecker.checkContractClause(method, contract, ownContract);
                    errors.forEach((x$0, x$1) -> holder.registerProblem(x$0, x$1, new LocalQuickFix[0]));
                }
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                StandardMethodContract.ParseException error;
                if (!JavaMethodContractUtil.ORG_JETBRAINS_ANNOTATIONS_CONTRACT.equals(annotation.getQualifiedName())) {
                    return;
                }
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
                if (method == null) {
                    return;
                }
                String text2 = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, null);
                if (StringUtil.isNotEmpty((String)text2) && (error = ContractInspection.checkContract(method, text2)) != null) {
                    PsiAnnotationMemberValue value2 = annotation.findAttributeValue(null);
                    assert (value2 != null);
                    TextRange actualRange = null;
                    if (value2 instanceof PsiExpression && error.getRange() != null) {
                        actualRange = ExpressionUtils.findStringLiteralRange((PsiExpression)value2, error.getRange().getStartOffset(), error.getRange().getEndOffset());
                    }
                    holder.registerProblem((PsiElement)value2, actualRange, error.getMessage(), new LocalQuickFix[0]);
                }
                this.checkMutationContract(annotation, method);
            }

            private void checkMutationContract(PsiAnnotation annotation, PsiMethod method) {
                boolean pure;
                String error;
                String mutationContract = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"mutates");
                if (StringUtil.isNotEmpty((String)mutationContract) && (error = (pure = Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)"pure"))) ? JavaAnalysisBundle.message((String)"inspection.contract.checker.pure.method.mutation.contract", (Object[])new Object[0]) : MutationSignature.checkSignature(mutationContract, method)) != null) {
                    PsiAnnotationMemberValue value2 = annotation.findAttributeValue("mutates");
                    assert (value2 != null);
                    holder.registerProblem((PsiElement)value2, error, new LocalQuickFix[0]);
                }
            }
        };
    }

    @Nullable
    public static StandardMethodContract.ParseException checkContract(PsiMethod method, String text2) {
        List<StandardMethodContract> contracts2;
        try {
            contracts2 = StandardMethodContract.parseContract(text2);
        }
        catch (StandardMethodContract.ParseException e) {
            return e;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        int paramCount = parameters2.length;
        List possibleContracts = Collections.singletonList(StandardMethodContract.trivialContract(paramCount, ContractReturnValue.returnAny()));
        for (int clauseIndex = 0; clauseIndex < contracts2.size(); ++clauseIndex) {
            StandardMethodContract contract = contracts2.get(clauseIndex);
            if (contract.getParameterCount() != paramCount) {
                String message2 = JavaAnalysisBundle.message((String)"inspection.contract.checker.parameter.count.mismatch", (Object[])new Object[]{paramCount, contract, contract.getParameterCount()});
                return StandardMethodContract.ParseException.forClause(message2, text2, clauseIndex);
            }
            for (int i = 0; i < parameters2.length; ++i) {
                PsiParameter parameter2;
                StandardMethodContract.ValueConstraint constraint = contract.getParameterConstraint(i);
                String message3 = ContractInspection.getConstraintProblem(method, contract, constraint, parameter2 = parameters2[i]);
                if (message3 == null) continue;
                return StandardMethodContract.ParseException.forConstraint(message3, text2, clauseIndex, i);
            }
            String problem = contract.getReturnValue().getMethodCompatibilityProblem(method);
            if (problem != null) {
                return StandardMethodContract.ParseException.forReturnValue(problem, text2, clauseIndex);
            }
            if (possibleContracts == null) continue;
            if (possibleContracts.isEmpty()) {
                return StandardMethodContract.ParseException.forClause(JavaAnalysisBundle.message((String)"inspection.contract.checker.unreachable.contract.clause", (Object[])new Object[]{contract}), text2, clauseIndex);
            }
            if (StreamEx.of(possibleContracts).allMatch(c -> c.intersect(contract) == null)) {
                return StandardMethodContract.ParseException.forClause(JavaAnalysisBundle.message((String)"inspection.contract.checker.contract.clause.never.satisfied", (Object[])new Object[]{contract}), text2, clauseIndex);
            }
            if ((possibleContracts = ((StreamEx)StreamEx.of(possibleContracts).flatMap(c -> c.excludeContract(contract)).limit(300L)).toList()).size() < 300) continue;
            possibleContracts = null;
        }
        return null;
    }

    @Nullable
    private static String getConstraintProblem(PsiMethod method, StandardMethodContract contract, StandardMethodContract.ValueConstraint constraint, PsiParameter parameter2) {
        PsiType type2 = parameter2.getType();
        switch (constraint) {
            case NULL_VALUE: {
                if (type2 instanceof PsiPrimitiveType) {
                    return JavaAnalysisBundle.message((String)"inspection.contract.checker.primitive.parameter.nullability", (Object[])new Object[]{parameter2.getName(), type2.getPresentableText(), constraint});
                }
                NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)method.getProject()).findEffectiveNullabilityInfo((PsiModifierListOwner)parameter2);
                if (info != null && info.getNullability() == Nullability.NOT_NULL) {
                    if (info.isInferred() && contract.getReturnValue().isFail()) {
                        return null;
                    }
                    return JavaAnalysisBundle.message((String)(info.isInferred() ? "inspection.contract.checker.inferred.notnull.parameter.null" : "inspection.contract.checker.notnull.parameter.null"), (Object[])new Object[]{parameter2.getName(), constraint});
                }
                return null;
            }
            case NOT_NULL_VALUE: {
                if (type2 instanceof PsiPrimitiveType) {
                    return JavaAnalysisBundle.message((String)"inspection.contract.checker.primitive.parameter.nullability", (Object[])new Object[]{parameter2.getName(), type2.getPresentableText(), constraint});
                }
                NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)method.getProject()).findEffectiveNullabilityInfo((PsiModifierListOwner)parameter2);
                if (info != null && info.getNullability() == Nullability.NOT_NULL) {
                    return JavaAnalysisBundle.message((String)(info.isInferred() ? "inspection.contract.checker.inferred.notnull.parameter.notnull" : "inspection.contract.checker.notnull.parameter.notnull"), (Object[])new Object[]{parameter2.getName(), constraint});
                }
                return null;
            }
            case TRUE_VALUE: 
            case FALSE_VALUE: {
                if (!PsiType.BOOLEAN.equals((Object)type2) && !type2.equalsToText("java.lang.Boolean")) {
                    return JavaAnalysisBundle.message((String)"inspection.contract.checker.boolean.condition.for.nonboolean.parameter", (Object[])new Object[]{parameter2.getName(), type2.getPresentableText()});
                }
                return null;
            }
        }
        return null;
    }
}

