/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.canBeFinal;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.canBeFinal.CanBeFinalAnnotator;
import com.intellij.codeInspection.canBeFinal.CanBeFinalHandler;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanBeFinalInspection
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance(CanBeFinalInspection.class);
    public boolean REPORT_CLASSES;
    public boolean REPORT_METHODS;
    public boolean REPORT_FIELDS = true;
    @NonNls
    public static final String SHORT_NAME = "CanBeFinal";

    public boolean isReportClasses() {
        return this.REPORT_CLASSES;
    }

    public boolean isReportMethods() {
        return this.REPORT_METHODS;
    }

    public boolean isReportFields() {
        return this.REPORT_FIELDS;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        return new CanBeFinalAnnotator(refManager);
    }

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        if (refEntity instanceof RefJavaElement) {
            RefJavaElement refElement = (RefJavaElement)refEntity;
            if (refElement instanceof RefParameter) {
                return null;
            }
            if (!refElement.isReferenced()) {
                return null;
            }
            if (refElement.isSyntheticJSP()) {
                return null;
            }
            if (refElement.isFinal()) {
                return null;
            }
            if (!((RefElementImpl)refElement).checkFlag(CanBeFinalAnnotator.CAN_BE_FINAL_MASK)) {
                return null;
            }
            PsiMember psiMember = (PsiMember)ObjectUtils.tryCast((Object)refElement.getPsiElement(), PsiMember.class);
            if (psiMember == null || !CanBeFinalHandler.allowToBeFinal(psiMember)) {
                return null;
            }
            PsiIdentifier psiIdentifier = null;
            if (refElement instanceof RefClass) {
                RefClass refClass = (RefClass)refElement;
                if (refClass.isInterface() || refClass.isAnonymous() || refClass.isAbstract()) {
                    return null;
                }
                if (!this.isReportClasses()) {
                    return null;
                }
                psiIdentifier = ((PsiClass)psiMember).getNameIdentifier();
            } else if (refElement instanceof RefMethod) {
                RefMethod refMethod = (RefMethod)refElement;
                RefClass ownerClass = refMethod.getOwnerClass();
                if (ownerClass == null || ownerClass.isFinal()) {
                    return null;
                }
                if (psiMember.hasModifierProperty("private")) {
                    return null;
                }
                if (!this.isReportMethods()) {
                    return null;
                }
                psiIdentifier = ((PsiMethod)psiMember).getNameIdentifier();
            } else if (refElement instanceof RefField) {
                if (!((RefField)refElement).isUsedForWriting()) {
                    return null;
                }
                if (!this.isReportFields()) {
                    return null;
                }
                psiIdentifier = ((PsiField)psiMember).getNameIdentifier();
            }
            if (psiIdentifier != null) {
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)psiIdentifier, JavaAnalysisBundle.message((String)"inspection.export.results.can.be.final.description", (Object[])new Object[0]), (LocalQuickFix)new AcceptSuggested(globalContext.getRefManager()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
            }
        }
        return null;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemsProcessor) {
        for (RefElement entryPoint : globalContext.getEntryPointsManager(manager).getEntryPoints(manager)) {
            problemsProcessor.ignoreElement((RefEntity)entryPoint);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (problemsProcessor.getDescriptions(refEntity) == null) {
                    return;
                }
                refEntity.accept((RefVisitor)new RefJavaVisitor(){

                    public void visitMethod(@NotNull RefMethod refMethod) {
                        if (!(refMethod.isStatic() || "private".equals(refMethod.getAccessModifier()) || refMethod instanceof RefImplicitConstructor)) {
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                                ((RefElementImpl)refMethod).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                                problemsProcessor.ignoreElement((RefEntity)refMethod);
                                return false;
                            });
                        }
                    }

                    public void visitClass(@NotNull RefClass refClass) {
                        if (!refClass.isAnonymous()) {
                            globalContext.enqueueDerivedClassesProcessor(refClass, inheritor -> {
                                ((RefClassImpl)refClass).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                                problemsProcessor.ignoreElement((RefEntity)refClass);
                                return false;
                            });
                        }
                    }

                    public void visitField(final @NotNull RefField refField) {
                        globalContext.enqueueFieldUsagesProcessor(refField, new GlobalJavaInspectionContext.UsagesProcessor(){

                            public boolean process(PsiReference psiReference) {
                                PsiElement expression2 = psiReference.getElement();
                                if (expression2 instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)expression2))) {
                                    ((RefFieldImpl)refField).setFlag(false, CanBeFinalAnnotator.CAN_BE_FINAL_MASK);
                                    problemsProcessor.ignoreElement((RefEntity)refField);
                                    return false;
                                }
                                return true;
                            }
                        });
                    }
                });
            }
        });
        return false;
    }

    @Nullable
    public QuickFix<ProblemDescriptor> getQuickFix(String hint) {
        return new AcceptSuggested(null);
    }

    @NotNull
    public String getGroupDisplayName() {
        return InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    private static String getQuickFixName() {
        return JavaAnalysisBundle.message((String)"inspection.can.be.final.accept.quickfix", (Object[])new Object[0]);
    }

    private static class AcceptSuggested
    implements LocalQuickFix {
        private final RefManager myManager;

        AcceptSuggested(RefManager manager) {
            this.myManager = manager;
        }

        @NotNull
        public String getFamilyName() {
            return CanBeFinalInspection.getQuickFixName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiModifierListOwner psiElement = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class);
            if (psiElement != null) {
                RefJavaElement refElement = (RefJavaElement)(this.myManager != null ? this.myManager.getReference((PsiElement)psiElement) : null);
                try {
                    if (psiElement instanceof PsiVariable) {
                        ((PsiVariable)psiElement).normalizeDeclaration();
                    }
                    PsiModifierList modifierList = psiElement.getModifierList();
                    LOG.assertTrue(modifierList != null);
                    modifierList.setModifierProperty("final", true);
                    modifierList.setModifierProperty("volatile", false);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                if (refElement != null) {
                    RefJavaUtil.getInstance().setIsFinal(refElement, true);
                }
            }
        }
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myReportClassesCheckbox;
        private final JCheckBox myReportMethodsCheckbox;
        private final JCheckBox myReportFieldsCheckbox;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.weighty = 0.0;
            gc.weightx = 1.0;
            gc.fill = 2;
            gc.anchor = 18;
            this.myReportClassesCheckbox = new JCheckBox(JavaAnalysisBundle.message((String)"inspection.can.be.final.option", (Object[])new Object[0]));
            this.myReportClassesCheckbox.setSelected(CanBeFinalInspection.this.REPORT_CLASSES);
            this.myReportClassesCheckbox.getModel().addItemListener(e -> {
                CanBeFinalInspection.this.REPORT_CLASSES = this.myReportClassesCheckbox.isSelected();
            });
            gc.gridy = 0;
            this.add((Component)this.myReportClassesCheckbox, gc);
            this.myReportMethodsCheckbox = new JCheckBox(JavaAnalysisBundle.message((String)"inspection.can.be.final.option1", (Object[])new Object[0]));
            this.myReportMethodsCheckbox.setSelected(CanBeFinalInspection.this.REPORT_METHODS);
            this.myReportMethodsCheckbox.getModel().addItemListener(e -> {
                CanBeFinalInspection.this.REPORT_METHODS = this.myReportMethodsCheckbox.isSelected();
            });
            ++gc.gridy;
            this.add((Component)this.myReportMethodsCheckbox, gc);
            this.myReportFieldsCheckbox = new JCheckBox(JavaAnalysisBundle.message((String)"inspection.can.be.final.option2", (Object[])new Object[0]));
            this.myReportFieldsCheckbox.setSelected(CanBeFinalInspection.this.REPORT_FIELDS);
            this.myReportFieldsCheckbox.getModel().addItemListener(e -> {
                CanBeFinalInspection.this.REPORT_FIELDS = this.myReportFieldsCheckbox.isSelected();
            });
            gc.weighty = 1.0;
            ++gc.gridy;
            this.add((Component)this.myReportFieldsCheckbox, gc);
        }
    }
}

