/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class Effects
implements Result {
    static final Set<EffectQuantum> TOP_EFFECTS = Collections.singleton(EffectQuantum.TopEffectQuantum);
    static final Effects VOLATILE_EFFECTS = new Effects(DataValue.UnknownDataValue2, Collections.singleton(EffectQuantum.TopEffectQuantum));
    @NotNull
    final DataValue returnValue;
    @NotNull
    final Set<EffectQuantum> effects;

    Effects(@NotNull DataValue returnValue, @NotNull Set<EffectQuantum> effects) {
        this.returnValue = returnValue;
        this.effects = effects;
    }

    Effects combine(Effects other) {
        if (this.equals(other)) {
            return this;
        }
        Set<EffectQuantum> newEffects = new HashSet<EffectQuantum>(this.effects);
        newEffects.addAll(other.effects);
        if (newEffects.contains(EffectQuantum.TopEffectQuantum)) {
            newEffects = TOP_EFFECTS;
        }
        DataValue newReturnValue = this.returnValue.equals(other.returnValue) ? this.returnValue : DataValue.UnknownDataValue1;
        return new Effects(newReturnValue, newEffects);
    }

    @Override
    public Stream<EKey> dependencies() {
        return Stream.concat(this.returnValue.dependencies(), this.effects.stream().flatMap(EffectQuantum::dependencies));
    }

    public boolean isTop() {
        return this.returnValue == DataValue.UnknownDataValue1 && this.effects.equals(TOP_EFFECTS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Effects that = (Effects)o;
        return this.returnValue.equals(that.returnValue) && this.effects.equals(that.effects);
    }

    public int hashCode() {
        return this.effects.hashCode() * 31 + this.returnValue.hashCode();
    }

    public String toString() {
        String effectsPresentation = this.effects.isEmpty() ? "Pure" : (this.effects.size() == 1 ? this.effects.iterator().next() : Integer.valueOf(this.effects.size()));
        return "Effects[" + effectsPresentation + "|" + this.returnValue + "]";
    }
}

