/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.MemberDescriptor;
import com.intellij.codeInspection.bytecodeAnalysis.MethodAnnotations;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytecodeAnalysisConverter {
    @Nullable
    public static EKey psiKey(@NotNull PsiMember psiMethod, @NotNull Direction direction) {
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass != null) {
            String sig;
            String className2 = BytecodeAnalysisConverter.descriptor(psiClass, 0, false);
            String name2 = psiMethod.getName();
            if (psiMethod instanceof PsiMethod) {
                sig = BytecodeAnalysisConverter.methodSignature((PsiMethod)psiMethod, psiClass);
                if (((PsiMethod)psiMethod).isConstructor()) {
                    name2 = "<init>";
                }
            } else if (psiMethod instanceof PsiField) {
                sig = BytecodeAnalysisConverter.descriptor(((PsiField)psiMethod).getType());
            } else {
                return null;
            }
            if (className2 != null && sig != null && name2 != null) {
                return new EKey((MemberDescriptor)new Member(className2, name2, sig), direction, true, false);
            }
        }
        return null;
    }

    @Nullable
    private static String methodSignature(@NotNull PsiMethod psiMethod, @NotNull PsiClass psiClass) {
        PsiClass outerClass;
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        if (psiMethod.isConstructor() && !psiClass.hasModifierProperty("static") && (outerClass = psiClass.getContainingClass()) != null) {
            String desc = BytecodeAnalysisConverter.descriptor(outerClass, 0, true);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        for (PsiClass parameter2 : psiMethod.getParameterList().getParameters()) {
            String desc = BytecodeAnalysisConverter.descriptor(parameter2.getType());
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        sb.append(')');
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null) {
            sb.append('V');
        } else {
            String desc = BytecodeAnalysisConverter.descriptor(returnType);
            if (desc == null) {
                return null;
            }
            sb.append(desc);
        }
        return sb.toString();
    }

    @Nullable
    private static String descriptor(@NotNull PsiClass psiClass, int dimensions, boolean full) {
        String className2;
        PsiFile containingFile = psiClass.getContainingFile();
        if (!(containingFile instanceof PsiClassOwner)) {
            ProjectBytecodeAnalysis.LOG.debug("containingFile was not resolved for " + psiClass.getQualifiedName());
            return null;
        }
        PsiClassOwner psiFile = (PsiClassOwner)containingFile;
        String packageName = psiFile.getPackageName();
        String qname = psiClass.getQualifiedName();
        if (qname == null) {
            return null;
        }
        if (packageName.length() > 0) {
            if (qname.length() < packageName.length() + 1 || !qname.startsWith(packageName)) {
                ProjectBytecodeAnalysis.LOG.error("Invalid qname/packageName; qname = " + qname + "; packageName = " + packageName + "; getClass = " + psiClass.getClass().getName());
                return null;
            }
            className2 = qname.substring(packageName.length() + 1).replace('.', '$');
        } else {
            className2 = qname.replace('.', '$');
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dimensions; ++i) {
            sb.append('[');
        }
        if (full) {
            sb.append('L');
        }
        if (packageName.length() > 0) {
            sb.append(packageName.replace('.', '/'));
            sb.append('/');
        }
        sb.append(className2);
        if (full) {
            sb.append(';');
        }
        return sb.toString();
    }

    @Nullable
    private static String descriptor(@NotNull PsiType psiType) {
        int dimensions = 0;
        if ((psiType = TypeConversionUtil.erasure((PsiType)psiType)) instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            psiType = arrayType.getDeepComponentType();
            dimensions = arrayType.getArrayDimensions();
        }
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass != null) {
                return BytecodeAnalysisConverter.descriptor(psiClass, dimensions, true);
            }
            ProjectBytecodeAnalysis.LOG.debug("resolve was null for " + psiType.getCanonicalText());
            return null;
        }
        if (psiType instanceof PsiPrimitiveType) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < dimensions; ++i) {
                sb.append('[');
            }
            if (PsiType.VOID.equals((Object)psiType)) {
                sb.append('V');
            } else if (PsiType.BOOLEAN.equals((Object)psiType)) {
                sb.append('Z');
            } else if (PsiType.CHAR.equals((Object)psiType)) {
                sb.append('C');
            } else if (PsiType.BYTE.equals((Object)psiType)) {
                sb.append('B');
            } else if (PsiType.SHORT.equals((Object)psiType)) {
                sb.append('S');
            } else if (PsiType.INT.equals((Object)psiType)) {
                sb.append('I');
            } else if (PsiType.FLOAT.equals((Object)psiType)) {
                sb.append('F');
            } else if (PsiType.LONG.equals((Object)psiType)) {
                sb.append('J');
            } else if (PsiType.DOUBLE.equals((Object)psiType)) {
                sb.append('D');
            }
            return sb.toString();
        }
        return null;
    }

    @NotNull
    public static ArrayList<EKey> mkInOutKeys(@NotNull PsiMethod psiMethod, @NotNull EKey primaryKey) {
        PsiParameter[] parameters2 = psiMethod.getParameterList().getParameters();
        ArrayList<EKey> keys = new ArrayList<EKey>(parameters2.length * 2 + 2);
        keys.add(primaryKey);
        for (int i = 0; i < parameters2.length; ++i) {
            if (!(parameters2[i].getType() instanceof PsiPrimitiveType)) {
                keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.NotNull)));
                keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.Null)));
                keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.NotNull)));
                keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.Null)));
                continue;
            }
            if (!PsiType.BOOLEAN.equals((Object)parameters2[i].getType())) continue;
            keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.True)));
            keys.add(primaryKey.withDirection(new Direction.InOut(i, Value.False)));
            keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.True)));
            keys.add(primaryKey.withDirection(new Direction.InThrow(i, Value.False)));
        }
        return keys;
    }

    public static void addEffectAnnotations(Map<EKey, Effects> puritySolutions, MethodAnnotations result, EKey methodKey, boolean constructor) {
        for (Map.Entry<EKey, Effects> entry : puritySolutions.entrySet()) {
            EKey key2 = entry.getKey().mkStable();
            EKey baseKey = key2.mkBase();
            if (!methodKey.equals(baseKey)) continue;
            result.returnValue = entry.getValue().returnValue;
            Set<EffectQuantum> effects = entry.getValue().effects;
            MutationSignature sig = MutationSignature.pure();
            for (EffectQuantum effect : effects) {
                if (effect.equals(EffectQuantum.ThisChangeQuantum)) {
                    if (constructor) continue;
                    sig = sig.alsoMutatesThis();
                    continue;
                }
                if (effect instanceof EffectQuantum.ParamChangeQuantum) {
                    int paramN = ((EffectQuantum.ParamChangeQuantum)effect).n;
                    sig = sig.alsoMutatesArg(paramN);
                    continue;
                }
                sig = MutationSignature.unknown();
                break;
            }
            result.mutates.put(methodKey, sig);
        }
    }
}

