/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.booleanIsAlwaysInverted;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.booleanIsAlwaysInverted.BooleanMethodIsAlwaysInvertedInspection;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanMethodIsAlwaysInvertedLocalInspection
extends AbstractBaseJavaLocalInspectionTool {
    private final BooleanMethodIsAlwaysInvertedInspection myGlobalTool;

    BooleanMethodIsAlwaysInvertedLocalInspection(BooleanMethodIsAlwaysInvertedInspection globalTool) {
        this.myGlobalTool = globalTool;
    }

    @NotNull
    public String getGroupDisplayName() {
        return this.myGlobalTool.getGroupDisplayName();
    }

    @NotNull
    public String getShortName() {
        return this.myGlobalTool.getShortName();
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiType returnType = method.getReturnType();
        if (!PsiType.BOOLEAN.equals((Object)returnType) || MethodUtils.hasSuper(method) || RefUtil.isImplicitRead((PsiElement)method)) {
            return null;
        }
        int[] usageCount = new int[]{0};
        if (!UnusedSymbolUtil.processUsages(manager.getProject(), method.getContainingFile(), (PsiMember)method, (ProgressIndicator)new EmptyProgressIndicator(), null, (Processor<? super UsageInfo>)((Processor)u -> {
            PsiElement element = u.getElement();
            if (!(element instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return false;
            }
            boolean isInverted = BooleanMethodIsAlwaysInvertedInspection.isInvertedMethodCall(methodCallExpression);
            if (isInverted) {
                usageCount[0] = usageCount[0] + 1;
                return true;
            }
            return false;
        }))) {
            return null;
        }
        if (usageCount[0] < 2) {
            return null;
        }
        return new ProblemDescriptor[]{this.myGlobalTool.createProblemDescriptor(manager, (PsiElement)method.getNameIdentifier(), isOnTheFly)};
    }
}

