/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallHandler;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyOptionalCallChainsInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher OPTIONAL_OR_ELSE = CallMatcher.instanceCall("java.util.Optional", "orElse").parameterCount(1);
    private static final CallMatcher OPTIONAL_GET = CallMatcher.instanceCall("java.util.Optional", "get").parameterCount(0);
    private static final CallMatcher OPTIONAL_OR_ELSE_GET = CallMatcher.instanceCall("java.util.Optional", "orElseGet").parameterCount(1);
    private static final CallMatcher OPTIONAL_MAP = CallMatcher.instanceCall("java.util.Optional", "map").parameterCount(1);
    private static final CallMatcher OPTIONAL_OF_NULLABLE = CallMatcher.staticCall("java.util.Optional", "ofNullable").parameterCount(1);
    private static final CallMatcher OPTIONAL_OF_OF_NULLABLE = CallMatcher.staticCall("java.util.Optional", "ofNullable", "of").parameterCount(1);
    private static final CallMatcher OPTIONAL_IS_PRESENT = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalInt", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalLong", "isPresent").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "isPresent").parameterCount(0));
    private static final CallMatcher OPTIONAL_IF_PRESENT = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "ifPresent").parameterCount(1), CallMatcher.exactInstanceCall("java.util.OptionalInt", "ifPresent").parameterCount(1), CallMatcher.exactInstanceCall("java.util.OptionalLong", "ifPresent").parameterCount(1), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "ifPresent").parameterCount(1));
    private static final CallMatcher OPTIONAL_IS_EMPTY = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.util.Optional", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalInt", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalLong", "isEmpty").parameterCount(0), CallMatcher.exactInstanceCall("java.util.OptionalDouble", "isEmpty").parameterCount(0));
    private static final CallMapper<OptionalSimplificationFix> ourMapper;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)holder.getFile());
        if (level.isLessThan(LanguageLevel.JDK_1_8)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new OptionalChainVisitor(level){

            @Override
            protected void handleSimplification(@NotNull PsiMethodCallExpression call, @NotNull OptionalSimplificationFix fix) {
                PsiElement element = call.getMethodExpression().getReferenceNameElement();
                holder.registerProblem((PsiElement)(element != null ? element : call), fix.getDescription(), new LocalQuickFix[]{fix});
            }
        };
    }

    @Nullable
    private static <T> OptionalSimplificationFix getFix(PsiMethodCallExpression call, ChainSimplificationCase<T> inspection) {
        T context = inspection.extractContext(call.getProject(), call);
        if (context == null) {
            return null;
        }
        String name2 = inspection.getName(context);
        String description = inspection.getDescription(context);
        return new OptionalSimplificationFix(inspection, name2, description);
    }

    private static <T> void handleSimplification(ChainSimplificationCase<T> inspection, Project project, PsiMethodCallExpression call) {
        if (!inspection.getMatcher().matches((PsiExpression)call)) {
            return;
        }
        T context = inspection.extractContext(project, call);
        if (context != null) {
            inspection.apply(project, call, context);
        }
    }

    @Nullable
    private static PsiLambdaExpression getLambda(PsiExpression initializer) {
        PsiMethodReferenceExpression methodRef;
        PsiLambdaExpression lambda2;
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer);
        if (expression2 instanceof PsiLambdaExpression) {
            return (PsiLambdaExpression)expression2;
        }
        if (expression2 instanceof PsiMethodReferenceExpression && (lambda2 = LambdaRefactoringUtil.createLambda(methodRef = (PsiMethodReferenceExpression)expression2, true)) != null) {
            LambdaUtil.specifyLambdaParameterTypes((PsiType)methodRef.getFunctionalInterfaceType(), (PsiLambdaExpression)lambda2);
            return lambda2;
        }
        return null;
    }

    private static PsiExpression getOrElseArgument(PsiMethodCallExpression call, OrElseType type2) {
        if (type2 == OrElseType.OrElse) {
            return call.getArgumentList().getExpressions()[0];
        }
        if (type2 == OrElseType.OrElseGet) {
            PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(call.getArgumentList().getExpressions()[0]);
            if (lambda2 == null || !lambda2.getParameterList().isEmpty()) {
                return null;
            }
            return LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
        }
        return null;
    }

    private static CallMatcher getMatcherByType(OrElseType type2) {
        if (type2 == OrElseType.OrElse) {
            return OPTIONAL_OR_ELSE;
        }
        if (type2 == OrElseType.OrElseGet) {
            return OPTIONAL_OR_ELSE_GET;
        }
        throw new IllegalStateException();
    }

    @Nullable
    private static PsiExpression extractConditionalDefaultValue(@NotNull PsiStatement statement, @NotNull PsiVariable optValue) {
        if (statement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            PsiExpression thenExpr = SimplifyOptionalCallChainsInspection.getReturnExpression(ifStatement.getThenBranch());
            PsiExpression elseExpr = SimplifyOptionalCallChainsInspection.getReturnExpression(ifStatement.getElseBranch());
            if (thenExpr == null || elseExpr == null) {
                return null;
            }
            return SimplifyOptionalCallChainsInspection.extractConditionalDefaultValue(thenExpr, elseExpr, condition2, optValue);
        }
        if (statement instanceof PsiReturnStatement) {
            PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
            PsiConditionalExpression ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)returnValue), PsiConditionalExpression.class);
            if (ternary == null) {
                return null;
            }
            PsiExpression thenExpression2 = ternary.getThenExpression();
            PsiExpression elseExpression2 = ternary.getElseExpression();
            if (thenExpression2 == null || elseExpression2 == null) {
                return null;
            }
            return SimplifyOptionalCallChainsInspection.extractConditionalDefaultValue(thenExpression2, elseExpression2, ternary.getCondition(), optValue);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiExpression getReturnExpression(@Nullable PsiStatement block) {
        if (block == null) {
            return null;
        }
        PsiStatement statement = ControlFlowUtils.stripBraces(block);
        PsiReturnStatement returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)statement, PsiReturnStatement.class);
        if (returnStatement == null) {
            return null;
        }
        return returnStatement.getReturnValue();
    }

    @Nullable
    private static PsiExpression extractConditionalDefaultValue(@NotNull PsiExpression thenExpr, @NotNull PsiExpression elseExpr, @NotNull PsiExpression condition2, @NotNull PsiVariable optValue) {
        PsiExpression defaultExpression;
        PsiVariable nullChecked = ExpressionUtils.getVariableFromNullComparison(condition2, true);
        boolean inverted = false;
        if (nullChecked == null) {
            nullChecked = ExpressionUtils.getVariableFromNullComparison(condition2, false);
            if (nullChecked == null) {
                return null;
            }
            inverted = true;
        }
        if (!nullChecked.equals(optValue) || !ExpressionUtils.isReferenceTo(inverted ? thenExpr : elseExpr, optValue)) {
            return null;
        }
        PsiExpression psiExpression = defaultExpression = inverted ? elseExpr : thenExpr;
        if (VariableAccessUtils.variableIsUsed(optValue, (PsiElement)defaultExpression)) {
            return null;
        }
        return defaultExpression;
    }

    static {
        List<ChainSimplificationCase> cases2 = Arrays.asList(new IfPresentFoldedCase(), new MapUnwrappingCase(), new OrElseNonNullCase(OrElseType.OrElse), new OrElseNonNullCase(OrElseType.OrElseGet), new FlipPresentOrEmptyCase(true), new FlipPresentOrEmptyCase(false), new OrElseReturnCase(OrElseType.OrElse), new OrElseReturnCase(OrElseType.OrElseGet), new RewrappingCase(RewrappingCase.Type.OptionalGet), new RewrappingCase(RewrappingCase.Type.OrElseNull), new MapOrElseCase(OrElseType.OrElseGet), new MapOrElseCase(OrElseType.OrElse));
        ourMapper = new CallMapper();
        for (ChainSimplificationCase theCase : cases2) {
            CallHandler<OptionalSimplificationFix> handler = CallHandler.of(theCase.getMatcher(), theCase);
            ourMapper.register(handler);
        }
    }

    private static class IfPresentFoldedCase
    implements ChainSimplificationCase<Context> {
        private IfPresentFoldedCase() {
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            return InspectionGadgetsBundle.message("fix.eliminate.folded.if.present.name", new Object[0]);
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            return InspectionGadgetsBundle.message("fix.eliminate.folded.if.present.description", new Object[0]);
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression outerIfPresentQualifier = call.getMethodExpression().getQualifierExpression();
            PsiMethodCallExpression qualifierCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)outerIfPresentQualifier, PsiMethodCallExpression.class);
            PsiLambdaExpression outerIfPresentArgument = (PsiLambdaExpression)ObjectUtils.tryCast((Object)call.getArgumentList().getExpressions()[0], PsiLambdaExpression.class);
            if (outerIfPresentArgument == null) {
                return null;
            }
            if (outerIfPresentArgument.getParameterList().getParametersCount() != 1) {
                return null;
            }
            PsiParameter outerParameter = outerIfPresentArgument.getParameterList().getParameters()[0];
            if (outerParameter == null) {
                return null;
            }
            String outerIfPresentParameterName = outerParameter.getName();
            PsiExpression outerIfPresentBodyExpr = LambdaUtil.extractSingleExpressionFromBody((PsiElement)outerIfPresentArgument.getBody());
            PsiMethodCallExpression outerIfPresentBody = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)outerIfPresentBodyExpr, PsiMethodCallExpression.class);
            if (!OPTIONAL_IF_PRESENT.test(outerIfPresentBody)) {
                return null;
            }
            PsiExpression innerIfPresentQualifier = outerIfPresentBody.getMethodExpression().getQualifierExpression();
            PsiExpression nonTrivialQualifier = ExpressionUtils.isReferenceTo(innerIfPresentQualifier, (PsiVariable)outerParameter) ? null : innerIfPresentQualifier;
            PsiExpression innerIfPresentArgument = outerIfPresentBody.getArgumentList().getExpressions()[0];
            if (ReferencesSearch.search((PsiElement)outerParameter, (SearchScope)new LocalSearchScope((PsiElement)innerIfPresentArgument)).findFirst() != null) {
                return null;
            }
            PsiMethodCallExpression mapBefore = null;
            if (OPTIONAL_MAP.test(qualifierCall) && IfPresentFoldedCase.isOptionalTypeParameter(qualifierCall.getType())) {
                mapBefore = qualifierCall;
            }
            return new Context(mapBefore, nonTrivialQualifier, outerIfPresentParameterName, innerIfPresentArgument);
        }

        private static boolean isOptionalTypeParameter(@Nullable PsiType type2) {
            PsiClassType classType = (PsiClassType)ObjectUtils.tryCast((Object)type2, PsiClassType.class);
            if (classType == null) {
                return false;
            }
            if (classType.getParameterCount() != 1) {
                return false;
            }
            PsiType typeParameter = classType.getParameters()[0];
            PsiClass parameterClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeParameter);
            if (parameterClass == null) {
                return false;
            }
            return "java.util.Optional".equals(parameterClass.getQualifiedName());
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiExpression lambdaBodyAfter;
            PsiMethodCallExpression mapBefore = context.myMapBefore;
            CommentTracker ct = new CommentTracker();
            StringBuilder sb = new StringBuilder();
            PsiExpression qualifer = call.getMethodExpression().getQualifierExpression();
            assert (qualifer != null);
            sb.append(ct.text((PsiElement)qualifer)).append(".");
            if (mapBefore != null) {
                PsiExpression mapArgument = mapBefore.getArgumentList().getExpressions()[0];
                sb.append("flatMap(").append(ct.text((PsiElement)mapArgument)).append(").");
            }
            if ((lambdaBodyAfter = context.myMapLambdaBodyAfter) != null) {
                sb.append("flatMap(").append(context.myOuterIfPresentVarName).append("->").append(ct.text((PsiElement)lambdaBodyAfter)).append(").");
            }
            sb.append("ifPresent(").append(ct.text((PsiElement)context.myInnerIfPresentArgument)).append(")");
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)call, sb.toString());
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            return OPTIONAL_IF_PRESENT;
        }

        static class Context {
            @Nullable
            PsiMethodCallExpression myMapBefore;
            @Nullable
            PsiExpression myMapLambdaBodyAfter;
            @NotNull
            String myOuterIfPresentVarName;
            @NotNull
            PsiExpression myInnerIfPresentArgument;

            Context(@Nullable PsiMethodCallExpression mapBefore, @Nullable PsiExpression mapLambdaBodyAfter, @NotNull String outerIfPresentVarName, @NotNull PsiExpression innerIfPresentArgument) {
                this.myMapBefore = mapBefore;
                this.myMapLambdaBodyAfter = mapLambdaBodyAfter;
                this.myOuterIfPresentVarName = outerIfPresentVarName;
                this.myInnerIfPresentArgument = innerIfPresentArgument;
            }
        }
    }

    private static class MapUnwrappingCase
    implements ChainSimplificationCase<Context> {
        private MapUnwrappingCase() {
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"map()", "flatMap()"});
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            return InspectionGadgetsBundle.message("fix.replace.map.with.flat.map.description", new Object[0]);
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(call.getArgumentList().getExpressions()[0]);
            if (lambda2 == null) {
                return null;
            }
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 1) {
                return null;
            }
            PsiParameter mapLambdaParameter = parameters2[0];
            PsiExpression argument = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            PsiMethodCallExpression insideLambdaCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)argument, PsiMethodCallExpression.class);
            if (insideLambdaCall == null) {
                return null;
            }
            PsiExpression optionalQualifier = insideLambdaCall.getMethodExpression().getQualifierExpression();
            if (optionalQualifier == null) {
                return null;
            }
            if (!OPTIONAL_OR_ELSE.test(insideLambdaCall)) {
                if (!OPTIONAL_GET.test(insideLambdaCall)) {
                    return null;
                }
                PsiExpression qualifier = insideLambdaCall.getMethodExpression().getQualifierExpression();
                if (!MapUnwrappingCase.isPresentOptional(qualifier)) {
                    return null;
                }
                return new Context(optionalQualifier, call, mapLambdaParameter);
            }
            if (!ExpressionUtils.isNullLiteral(insideLambdaCall.getArgumentList().getExpressions()[0])) {
                return null;
            }
            return new Context(optionalQualifier, call, mapLambdaParameter);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            CommentTracker ct = new CommentTracker();
            String text2 = ct.text((PsiElement)context.myMapLambdaParameter) + " ->" + ct.text((PsiElement)context.myOptionalExpression);
            PsiExpression qualifier = context.myMapCall.getMethodExpression().getQualifierExpression();
            String callReplacement = Objects.requireNonNull(qualifier).getText() + ".flatMap(" + text2 + ")";
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)context.myMapCall, callReplacement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            return OPTIONAL_MAP;
        }

        private static boolean isPresentOptional(PsiExpression optionalExpression) {
            return !SpecialField.OPTIONAL_VALUE.getFromQualifier(CommonDataflow.getDfType(optionalExpression)).isSuperType(DfTypes.NULL);
        }

        private static class Context {
            private final PsiExpression myOptionalExpression;
            private final PsiMethodCallExpression myMapCall;
            private final PsiParameter myMapLambdaParameter;

            private Context(PsiExpression expression2, PsiMethodCallExpression call, PsiParameter parameter2) {
                this.myOptionalExpression = expression2;
                this.myMapCall = call;
                this.myMapLambdaParameter = parameter2;
            }
        }
    }

    private static class OrElseNonNullCase
    implements ChainSimplificationCase<Context> {
        private final OrElseType myType;

        private OrElseNonNullCase(OrElseType type2) {
            this.myType = type2;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            return "Replace null check with ifPresent()";
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            return "Null check can be eliminated with 'ifPresent'";
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression orElseArgument = SimplifyOptionalCallChainsInspection.getOrElseArgument(call, this.myType);
            if (!ExpressionUtils.isNullLiteral(orElseArgument)) {
                return null;
            }
            PsiLocalVariable returnVar = (PsiLocalVariable)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiLocalVariable.class);
            if (returnVar == null) {
                return null;
            }
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)returnVar, PsiStatement.class, (boolean)true);
            if (statement == null) {
                return null;
            }
            PsiStatement nextStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)returnVar.getParent()), PsiStatement.class);
            if (nextStatement == null) {
                return null;
            }
            PsiExpression lambdaExpr = OrElseNonNullCase.extractMappingExpression(nextStatement, (PsiVariable)returnVar);
            if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)lambdaExpr)) {
                return null;
            }
            if (!ReferencesSearch.search((PsiElement)returnVar).allMatch(reference -> PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)reference.getElement(), (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)nextStatement, (PsiElement)reference.getElement(), (boolean)false))) {
                return null;
            }
            return new Context(lambdaExpr, nextStatement, statement, (PsiVariable)returnVar, call);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiExpression receiver2 = context.myOrElseCall.getMethodExpression().getQualifierExpression();
            if (receiver2 == null) {
                return;
            }
            String statementText = receiver2.getText() + ".ifPresent(" + LambdaUtil.createLambda((PsiVariable)context.myVariable, (PsiExpression)context.myAction) + ");";
            PsiStatement finalStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(statementText, (PsiElement)context.myStatement);
            PsiElement result = context.myStatement.replace((PsiElement)finalStatement);
            context.myConditionStatement.delete();
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            return SimplifyOptionalCallChainsInspection.getMatcherByType(this.myType);
        }

        @Nullable
        private static PsiExpression extractMappingExpression(@NotNull PsiStatement statement, @NotNull PsiVariable optValue) {
            PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
            if (ifStatement == null) {
                return null;
            }
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return null;
            }
            if (ExpressionUtils.getVariableFromNullComparison(condition2, false) != optValue) {
                return null;
            }
            PsiStatement thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)thenStatement, PsiExpressionStatement.class);
            if (expressionStatement == null) {
                return null;
            }
            return expressionStatement.getExpression();
        }

        private static class Context {
            @NotNull
            private final PsiExpression myAction;
            @NotNull
            private final PsiStatement myConditionStatement;
            @NotNull
            private final PsiStatement myStatement;
            @NotNull
            private final PsiVariable myVariable;
            @NotNull
            private final PsiMethodCallExpression myOrElseCall;

            private Context(@NotNull PsiExpression action, @NotNull PsiStatement conditionStatement, @NotNull PsiStatement statement, @NotNull PsiVariable variable, @NotNull PsiMethodCallExpression call) {
                this.myAction = action;
                this.myConditionStatement = conditionStatement;
                this.myStatement = statement;
                this.myVariable = variable;
                this.myOrElseCall = call;
            }
        }
    }

    private static class FlipPresentOrEmptyCase
    implements ChainSimplificationCase<Context> {
        private final boolean myIsPresent;

        private FlipPresentOrEmptyCase(boolean present) {
            this.myIsPresent = present;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{context.myReplacement + "()"});
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            return "'" + context.myReplacement + "()' can be used instead";
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            if (!BoolUtils.isNegated((PsiExpression)call)) {
                return null;
            }
            PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
            if (nameElement == null) {
                return null;
            }
            if (this.myIsPresent) {
                return new Context("isEmpty");
            }
            return new Context("isPresent");
        }

        @Override
        public boolean isAppropriateLanguageLevel(@NotNull LanguageLevel level) {
            return level.isAtLeast(LanguageLevel.JDK_11);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiPrefixExpression negation = (PsiPrefixExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiPrefixExpression.class);
            if (negation == null || BoolUtils.getNegated((PsiExpression)negation) != call) {
                return;
            }
            ExpressionUtils.bindCallTo(call, context.myReplacement);
            new CommentTracker().replaceAndRestoreComments((PsiElement)negation, (PsiElement)call);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            if (this.myIsPresent) {
                return OPTIONAL_IS_PRESENT;
            }
            return OPTIONAL_IS_EMPTY;
        }

        private static class Context {
            private final String myReplacement;

            private Context(String replacement) {
                this.myReplacement = replacement;
            }
        }
    }

    private static class OrElseReturnCase
    implements ChainSimplificationCase<Context> {
        private final OrElseType myType;

        private OrElseReturnCase(OrElseType type2) {
            this.myType = type2;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            String method = context.myIsSimple ? "orElse" : "orElseGet";
            return "Replace null check with " + method + "(" + PsiExpressionTrimRenderer.render((PsiExpression)context.myDefaultExpression) + ")";
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            return "Null check can be eliminated";
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression falseArg = SimplifyOptionalCallChainsInspection.getOrElseArgument(call, this.myType);
            if (!ExpressionUtils.isNullLiteral(falseArg)) {
                return null;
            }
            PsiLocalVariable returnVar = (PsiLocalVariable)PsiTreeUtil.getParentOfType((PsiElement)call, PsiLocalVariable.class, (boolean)true);
            if (returnVar == null) {
                return null;
            }
            PsiStatement nextStatement = (PsiStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)returnVar.getParent()), PsiStatement.class);
            if (nextStatement == null) {
                return null;
            }
            PsiExpression defaultValue = SimplifyOptionalCallChainsInspection.extractConditionalDefaultValue(nextStatement, (PsiVariable)returnVar);
            boolean isSimple = ExpressionUtils.isSafelyRecomputableExpression(defaultValue);
            if (defaultValue == null || !isSimple && !LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)defaultValue)) {
                return null;
            }
            PsiType type2 = defaultValue.getType();
            PsiType methodCallReturnValue = call.getMethodExpression().getType();
            if (type2 == null || methodCallReturnValue == null || !methodCallReturnValue.isAssignableFrom(type2)) {
                return null;
            }
            return new Context(call, defaultValue, nextStatement, isSimple);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiExpression receiver2 = context.myOrElseCall.getMethodExpression().getQualifierExpression();
            if (receiver2 == null) {
                return;
            }
            String methodWithArg = context.myIsSimple ? ".orElse(" + context.myDefaultExpression.getText() + ")" : ".orElseGet(()->" + context.myDefaultExpression.getText() + ")";
            String expressionText = receiver2.getText() + methodWithArg;
            PsiStatement finalStatement = JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("return " + expressionText + ";", (PsiElement)receiver2);
            PsiStatement current = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context.myOrElseCall, PsiStatement.class, (boolean)false);
            if (current == null) {
                return;
            }
            PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)current, (PsiElement)finalStatement);
            new CommentTracker().deleteAndRestoreComments((PsiElement)context.myNextStatement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            if (this.myType == OrElseType.OrElse) {
                return OPTIONAL_OR_ELSE;
            }
            return OPTIONAL_OR_ELSE_GET;
        }

        private static class Context {
            @NotNull
            private final PsiMethodCallExpression myOrElseCall;
            @NotNull
            private final PsiExpression myDefaultExpression;
            @NotNull
            private final PsiStatement myNextStatement;
            private final boolean myIsSimple;

            private Context(@NotNull PsiMethodCallExpression call, @NotNull PsiExpression defaultExpression, @NotNull PsiStatement nextStatement, boolean simple) {
                this.myOrElseCall = call;
                this.myDefaultExpression = defaultExpression;
                this.myNextStatement = nextStatement;
                this.myIsSimple = simple;
            }
        }
    }

    private static class RewrappingCase
    implements ChainSimplificationCase<Context> {
        private final CallMatcher myWrapper;
        private final Type myType;

        private RewrappingCase(Type type2) {
            this.myType = type2;
            this.myWrapper = this.myType == Type.OrElseNull ? OPTIONAL_OF_NULLABLE : OPTIONAL_OF_OF_NULLABLE;
        }

        @Override
        @NotNull
        public String getName(@NotNull Context context) {
            return "Unwrap";
        }

        @Override
        @NotNull
        public String getDescription(@NotNull Context context) {
            return "Unnecessary Optional rewrapping";
        }

        @Override
        @Nullable
        public Context extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            DfType dfType;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
            if (!(parent instanceof PsiExpressionList)) {
                return null;
            }
            PsiMethodCallExpression parentCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
            if (!this.myWrapper.test(parentCall)) {
                return null;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null || !EquivalenceChecker.getCanonicalPsiEquivalence().typesAreEquivalent(qualifier.getType(), parentCall.getType())) {
                return null;
            }
            String name2 = call.getMethodExpression().getReferenceName();
            if ("get".equals(name2) ? (dfType = SpecialField.OPTIONAL_VALUE.getFromQualifier(CommonDataflow.getDfType(qualifier))).isSuperType(DfTypes.NULL) : "orElse".equals(name2) && !ExpressionUtils.isNullLiteral(call.getArgumentList().getExpressions()[0])) {
                return null;
            }
            return new Context(qualifier, (PsiExpression)parentCall);
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull Context context) {
            PsiElement result = context.myCallToReplace.replace((PsiElement)context.myQualifier);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            if (this.myType == Type.OptionalGet) {
                return OPTIONAL_GET;
            }
            return OPTIONAL_OR_ELSE;
        }

        static enum Type {
            OrElseNull,
            OptionalGet;

        }

        private static class Context {
            private final PsiExpression myQualifier;
            private final PsiExpression myCallToReplace;

            private Context(PsiExpression qualifier, PsiExpression callToReplace) {
                this.myQualifier = qualifier;
                this.myCallToReplace = callToReplace;
            }
        }
    }

    private static abstract class BasicSimplificationInspection
    implements ChainSimplificationCase<StringReplacement> {
        private BasicSimplificationInspection() {
        }

        @Override
        @NotNull
        public String getName(@NotNull StringReplacement context) {
            return context.myMessage;
        }

        @Override
        @NotNull
        public String getDescription(@NotNull StringReplacement context) {
            return context.myDescription;
        }

        @Override
        public void apply(@NotNull Project project, @NotNull PsiMethodCallExpression call, @NotNull StringReplacement context) {
            PsiExpression replacementExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(context.myReplacement, (PsiElement)call);
            PsiElement result = call.replace((PsiElement)replacementExpression);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
        }

        protected static class StringReplacement {
            private final String myReplacement;
            private final String myMessage;
            private final String myDescription;

            StringReplacement(String replacement, String message2, String description) {
                this.myReplacement = replacement;
                this.myMessage = message2;
                this.myDescription = description;
            }
        }
    }

    static class OptionalSimplificationFix
    implements LocalQuickFix {
        @FileModifier.SafeFieldForPreview
        private final ChainSimplificationCase<?> myInspection;
        private final String myName;
        private final String myDescription;

        OptionalSimplificationFix(ChainSimplificationCase<?> inspection, String name2, String description) {
            this.myInspection = inspection;
            this.myName = name2;
            this.myDescription = description;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return this.myName;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiMethodCallExpression.class, (boolean)false);
            SimplifyOptionalCallChainsInspection.handleSimplification(this.myInspection, project, call);
        }

        String getDescription() {
            return this.myDescription;
        }
    }

    private static class MapOrElseCase
    extends BasicSimplificationInspection {
        private final OrElseType myType;

        private MapOrElseCase(OrElseType type2) {
            this.myType = type2;
        }

        @Override
        @Nullable
        public BasicSimplificationInspection.StringReplacement extractContext(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            PsiExpression falseArg = SimplifyOptionalCallChainsInspection.getOrElseArgument(call, this.myType);
            if (falseArg == null) {
                return null;
            }
            PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(call);
            if (!OPTIONAL_MAP.test(qualifierCall)) {
                return null;
            }
            PsiLambdaExpression lambda2 = SimplifyOptionalCallChainsInspection.getLambda(qualifierCall.getArgumentList().getExpressions()[0]);
            if (lambda2 == null) {
                return null;
            }
            PsiExpression trueArg = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda2.getBody());
            if (trueArg == null) {
                return null;
            }
            PsiParameter[] parameters2 = lambda2.getParameterList().getParameters();
            if (parameters2.length != 1) {
                return null;
            }
            PsiExpression qualifier = qualifierCall.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return null;
            }
            String opt = qualifier.getText();
            PsiParameter parameter2 = parameters2[0];
            boolean useOrElseGet = this.myType == OrElseType.OrElseGet;
            String proposed = OptionalRefactoringUtil.generateOptionalUnwrap(opt, (PsiVariable)parameter2, trueArg, falseArg, call.getType(), useOrElseGet);
            String canonicalOrElse = useOrElseGet && !ExpressionUtils.isSafelyRecomputableExpression(falseArg) ? ".orElseGet(() -> " + falseArg.getText() + ")" : ".orElse(" + falseArg.getText() + ")";
            String canonical = opt + ".map(" + LambdaUtil.createLambda((PsiVariable)parameter2, (PsiExpression)trueArg) + ")" + canonicalOrElse;
            if (proposed.length() < canonical.length()) {
                String displayCode;
                if (proposed.equals(opt)) {
                    displayCode = "";
                } else if (opt.length() > 10) {
                    opt = "(($))";
                    String template = OptionalRefactoringUtil.generateOptionalUnwrap(opt, (PsiVariable)parameter2, trueArg, falseArg, call.getType(), useOrElseGet);
                    displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createExpressionFromText(template, (PsiElement)call));
                    displayCode = displayCode.replaceFirst(Pattern.quote(opt), "..");
                } else {
                    displayCode = PsiExpressionTrimRenderer.render((PsiExpression)JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createExpressionFromText(proposed, (PsiElement)call));
                }
                String message2 = displayCode.isEmpty() ? "Remove redundant steps from optional chain" : "Simplify optional chain to '" + displayCode + "'";
                String description = "Optional chain can be simplified";
                return new BasicSimplificationInspection.StringReplacement(proposed, message2, description);
            }
            return null;
        }

        @Override
        @NotNull
        public CallMatcher getMatcher() {
            return SimplifyOptionalCallChainsInspection.getMatcherByType(this.myType);
        }
    }

    private static abstract class OptionalChainVisitor
    extends JavaElementVisitor {
        private final LanguageLevel myLevel;

        private OptionalChainVisitor(LanguageLevel level) {
            this.myLevel = level;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            Optional<OptionalSimplificationFix> fix = ourMapper.mapAll(expression2).filter(f -> ((OptionalSimplificationFix)f).myInspection.isAppropriateLanguageLevel(this.myLevel)).findAny();
            if (!fix.isPresent()) {
                return;
            }
            this.handleSimplification(expression2, fix.get());
        }

        protected abstract void handleSimplification(@NotNull PsiMethodCallExpression var1, @NotNull OptionalSimplificationFix var2);
    }

    private static interface ChainSimplificationCase<C>
    extends Function<PsiMethodCallExpression, OptionalSimplificationFix> {
        @Override
        default public OptionalSimplificationFix apply(PsiMethodCallExpression expression2) {
            return SimplifyOptionalCallChainsInspection.getFix(expression2, this);
        }

        @NotNull
        public String getName(@NotNull C var1);

        @NotNull
        public String getDescription(@NotNull C var1);

        @Nullable
        public C extractContext(@NotNull Project var1, @NotNull PsiMethodCallExpression var2);

        public void apply(@NotNull Project var1, @NotNull PsiMethodCallExpression var2, @NotNull C var3);

        default public boolean isAvailable(@NotNull Project project, @NotNull PsiMethodCallExpression call) {
            return this.extractContext(project, call) != null;
        }

        @NotNull
        public CallMatcher getMatcher();

        default public boolean isAppropriateLanguageLevel(@NotNull LanguageLevel level) {
            return true;
        }
    }

    private static enum OrElseType {
        OrElse,
        OrElseGet;

    }
}

