/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class RemoveInitializerFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(RemoveInitializerFix.class);

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"inspection.unused.assignment.remove.quickfix", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiInitializer = descriptor.getPsiElement();
        if (!(psiInitializer instanceof PsiExpression)) {
            return;
        }
        if (!(psiInitializer.getParent() instanceof PsiVariable)) {
            return;
        }
        PsiVariable variable = (PsiVariable)psiInitializer.getParent();
        RemoveInitializerFix.sideEffectAwareRemove(project, (PsiExpression)psiInitializer, psiInitializer, variable);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void sideEffectAwareRemove(Project project, PsiExpression psiInitializer, PsiElement elementToDelete, PsiVariable variable) {
        PsiTypeElement typeElement = variable.getTypeElement();
        RemoveInitializerFix.sideEffectAwareRemove(project, psiInitializer, elementToDelete, variable, (typeElement != null ? typeElement.getText() + " " + variable.getName() + ";<br>" : "") + PsiExpressionTrimRenderer.render((PsiExpression)psiInitializer));
    }

    public static boolean sideEffectAwareRemove(Project project, PsiExpression psiInitializer, PsiElement elementToDelete, PsiVariable variable, String afterText) {
        RemoveUnusedVariableUtil.RemoveMode res;
        if (!FileModificationService.getInstance().prepareFileForWrite(elementToDelete.getContainingFile())) {
            return false;
        }
        ArrayList sideEffects = new ArrayList();
        boolean hasSideEffects = RemoveUnusedVariableUtil.checkSideEffects(psiInitializer, variable, sideEffects);
        PsiElement declaration2 = variable.getParent();
        if (hasSideEffects) {
            hasSideEffects = PsiUtil.isStatement((PsiElement)psiInitializer);
            res = RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, variable, FileEditorManager.getInstance((Project)project).getSelectedTextEditor(), hasSideEffects, ((PsiElement)sideEffects.get(0)).getText(), afterText);
            if (res == RemoveUnusedVariableUtil.RemoveMode.CANCEL) {
                return false;
            }
        } else {
            res = RemoveUnusedVariableUtil.RemoveMode.DELETE_ALL;
        }
        WriteAction.run(() -> {
            if (res == RemoveUnusedVariableUtil.RemoveMode.DELETE_ALL) {
                elementToDelete.delete();
            } else if (res == RemoveUnusedVariableUtil.RemoveMode.MAKE_STATEMENT) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiStatement statementFromText = factory.createStatementFromText(psiInitializer.getText() + ";", null);
                PsiElement parent = elementToDelete.getParent();
                if (parent instanceof PsiExpressionStatement) {
                    parent.replace((PsiElement)statementFromText);
                } else {
                    elementToDelete.delete();
                    if (declaration2 instanceof PsiClass) {
                        PsiClassInitializer initializer = factory.createClassInitializer();
                        initializer = (PsiClassInitializer)declaration2.addAfter((PsiElement)initializer, (PsiElement)variable);
                        initializer.getBody().add((PsiElement)statementFromText);
                        return;
                    }
                    PsiElement grandParent = declaration2.getParent();
                    BlockUtils.addBefore((PsiStatement)(grandParent instanceof PsiForStatement ? grandParent : declaration2), statementFromText);
                }
            }
        });
        return true;
    }
}

