/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveInitializerFix;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoinDeclarationAndAssignmentJavaInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression assignmentExpression) {
                super.visitAssignmentExpression(assignmentExpression);
                this.visitLocation((PsiElement)assignmentExpression);
            }

            public void visitLocalVariable(PsiLocalVariable variable) {
                super.visitLocalVariable(variable);
                if (isOnTheFly && this.isInformationLevel((PsiElement)variable)) {
                    this.visitLocation((PsiElement)variable);
                }
            }

            public void visitLocation(@Nullable PsiElement location) {
                Context context = JoinDeclarationAndAssignmentJavaInspection.getContext(location);
                if (context != null) {
                    PsiLocalVariable variable = context.myVariable;
                    PsiAssignmentExpression assignment = context.myAssignment;
                    assert (location == variable || location == assignment) : "context location";
                    String message2 = JavaBundle.message((String)"inspection.join.declaration.and.assignment.message", (Object[])new Object[]{context.myName});
                    JoinDeclarationAndAssignmentFix fix = new JoinDeclarationAndAssignmentFix();
                    if (isOnTheFly && (context.myIsUpdate || this.isInformationLevel(location))) {
                        ProblemHighlightType highlightType = context.myIsUpdate ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                        holder.registerProblem(location, message2, highlightType, new LocalQuickFix[]{fix});
                    } else if (location == assignment && !context.myIsUpdate) {
                        holder.registerProblem((PsiElement)assignment.getLExpression(), message2, new LocalQuickFix[]{fix});
                    }
                }
            }

            private boolean isInformationLevel(@NotNull PsiElement element) {
                return InspectionProjectProfileManager.isInformationLevel((String)JoinDeclarationAndAssignmentJavaInspection.this.getShortName(), (PsiElement)element);
            }
        };
    }

    @Contract(value="null -> null")
    @Nullable
    private static Context getContext(@Nullable PsiElement element) {
        if (element != null) {
            if (!(element instanceof PsiAssignmentExpression) && !(element instanceof PsiLocalVariable)) {
                element = element.getParent();
            }
            if (element instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
                return JoinDeclarationAndAssignmentJavaInspection.getContext(JoinDeclarationAndAssignmentJavaInspection.findVariable(assignment), assignment);
            }
            if (element instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)element;
                return JoinDeclarationAndAssignmentJavaInspection.getContext(variable, JoinDeclarationAndAssignmentJavaInspection.findAssignment(variable));
            }
        }
        return null;
    }

    @Contract(value="null,_ -> null; _,null -> null")
    @Nullable
    private static Context getContext(@Nullable PsiLocalVariable variable, @Nullable PsiAssignmentExpression assignment) {
        if (variable != null && assignment != null) {
            String variableName2 = variable.getName();
            PsiExpression rExpression = assignment.getRExpression();
            if (rExpression != null) {
                PsiLocalVariable aVar = variable;
                while (aVar != null) {
                    if (VariableAccessUtils.variableIsUsed((PsiVariable)aVar, (PsiElement)rExpression)) {
                        return null;
                    }
                    aVar = (PsiLocalVariable)PsiTreeUtil.getNextSiblingOfType((PsiElement)aVar, PsiLocalVariable.class);
                }
                return new Context(variable, assignment, variableName2);
            }
        }
        return null;
    }

    @Nullable
    private static PsiLocalVariable findVariable(@NotNull PsiAssignmentExpression assignmentExpression) {
        PsiElement resolved;
        PsiReferenceExpression reference;
        PsiExpression lExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getLExpression());
        if (lExpression instanceof PsiReferenceExpression && !(reference = (PsiReferenceExpression)lExpression).isQualified() && (resolved = reference.resolve()) instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)resolved;
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)variable.getParent(), PsiDeclarationStatement.class);
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)assignmentExpression.getParent(), PsiExpressionStatement.class);
            if (declarationStatement != null && declarationStatement.getParent() instanceof PsiCodeBlock && expressionStatement != null && expressionStatement.getParent() == declarationStatement.getParent()) {
                return JoinDeclarationAndAssignmentJavaInspection.findOccurrence((PsiElement)expressionStatement, variable, PsiTreeUtil::skipWhitespacesAndCommentsBackward, (candidate, unused) -> candidate == declarationStatement ? variable : null);
            }
        }
        return null;
    }

    @Nullable
    private static PsiAssignmentExpression findAssignment(@NotNull PsiLocalVariable variable) {
        return JoinDeclarationAndAssignmentJavaInspection.findOccurrence(variable.getParent(), variable, PsiTreeUtil::skipWhitespacesAndCommentsForward, JoinDeclarationAndAssignmentJavaInspection::findAssignment);
    }

    @Nullable
    private static <T> T findOccurrence(@Nullable PsiElement start, @NotNull PsiLocalVariable variable, @NotNull Function<? super PsiElement, ? extends PsiElement> advance, @NotNull BiFunction<? super PsiElement, ? super PsiLocalVariable, ? extends T> search) {
        PsiElement candidate = advance.apply((PsiElement)start);
        T result = search.apply((PsiElement)candidate, (PsiLocalVariable)variable);
        if (result != null) {
            return result;
        }
        if (JoinDeclarationAndAssignmentJavaInspection.canRemoveDeclaration((PsiVariable)variable)) {
            while (candidate != null) {
                result = search.apply((PsiElement)candidate, (PsiLocalVariable)variable);
                if (result != null) {
                    return result;
                }
                if (VariableAccessUtils.variableIsUsed((PsiVariable)variable, candidate)) break;
                candidate = advance.apply((PsiElement)candidate);
            }
        }
        return null;
    }

    @Contract(value="null,_ -> null")
    @Nullable
    private static PsiAssignmentExpression findAssignment(@Nullable PsiElement candidate, @NotNull PsiVariable variable) {
        PsiAssignmentExpression assignmentExpression;
        PsiExpression expression2;
        if (candidate instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)candidate).getExpression()) instanceof PsiAssignmentExpression && ExpressionUtils.isReferenceTo((assignmentExpression = (PsiAssignmentExpression)expression2).getLExpression(), variable)) {
            return assignmentExpression;
        }
        return null;
    }

    @Nullable
    private static PsiAssignmentExpression findNextAssignment(@Nullable PsiElement element, @NotNull PsiVariable variable) {
        PsiElement candidate = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
        return JoinDeclarationAndAssignmentJavaInspection.findAssignment(candidate, variable);
    }

    private static boolean canRemoveDeclaration(@NotNull PsiVariable variable) {
        PsiExpression initializer = variable.getInitializer();
        return initializer == null || !SideEffectChecker.checkSideEffects(initializer, null);
    }

    private static class Context {
        @NotNull
        final PsiLocalVariable myVariable;
        @NotNull
        final PsiAssignmentExpression myAssignment;
        @NotNull
        final String myName;
        final boolean myIsUpdate;

        Context(@NotNull PsiLocalVariable variable, @NotNull PsiAssignmentExpression assignment, @NotNull String name2) {
            this.myAssignment = assignment;
            this.myVariable = variable;
            this.myName = name2;
            this.myIsUpdate = !JavaTokenType.EQ.equals(this.myAssignment.getOperationTokenType()) || JoinDeclarationAndAssignmentJavaInspection.findNextAssignment(this.myAssignment.getParent(), (PsiVariable)this.myVariable) != null;
        }
    }

    private static class JoinDeclarationAndAssignmentFix
    implements LocalQuickFix {
        private JoinDeclarationAndAssignmentFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return JavaBundle.message((String)"inspection.join.declaration.and.assignment.fix.family.name", (Object[])new Object[0]);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Context context = JoinDeclarationAndAssignmentJavaInspection.getContext(descriptor.getPsiElement());
            if (context != null) {
                String textAfter;
                PsiLocalVariable variable = context.myVariable;
                PsiAssignmentExpression assignmentExpression = context.myAssignment;
                PsiExpression initializer = variable.getInitializer();
                if (initializer != null && assignmentExpression.getOperationTokenType() == JavaTokenType.EQ && !RemoveInitializerFix.sideEffectAwareRemove(project, initializer, (PsiElement)initializer, (PsiVariable)variable, textAfter = PsiExpressionTrimRenderer.render((PsiExpression)initializer) + ";<br>" + variable.getTypeElement().getText() + ' ' + variable.getName())) {
                    return;
                }
                if (!FileModificationService.getInstance().prepareFileForWrite(assignmentExpression.getContainingFile())) {
                    return;
                }
                WriteAction.run(() -> DeclarationJoinLinesHandler.joinDeclarationAndAssignment(context.myVariable, context.myAssignment));
            }
        }
    }
}

