/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DefaultAnnotationParamInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitNameValuePair(PsiNameValuePair pair2) {
                PsiAnnotationMemberValue value2 = pair2.getValue();
                PsiReference reference = pair2.getReference();
                if (reference == null) {
                    return;
                }
                PsiElement element = reference.resolve();
                if (!(element instanceof PsiAnnotationMethod)) {
                    return;
                }
                PsiAnnotationMemberValue defaultValue = ((PsiAnnotationMethod)element).getDefaultValue();
                if (defaultValue == null) {
                    return;
                }
                if (AnnotationUtil.equal((PsiAnnotationMemberValue)value2, (PsiAnnotationMemberValue)defaultValue)) {
                    holder.registerProblem((PsiElement)value2, JavaBundle.message((String)"inspection.message.redundant.default.parameter.value.assignment", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{DefaultAnnotationParamInspection.createRemoveParameterFix()});
                }
            }
        };
    }

    @NotNull
    private static LocalQuickFix createRemoveParameterFix() {
        return new LocalQuickFix(){

            @Nls
            @NotNull
            public String getFamilyName() {
                return JavaBundle.message((String)"quickfix.family.remove.redundant.parameter", (Object[])new Object[0]);
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiElement parent = descriptor.getPsiElement().getParent();
                parent.delete();
            }
        };
    }
}

