/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import org.jetbrains.annotations.NotNull;

public class AddAssertStatementFix
implements LocalQuickFix {
    private final String myText;

    public AddAssertStatementFix(@NotNull String text2) {
        this.myText = text2;
    }

    @NotNull
    public String getName() {
        return JavaBundle.message((String)"inspection.assert.quickfix", (Object[])new Object[]{this.myText});
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiExpression element = (PsiExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)descriptor.getPsiElement(), (Class[])new Class[]{PsiExpression.class});
        if (element == null) {
            return;
        }
        CodeBlockSurrounder surrounder = CodeBlockSurrounder.forExpression(element);
        if (surrounder == null) {
            return;
        }
        CodeBlockSurrounder.SurroundResult result = surrounder.surround();
        element = result.getExpression();
        PsiStatement anchorElement = result.getAnchor();
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchorElement);
        if (prev instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn(prev) != null) {
            anchorElement = prev;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        String text2 = "assert " + this.myText + ";";
        PsiAssertStatement assertStatement = (PsiAssertStatement)factory.createStatementFromText(text2, (PsiElement)element);
        anchorElement.getParent().addBefore((PsiElement)assertStatement, (PsiElement)anchorElement);
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"inspection.quickfix.assert.family", (Object[])new Object[0]);
    }
}

