/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorMatchingSuperFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateClassDialog;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.java.JavaBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSubclassAction
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(CreateSubclassAction.class);
    private String myText = JavaBundle.message((String)"intention.implement.abstract.class.default.text", (Object[])new Object[0]);

    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.implement.abstract.class.family", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        TextRange elementTextRange;
        PsiElement lBrace;
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        PsiElement element = file.findElementAt(position);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass == null || psiClass.isAnnotationType() || psiClass.isEnum() || psiClass instanceof PsiAnonymousClass || psiClass.hasModifierProperty("final")) {
            return false;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiClass);
        if (virtualFile == null || ScratchUtil.isScratch((VirtualFile)virtualFile)) {
            return false;
        }
        if (!this.isSupportedLanguage(psiClass)) {
            return false;
        }
        PsiMethod[] constructors = psiClass.getConstructors();
        if (constructors.length > 0) {
            boolean hasNonPrivateConstructor = false;
            for (PsiMethod constructor : constructors) {
                if (constructor.hasModifierProperty("private")) continue;
                hasNonPrivateConstructor = true;
                break;
            }
            if (!hasNonPrivateConstructor) {
                return false;
            }
        }
        if ((lBrace = psiClass.getLBrace()) == null) {
            return false;
        }
        if (element.getTextOffset() >= lBrace.getTextOffset()) {
            return false;
        }
        TextRange declarationRange = HighlightNamesUtil.getClassDeclarationTextRange(psiClass);
        if (!declarationRange.contains(elementTextRange = element.getTextRange()) && (!(element instanceof PsiWhiteSpace) || declarationRange.getStartOffset() != elementTextRange.getEndOffset() && declarationRange.getEndOffset() != elementTextRange.getStartOffset())) {
            return false;
        }
        if (CreateSubclassAction.shouldCreateInnerClass(psiClass) && !CreateSubclassAction.canModify((PsiElement)file)) {
            return false;
        }
        this.myText = CreateSubclassAction.getTitle(psiClass);
        return true;
    }

    protected boolean isSupportedLanguage(PsiClass aClass) {
        return aClass.getLanguage() == JavaLanguage.INSTANCE;
    }

    protected static String getTitle(PsiClass psiClass) {
        return psiClass.isInterface() ? CodeInsightBundle.message((String)"intention.implement.abstract.class.interface.text", (Object[])new Object[0]) : (psiClass.hasModifierProperty("abstract") ? JavaBundle.message((String)"intention.implement.abstract.class.default.text", (Object[])new Object[0]) : CodeInsightBundle.message((String)"intention.implement.abstract.class.subclass.text", (Object[])new Object[0]));
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        LOG.assertTrue(psiClass != null);
        if (CreateSubclassAction.shouldCreateInnerClass(psiClass)) {
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            CreateSubclassAction.createInnerClass(psiClass);
            return;
        }
        this.createTopLevelClass(psiClass);
    }

    private static boolean shouldCreateInnerClass(PsiClass psiClass) {
        return psiClass.hasModifierProperty("private") && psiClass.getContainingClass() != null;
    }

    public static void createInnerClass(PsiClass aClass) {
        WriteCommandAction.writeCommandAction((Project)aClass.getProject()).withName(CreateSubclassAction.getTitle(aClass)).withGroupId(CreateSubclassAction.getTitle(aClass)).run(() -> {
            PsiClass containingClass = aClass.getContainingClass();
            LOG.assertTrue(containingClass != null);
            PsiTypeParameterList oldTypeParameterList = aClass.getTypeParameterList();
            PsiClass classFromText = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createClass(CreateSubclassAction.suggestTargetClassName(aClass));
            classFromText = (PsiClass)containingClass.addAfter((PsiElement)classFromText, (PsiElement)aClass);
            CreateSubclassAction.startTemplate(oldTypeParameterList, aClass.getProject(), aClass, classFromText, true);
        });
    }

    protected void createTopLevelClass(PsiClass psiClass) {
        CreateClassDialog dlg = CreateSubclassAction.chooseSubclassToCreate(psiClass);
        if (dlg != null) {
            CreateSubclassAction.createSubclass(psiClass, dlg.getTargetDirectory(), dlg.getClassName());
        }
    }

    @Nullable
    public static CreateClassDialog chooseSubclassToCreate(PsiClass psiClass) {
        return CreateSubclassAction.chooseSubclassToCreate(psiClass, CreateSubclassAction.suggestTargetClassName(psiClass));
    }

    @Nullable
    public static CreateClassDialog chooseSubclassToCreate(PsiClass psiClass, String targetClassName) {
        final PsiDirectory sourceDir = psiClass.getContainingFile().getContainingDirectory();
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)psiClass.getProject()).getFileIndex();
        PsiPackage aPackage = sourceDir != null ? JavaDirectoryService.getInstance().getPackage(sourceDir) : null;
        CreateClassDialog dialog = new CreateClassDialog(psiClass.getProject(), CreateSubclassAction.getTitle(psiClass), targetClassName, aPackage != null ? aPackage.getQualifiedName() : "", CreateClassKind.CLASS, true, ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)){

            @Override
            protected PsiDirectory getBaseDir(String packageName) {
                return sourceDir != null && fileIndex.getSourceRootForFile(sourceDir.getVirtualFile()) != null ? sourceDir : super.getBaseDir(packageName);
            }

            @Override
            protected boolean reportBaseInTestSelectionInSource() {
                return true;
            }
        };
        if (!dialog.showAndGet()) {
            return null;
        }
        PsiDirectory targetDirectory = dialog.getTargetDirectory();
        if (targetDirectory == null) {
            return null;
        }
        return dialog;
    }

    public static String suggestTargetClassName(PsiClass psiClass) {
        JavaCodeStyleSettings javaSettings = JavaCodeStyleSettings.getInstance(psiClass.getContainingFile());
        return javaSettings.SUBCLASS_NAME_PREFIX + psiClass.getName() + javaSettings.SUBCLASS_NAME_SUFFIX;
    }

    public static PsiClass createSubclass(PsiClass psiClass, PsiDirectory targetDirectory, String className2) {
        return CreateSubclassAction.createSubclass(psiClass, targetDirectory, className2, true);
    }

    public static PsiClass createSubclass(PsiClass psiClass, PsiDirectory targetDirectory, String className2, boolean showChooser) {
        Project project = psiClass.getProject();
        PsiClass[] targetClass = new PsiClass[1];
        WriteCommandAction.writeCommandAction((Project)project).withName(CreateSubclassAction.getTitle(psiClass)).withGroupId(CreateSubclassAction.getTitle(psiClass)).run(() -> {
            IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
            PsiTypeParameterList oldTypeParameterList = psiClass.getTypeParameterList();
            try {
                targetClass[0] = JavaDirectoryService.getInstance().createClass(targetDirectory, className2);
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)(JavaBundle.message((String)"intention.error.cannot.create.class.message", (Object[])new Object[]{className2}) + "\n" + e.getLocalizedMessage()), (String)JavaBundle.message((String)"intention.error.cannot.create.class.title", (Object[])new Object[0])));
                return;
            }
            CreateSubclassAction.startTemplate(oldTypeParameterList, project, psiClass, targetClass[0], false);
        });
        if (targetClass[0] == null) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !psiClass.hasTypeParameters()) {
            Editor editor = CodeInsightUtil.positionCursorAtLBrace(project, targetClass[0].getContainingFile(), targetClass[0]);
            if (editor == null) {
                return targetClass[0];
            }
            CreateSubclassAction.chooseAndImplement(psiClass, project, targetClass[0], editor, showChooser);
        }
        return targetClass[0];
    }

    private static void startTemplate(PsiTypeParameterList oldTypeParameterList, final Project project, final PsiClass psiClass, PsiClass targetClass, boolean includeClassName) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiJavaCodeReferenceElement ref = elementFactory.createClassReferenceElement(psiClass);
        try {
            ref = psiClass.isInterface() ? (PsiJavaCodeReferenceElement)targetClass.getImplementsList().add((PsiElement)ref) : (PsiJavaCodeReferenceElement)targetClass.getExtendsList().add((PsiElement)ref);
            if (psiClass.hasTypeParameters() || includeClassName) {
                TemplateBuilderImpl templateBuilder;
                final Editor editor = CodeInsightUtil.positionCursorAtLBrace(project, targetClass.getContainingFile(), targetClass);
                TemplateBuilderImpl templateBuilderImpl = templateBuilder = editor != null ? (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)targetClass) : null;
                if (includeClassName && templateBuilder != null) {
                    templateBuilder.replaceElement((PsiElement)targetClass.getNameIdentifier(), targetClass.getName());
                }
                if (oldTypeParameterList != null) {
                    for (PsiTypeParameter parameter2 : oldTypeParameterList.getTypeParameters()) {
                        PsiElement param = ref.getParameterList().add((PsiElement)elementFactory.createTypeElement((PsiType)elementFactory.createType((PsiClass)parameter2)));
                        if (templateBuilder == null) continue;
                        templateBuilder.replaceElement(param, param.getText());
                    }
                }
                CreateSubclassAction.replaceTypeParamsList(targetClass, oldTypeParameterList);
                if (templateBuilder != null) {
                    templateBuilder.setEndVariableBefore((PsiElement)ref);
                    Template template = templateBuilder.buildTemplate();
                    template.addEndVariable();
                    final PsiClassOwner containingFile = (PsiClassOwner)targetClass.getContainingFile();
                    final int idxInFile = ArrayUtil.find((Object[])containingFile.getClasses(), (Object)targetClass);
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                    TextRange textRange = targetClass.getTextRange();
                    final RangeMarker startClassOffset = editor.getDocument().createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
                    editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
                    CreateFromUsageBaseFix.startTemplate(editor, template, project, (TemplateEditingListener)new TemplateEditingAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void templateFinished(@NotNull Template template, boolean brokenOff) {
                            try {
                                PsiClass aTargetClass;
                                LOG.assertTrue(startClassOffset.isValid(), (Object)startClassOffset);
                                if (idxInFile >= 0) {
                                    PsiClass[] classes2 = containingFile.getClasses();
                                    LOG.assertTrue(idxInFile < classes2.length, (Object)("idx: " + idxInFile + "; len: " + classes2.length));
                                    aTargetClass = classes2[idxInFile];
                                } else {
                                    PsiElement psiElement = containingFile.findElementAt(startClassOffset.getStartOffset());
                                    aTargetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
                                    LOG.assertTrue(aTargetClass != null, (Object)psiElement);
                                }
                                if (!brokenOff) {
                                    CreateSubclassAction.chooseAndImplement(psiClass, project, aTargetClass, editor);
                                }
                            }
                            finally {
                                startClassOffset.dispose();
                            }
                        }
                    }, CreateSubclassAction.getTitle(psiClass));
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static PsiElement replaceTypeParamsList(PsiClass psiClass, PsiTypeParameterList oldTypeParameterList) {
        PsiTypeParameterList typeParameterList = psiClass.getTypeParameterList();
        assert (typeParameterList != null);
        return typeParameterList.replace((PsiElement)oldTypeParameterList);
    }

    protected static void chooseAndImplement(PsiClass psiClass, Project project, @NotNull PsiClass targetClass, Editor editor) {
        CreateSubclassAction.chooseAndImplement(psiClass, project, targetClass, editor, true);
    }

    protected static void chooseAndImplement(PsiClass psiClass, Project project, @NotNull PsiClass targetClass, Editor editor, boolean showChooser) {
        PsiMethod[] constructors;
        boolean hasNonTrivialConstructor = false;
        for (PsiMethod constructor : constructors = psiClass.getConstructors()) {
            if (constructor.getParameterList().isEmpty()) continue;
            hasNonTrivialConstructor = true;
            break;
        }
        if (hasNonTrivialConstructor) {
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)psiClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            ArrayList<PsiMethodMember> baseConstructors = new ArrayList<PsiMethodMember>();
            for (PsiMethod baseConstr : constructors) {
                if (!PsiUtil.isAccessible((Project)project, (PsiMember)baseConstr, (PsiElement)targetClass, (PsiClass)targetClass)) continue;
                baseConstructors.add(new PsiMethodMember(baseConstr, substitutor));
            }
            int offset = editor.getCaretModel().getOffset();
            CreateConstructorMatchingSuperFix.chooseConstructor2Delegate(project, editor, substitutor, baseConstructors, constructors, targetClass);
            editor.getCaretModel().moveToOffset(offset);
        }
        if (showChooser) {
            OverrideImplementUtil.chooseAndImplementMethods(project, editor, targetClass);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

