/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.impl.BaseColorIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertColorRepresentationIntentionAction
extends BaseColorIntentionAction {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiExpressionList newArguments;
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiNewExpression expression2 = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class, (boolean)false);
        if (expression2 == null) {
            return false;
        }
        PsiExpressionList arguments = expression2.getArgumentList();
        if (arguments == null) {
            return false;
        }
        PsiMethod constructor = expression2.resolveConstructor();
        if (constructor == null) {
            return false;
        }
        try {
            newArguments = ConvertColorRepresentationIntentionAction.createNewArguments(JavaPsiFacade.getElementFactory((Project)project), constructor.getParameterList().getParameters(), arguments.getExpressions());
        }
        catch (ConstantEvaluationOverflowException e) {
            return false;
        }
        if (newArguments == null) {
            return false;
        }
        this.setText(JavaBundle.message((String)"intention.convert.color.representation.text", (Object[])new Object[]{newArguments.getText()}));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiNewExpression expression2 = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class, (boolean)false);
        if (expression2 == null) {
            return;
        }
        PsiExpressionList arguments = expression2.getArgumentList();
        if (arguments == null) {
            return;
        }
        PsiMethod constructor = expression2.resolveConstructor();
        if (constructor == null) {
            return;
        }
        PsiExpressionList newArguments = ConvertColorRepresentationIntentionAction.createNewArguments(JavaPsiFacade.getElementFactory((Project)project), constructor.getParameterList().getParameters(), arguments.getExpressions());
        if (newArguments == null) {
            return;
        }
        arguments.replace((PsiElement)newArguments);
    }

    @Nullable
    private static PsiExpressionList createNewArguments(@NotNull PsiElementFactory factory, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments) {
        String[] newValues = ConvertColorRepresentationIntentionAction.createArguments(parameters2, arguments);
        if (newValues == null) {
            return null;
        }
        PsiExpressionList result = ((PsiNewExpression)factory.createExpressionFromText("new Object()", (PsiElement)parameters2[0])).getArgumentList();
        if (result == null) {
            return null;
        }
        for (String value2 : newValues) {
            result.add((PsiElement)factory.createExpressionFromText(value2, (PsiElement)parameters2[0]));
        }
        return result;
    }

    private static String @Nullable [] createArguments(PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments) {
        if (parameters2.length != arguments.length) {
            return null;
        }
        switch (parameters2.length) {
            default: {
                return null;
            }
            case 1: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0]);
            }
            case 2: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1]);
            }
            case 3: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1], arguments[2]);
            }
            case 4: 
        }
        return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1], arguments[2], arguments[3]);
    }

    private static String @Nullable [] createArguments(@NotNull PsiExpression rgbExpression) {
        return ConvertColorRepresentationIntentionAction.createArguments(rgbExpression, false);
    }

    private static String @Nullable [] createArguments(@NotNull PsiExpression rgbExpression, @NotNull PsiExpression hasAlphaExpression) {
        Boolean hasAlpha = ConvertColorRepresentationIntentionAction.computeBoolean(hasAlphaExpression);
        if (hasAlpha == null) {
            return null;
        }
        return ConvertColorRepresentationIntentionAction.createArguments(rgbExpression, hasAlpha);
    }

    private static String @Nullable [] createArguments(@NotNull PsiExpression rExpression, @NotNull PsiExpression gExpression, @NotNull PsiExpression bExpression) {
        String[] stringArray;
        Integer value2 = ConvertColorRepresentationIntentionAction.createInt(ConvertColorRepresentationIntentionAction.computeInteger(rExpression), ConvertColorRepresentationIntentionAction.computeInteger(gExpression), ConvertColorRepresentationIntentionAction.computeInteger(bExpression));
        if (value2 != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "0x" + Integer.toHexString(value2);
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private static String @Nullable [] createArguments(@NotNull PsiExpression rExpression, @NotNull PsiExpression gExpression, @NotNull PsiExpression bExpression, @NotNull PsiExpression aExpression) {
        Integer value2 = ConvertColorRepresentationIntentionAction.createInt(ConvertColorRepresentationIntentionAction.computeInteger(aExpression), ConvertColorRepresentationIntentionAction.computeInteger(rExpression), ConvertColorRepresentationIntentionAction.computeInteger(gExpression), ConvertColorRepresentationIntentionAction.computeInteger(bExpression));
        if (value2 == null) {
            return null;
        }
        return new String[]{"0x" + Integer.toHexString(value2), "true"};
    }

    private static String @Nullable [] createArguments(@NotNull PsiExpression rgbExpression, boolean hasAlpha) {
        String[] result;
        Integer argb = ConvertColorRepresentationIntentionAction.computeInteger(rgbExpression);
        if (argb == null) {
            return null;
        }
        if (hasAlpha) {
            result = new String[4];
            result[3] = String.valueOf(argb >> 24 & 0xFF);
        } else {
            result = new String[3];
        }
        for (int i = 0; i < 3; ++i) {
            result[2 - i] = String.valueOf(argb >> i * 8 & 0xFF);
        }
        return result;
    }

    @Nullable
    private static Integer createInt(Integer ... ints) {
        int result = 0;
        for (Integer i : ints) {
            if (i == null) {
                return null;
            }
            result = result << 8 | i & 0xFF;
        }
        return result;
    }

    @Nullable
    public static Integer computeInteger(@NotNull PsiExpression expr2) {
        Object result = ConvertColorRepresentationIntentionAction.compute(expr2);
        return result instanceof Integer ? (Integer)result : null;
    }

    @Nullable
    public static Boolean computeBoolean(@NotNull PsiExpression expr2) {
        Object result = ConvertColorRepresentationIntentionAction.compute(expr2);
        return result instanceof Boolean ? (Boolean)result : null;
    }

    @Nullable
    private static Object compute(@NotNull PsiExpression expr2) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expr2, true);
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.convert.color.representation.family", (Object[])new Object[0]);
    }
}

