/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

public class JavaWithIfElseSurrounder
extends JavaStatementsSurrounder {
    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.ifelse.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, false)).length == 0) {
            return null;
        }
        String text2 = "if(a){\n}else{\n}";
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(text2, null);
        ifStatement = (PsiIfStatement)codeStyleManager.reformat((PsiElement)ifStatement);
        PsiStatement thenBranch = (ifStatement = (PsiIfStatement)this.addAfter((PsiStatement)ifStatement, container, statements)).getThenBranch();
        if (!(thenBranch instanceof PsiBlockStatement)) {
            return null;
        }
        PsiCodeBlock thenBlock = ((PsiBlockStatement)thenBranch).getCodeBlock();
        SurroundWithUtil.indentCommentIfNecessary(thenBlock, statements);
        JavaWithIfElseSurrounder.addRangeWithinContainer(thenBlock, container, statements, true);
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        ifStatement = (PsiIfStatement)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)ifStatement);
        PsiExpression condition2 = ifStatement.getCondition();
        if (condition2 == null) {
            return null;
        }
        TextRange range = condition2.getTextRange();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        return new TextRange(range.getStartOffset(), range.getStartOffset());
    }
}

