/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class JavaStatementsSurrounder
implements Surrounder {
    JavaStatementsSurrounder() {
    }

    public boolean isApplicable(PsiElement @NotNull [] elements) {
        return ContainerUtil.find((Object[])elements, PsiSwitchLabelStatementBase.class::isInstance) == null;
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements) throws IncorrectOperationException {
        PsiElement container = elements[0].getParent();
        if (container == null) {
            return null;
        }
        return this.surroundStatements(project, editor, container, elements);
    }

    @Nullable
    protected abstract TextRange surroundStatements(Project var1, Editor var2, PsiElement var3, PsiElement[] var4) throws IncorrectOperationException;

    @NotNull
    protected PsiStatement addAfter(PsiStatement statement, PsiElement container, PsiElement[] statements) {
        if (container instanceof PsiSwitchLabeledRuleStatement && !(statement instanceof PsiBlockStatement)) {
            Project project = container.getProject();
            PsiManager manager = PsiManager.getInstance((Project)project);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            PsiBlockStatement blockStatement = (PsiBlockStatement)factory.createStatementFromText("{\n}", null);
            blockStatement = (PsiBlockStatement)codeStyleManager.reformat((PsiElement)blockStatement);
            blockStatement = (PsiBlockStatement)container.addAfter((PsiElement)blockStatement, statements[statements.length - 1]);
            return (PsiStatement)blockStatement.getCodeBlock().add((PsiElement)statement);
        }
        return (PsiStatement)container.addAfter((PsiElement)statement, statements[statements.length - 1]);
    }

    protected static void addRangeWithinContainer(PsiCodeBlock codeBlock, PsiElement container, PsiElement[] statements, boolean canBreak) {
        if (container instanceof PsiSwitchLabeledRuleStatement && statements.length == 1) {
            PsiElement statement = statements[0];
            if (statement instanceof PsiExpressionStatement && canBreak) {
                JavaStatementsSurrounder.addYield(codeBlock, (PsiExpressionStatement)statement);
                return;
            }
            if (statement instanceof PsiBlockStatement) {
                JavaStatementsSurrounder.addCodeBlockContents(codeBlock, (PsiBlockStatement)statement);
                return;
            }
        }
        codeBlock.addRange(statements[0], statements[statements.length - 1]);
    }

    private static void addYield(PsiCodeBlock codeBlock, PsiExpressionStatement statement) {
        PsiExpressionStatement wrappedStatement = (PsiExpressionStatement)codeBlock.add((PsiElement)statement);
        CommentTracker tracker = new CommentTracker();
        tracker.markUnchanged(wrappedStatement.getExpression());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)codeBlock.getProject());
        PsiYieldStatement yieldStatement = (PsiYieldStatement)factory.createStatementFromText("yield 0;", (PsiElement)statement);
        yieldStatement = (PsiYieldStatement)tracker.replaceAndRestoreComments((PsiElement)wrappedStatement, (PsiElement)yieldStatement);
        PsiExpression yieldExpression = yieldStatement.getExpression();
        assert (yieldExpression != null) : DebugUtil.psiToString((PsiElement)yieldStatement, (boolean)false);
        yieldExpression.replace((PsiElement)statement.getExpression());
    }

    protected static void addCodeBlockContents(PsiCodeBlock codeBlock, PsiBlockStatement statement) {
        PsiBlockStatement tempStatement = (PsiBlockStatement)codeBlock.add((PsiElement)statement);
        PsiCodeBlock tempBlock = tempStatement.getCodeBlock();
        PsiJavaToken lBrace = tempBlock.getLBrace();
        PsiJavaToken rBrace = tempBlock.getRBrace();
        if (lBrace != null && rBrace != null) {
            CommentTracker tracker = new CommentTracker();
            for (PsiElement element = lBrace.getNextSibling(); element != null && element != rBrace; element = element.getNextSibling()) {
                tracker.markUnchanged(element);
                codeBlock.addBefore(element, (PsiElement)tempStatement);
            }
            tracker.deleteAndRestoreComments((PsiElement)tempStatement);
        }
    }
}

