/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommentFoldingUtil {
    @Nullable
    public static FoldingDescriptor getCommentDescriptor(@NotNull PsiComment comment, @NotNull Document document, @NotNull Set<? super PsiElement> processedComments, @NotNull Predicate<? super PsiElement> isCustomRegionFunc, boolean isCollapse) {
        if (!processedComments.add((PsiElement)comment)) {
            return null;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(comment.getLanguage());
        if (!(commenter instanceof CodeDocumentationAwareCommenter)) {
            return null;
        }
        CodeDocumentationAwareCommenter docCommenter = (CodeDocumentationAwareCommenter)commenter;
        IElementType commentType = comment.getTokenType();
        TextRange commentRange = CommentFoldingUtil.getCommentRange(comment, processedComments, isCustomRegionFunc, docCommenter);
        if (commentRange == null) {
            return null;
        }
        String placeholder = CommentFoldingUtil.getCommentPlaceholder(document, commentType, commentRange);
        if (placeholder == null) {
            return null;
        }
        return new FoldingDescriptor(comment.getNode(), commentRange, null, placeholder, Boolean.valueOf(isCollapse), Collections.emptySet());
    }

    @Nullable
    private static TextRange getCommentRange(@NotNull PsiComment comment, @NotNull Set<? super PsiElement> processedComments, @NotNull Predicate<? super PsiElement> isCustomRegionFunc, @NotNull CodeDocumentationAwareCommenter docCommenter) {
        IElementType commentType = comment.getTokenType();
        if (commentType == docCommenter.getDocumentationCommentTokenType() || commentType == docCommenter.getBlockCommentTokenType()) {
            return comment.getTextRange();
        }
        if (commentType != docCommenter.getLineCommentTokenType()) {
            return null;
        }
        return CommentFoldingUtil.getOneLineCommentRange(comment, processedComments, isCustomRegionFunc, docCommenter);
    }

    @Nullable
    private static TextRange getOneLineCommentRange(@NotNull PsiComment startComment, @NotNull Set<? super PsiElement> processedComments, @NotNull Predicate<? super PsiElement> isCustomRegionFunc, @NotNull CodeDocumentationAwareCommenter docCommenter) {
        ASTNode node;
        if (isCustomRegionFunc.test((PsiElement)startComment)) {
            return null;
        }
        PsiElement end = null;
        for (PsiElement current = startComment.getNextSibling(); current != null && (node = current.getNode()) != null; current = current.getNextSibling()) {
            IElementType elementType = node.getElementType();
            if (elementType == docCommenter.getLineCommentTokenType() && !isCustomRegionFunc.test((PsiElement)current) && !processedComments.contains(current)) {
                end = current;
                processedComments.add((PsiElement)current);
                continue;
            }
            if (elementType != TokenType.WHITE_SPACE) break;
        }
        if (end == null) {
            return null;
        }
        return new TextRange(startComment.getTextRange().getStartOffset(), end.getTextRange().getEndOffset());
    }

    @Nullable
    public static String getCommentPlaceholder(@NotNull Document document, @NotNull IElementType commentType, @NotNull TextRange commentRange) {
        return CommentFoldingUtil.getCommentPlaceholder(document, commentType, commentRange, "...");
    }

    @Nullable
    public static String getCommentPlaceholder(@NotNull Document document, @NotNull IElementType commentType, @NotNull TextRange commentRange, @NotNull String replacement) {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(commentType.getLanguage());
        if (!(commenter instanceof CodeDocumentationAwareCommenter)) {
            return null;
        }
        CodeDocumentationAwareCommenter docCommenter = (CodeDocumentationAwareCommenter)commenter;
        String placeholder = commentType == docCommenter.getLineCommentTokenType() ? CommentFoldingUtil.getLineCommentPlaceholderText(commenter, replacement) : (commentType == docCommenter.getBlockCommentTokenType() ? CommentFoldingUtil.getMultilineCommentPlaceholderText(commenter, replacement) : (commentType == docCommenter.getDocumentationCommentTokenType() ? CommentFoldingUtil.getDocCommentPlaceholderText(document, docCommenter, commentRange, replacement) : null));
        return placeholder;
    }

    @Nullable
    private static String getDocCommentPlaceholderText(@NotNull Document document, @NotNull CodeDocumentationAwareCommenter commenter, @NotNull TextRange commentRange, @NotNull String replacement) {
        String fullText;
        String prefix = commenter.getDocumentationCommentPrefix();
        String suffix = commenter.getDocumentationCommentSuffix();
        String linePrefix = commenter.getDocumentationCommentLinePrefix();
        if (prefix == null || suffix == null || linePrefix == null) {
            return null;
        }
        String header = CommentFoldingUtil.getCommentHeader(document, suffix, prefix, linePrefix, commentRange);
        if (StringUtil.equalsIgnoreWhitespaces((CharSequence)header, (CharSequence)(fullText = CommentFoldingUtil.getCommentText(document, suffix, prefix, linePrefix, commentRange)))) {
            replacement = "";
        }
        return CommentFoldingUtil.getCommentPlaceholder(prefix, suffix, header, replacement);
    }

    @Nullable
    private static String getMultilineCommentPlaceholderText(@NotNull Commenter commenter, @NotNull String replacement) {
        String prefix = commenter.getBlockCommentPrefix();
        String suffix = commenter.getBlockCommentSuffix();
        if (prefix == null || suffix == null) {
            return null;
        }
        return CommentFoldingUtil.getCommentPlaceholder(prefix, suffix, null, replacement);
    }

    @Nullable
    private static String getLineCommentPlaceholderText(@NotNull Commenter commenter, @NotNull String replacement) {
        String prefix = commenter.getLineCommentPrefix();
        if (prefix == null) {
            return null;
        }
        return CommentFoldingUtil.getCommentPlaceholder(prefix, null, null, replacement);
    }

    @NotNull
    public static String getCommentPlaceholder(@NotNull String prefix, @Nullable String suffix, @Nullable String text2, @NotNull String replacement) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (text2 != null && text2.length() > 0) {
            sb.append(text2);
            sb.append(" ");
        }
        sb.append(replacement);
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    @NotNull
    public static String getCommentHeader(@NotNull Document document, @NotNull String commentSuffix, @NotNull String commentPrefix, @NotNull String linePrefix, @NotNull TextRange commentRange) {
        int nFirstCommentLine = document.getLineNumber(commentRange.getStartOffset());
        for (int i = 0; i <= 1; ++i) {
            String line = CommentFoldingUtil.getCommentLine(i, nFirstCommentLine, document, commentSuffix, commentPrefix, linePrefix, commentRange);
            if (line == null) {
                return "";
            }
            if (!line.chars().anyMatch(c -> !StringUtil.isWhiteSpace((char)((char)c)))) continue;
            return line;
        }
        return "";
    }

    @NotNull
    public static String getCommentText(@NotNull Document document, @NotNull String commentSuffix, @NotNull String commentPrefix, @NotNull String linePrefix, @NotNull TextRange commentRange) {
        String line;
        StringBuilder sb = new StringBuilder();
        int nFirstCommentLine = document.getLineNumber(commentRange.getStartOffset());
        int i = 0;
        while ((line = CommentFoldingUtil.getCommentLine(i, nFirstCommentLine, document, commentSuffix, commentPrefix, linePrefix, commentRange)) != null) {
            sb.append(line);
            ++i;
        }
        return sb.toString();
    }

    @NotNull
    @Contract(value="_, _ -> new")
    private static TextRange getLineRange(@NotNull Document document, int nLine) {
        int startOffset = document.getLineStartOffset(nLine);
        int endOffset = document.getLineEndOffset(nLine);
        return new TextRange(startOffset, endOffset);
    }

    @Nullable
    private static String getCommentLine(int lineOffset, int nFirstCommentLine, @NotNull Document document, @NotNull String commentSuffix, @NotNull String commentPrefix, @NotNull String linePrefix, @NotNull TextRange commentRange) {
        if (lineOffset == 0) {
            TextRange lineRange = CommentFoldingUtil.getLineRange(document, nFirstCommentLine);
            return CommentFoldingUtil.getCommentLine(document, lineRange, commentRange, commentPrefix, commentSuffix);
        }
        int nCommentLine = nFirstCommentLine + lineOffset;
        if (nCommentLine >= document.getLineCount()) {
            return null;
        }
        TextRange lineRange = CommentFoldingUtil.getLineRange(document, nCommentLine);
        if (lineRange.getEndOffset() > commentRange.getEndOffset()) {
            return null;
        }
        return CommentFoldingUtil.getCommentLine(document, lineRange, commentRange, linePrefix, commentSuffix);
    }

    @NotNull
    private static String getCommentLine(@NotNull Document document, @NotNull TextRange lineRange, @NotNull TextRange commentRange, @NotNull String prefix, @NotNull String suffix) {
        int prefixIdx;
        int endOffset;
        int startOffset = Math.max(lineRange.getStartOffset(), commentRange.getStartOffset());
        String commentPart = document.getText(new TextRange(startOffset, endOffset = Math.min(lineRange.getEndOffset(), commentRange.getEndOffset())));
        int suffixIdx = commentPart.indexOf(suffix);
        if (suffixIdx != -1) {
            commentPart = commentPart.substring(0, suffixIdx).trim();
        }
        if ((prefixIdx = commentPart.indexOf(prefix)) != -1) {
            commentPart = commentPart.substring(prefixIdx + prefix.length());
        }
        return commentPart;
    }
}

