/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInsight.folding.impl.JavaFoldingBuilderBase;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClosureFolding {
    @NotNull
    private final PsiAnonymousClass myAnonymousClass;
    @NotNull
    private final PsiNewExpression myNewExpression;
    @Nullable
    private final PsiClass myBaseClass;
    @NotNull
    private final JavaFoldingBuilderBase myBuilder;
    @NotNull
    private final PsiMethod myMethod;
    @NotNull
    final PsiCodeBlock methodBody;
    private final boolean myQuick;

    private ClosureFolding(@NotNull PsiAnonymousClass anonymousClass, @NotNull PsiNewExpression newExpression, boolean quick, @Nullable PsiClass baseClass, @NotNull JavaFoldingBuilderBase builder, @NotNull PsiMethod method, @NotNull PsiCodeBlock methodBody2) {
        this.myAnonymousClass = anonymousClass;
        this.myNewExpression = newExpression;
        this.myQuick = quick;
        this.myBaseClass = baseClass;
        this.myBuilder = builder;
        this.myMethod = method;
        this.methodBody = methodBody2;
    }

    @Nullable
    List<FoldingDescriptor> process(@NotNull Document document) {
        int rangeEnd;
        PsiJavaToken lbrace = this.methodBody.getLBrace();
        PsiJavaToken rbrace = this.methodBody.getRBrace();
        PsiElement classRBrace = this.myAnonymousClass.getRBrace();
        if (lbrace == null || rbrace == null || classRBrace == null) {
            return null;
        }
        CharSequence seq = document.getCharsSequence();
        int rangeStart = lbrace.getTextRange().getEndOffset();
        String contents = ClosureFolding.getClosureContents(rangeStart, rangeEnd = ClosureFolding.getContentRangeEnd(document, rbrace, classRBrace), seq);
        if (contents == null) {
            return null;
        }
        String header = this.getFoldingHeader();
        if (this.showSingleLineFolding(document, contents, header)) {
            return this.createDescriptors(classRBrace, ClosureFolding.trimStartSpaces(seq, rangeStart), ClosureFolding.trimTailSpaces(seq, rangeEnd), header + " ", " }");
        }
        return this.createDescriptors(classRBrace, rangeStart, rangeEnd, header, "}");
    }

    private static int trimStartSpaces(@NotNull CharSequence seq, int rangeStart) {
        return CharArrayUtil.shiftForward((CharSequence)seq, (int)rangeStart, (String)" \n\t");
    }

    private static int trimTailSpaces(@NotNull CharSequence seq, int rangeEnd) {
        return CharArrayUtil.shiftBackward((CharSequence)seq, (int)(rangeEnd - 1), (String)" \n\t") + 1;
    }

    private static int getContentRangeEnd(@NotNull Document document, @NotNull PsiJavaToken rbrace, @NotNull PsiElement classRBrace) {
        int rangeEnd;
        int methodEndLine;
        int methodEndLineStart;
        CharSequence seq = document.getCharsSequence();
        if ("}".equals(seq.subSequence(methodEndLineStart = document.getLineStartOffset(methodEndLine = document.getLineNumber(rangeEnd = rbrace.getTextRange().getStartOffset())), document.getLineEndOffset(methodEndLine)).toString().trim())) {
            int classEndStart = classRBrace.getTextRange().getStartOffset();
            int classEndCol = classEndStart - document.getLineStartOffset(document.getLineNumber(classEndStart));
            return classEndCol + methodEndLineStart;
        }
        return rangeEnd;
    }

    private boolean showSingleLineFolding(@NotNull Document document, @NotNull String contents, @NotNull String header) {
        return contents.indexOf(10) < 0 && this.myBuilder.fitsRightMargin((PsiElement)this.myAnonymousClass, document, this.getClosureStartOffset(), this.getClosureEndOffset(), header.length() + contents.length() + 5);
    }

    private int getClosureEndOffset() {
        return this.myNewExpression.getTextRange().getEndOffset();
    }

    private int getClosureStartOffset() {
        return this.myNewExpression.getTextRange().getStartOffset();
    }

    @Nullable
    private List<FoldingDescriptor> createDescriptors(@NotNull PsiElement classRBrace, int rangeStart, int rangeEnd, @NotNull String header, @NotNull String footer) {
        if (rangeStart >= rangeEnd) {
            return null;
        }
        FoldingGroup group = FoldingGroup.newGroup((String)"lambda");
        ArrayList<FoldingDescriptor> foldElements = new ArrayList<FoldingDescriptor>();
        foldElements.add(new FoldingDescriptor(this.myNewExpression.getNode(), new TextRange(this.getClosureStartOffset(), rangeStart), group, header, Boolean.valueOf(JavaCodeFoldingSettings.getInstance().isCollapseLambdas()), Collections.emptySet()));
        if (rangeEnd + 1 < this.getClosureEndOffset()) {
            foldElements.add(new FoldingDescriptor(classRBrace.getNode(), new TextRange(rangeEnd, this.getClosureEndOffset()), group, footer, Boolean.valueOf(JavaCodeFoldingSettings.getInstance().isCollapseLambdas()), Collections.emptySet()));
        }
        return foldElements;
    }

    @Nullable
    private static String getClosureContents(int rangeStart, int rangeEnd, @NotNull CharSequence seq) {
        int lastLineEnd;
        int firstLineStart = CharArrayUtil.shiftForward((CharSequence)seq, (int)rangeStart, (String)" \t");
        if (firstLineStart < seq.length() - 1 && seq.charAt(firstLineStart) == '\n') {
            ++firstLineStart;
        }
        if ((lastLineEnd = CharArrayUtil.shiftBackward((CharSequence)seq, (int)(rangeEnd - 1), (String)" \t")) > 0 && seq.charAt(lastLineEnd) == '\n') {
            --lastLineEnd;
        }
        if (lastLineEnd < firstLineStart) {
            return null;
        }
        return seq.subSequence(firstLineStart, lastLineEnd).toString();
    }

    @NotNull
    private String getFoldingHeader() {
        String methodName = this.shouldShowMethodName() ? this.myMethod.getName() : "";
        String type2 = this.myQuick ? "" : this.getOptionalLambdaType();
        String params = StringUtil.join((Object[])this.myMethod.getParameterList().getParameters(), psiParameter -> psiParameter.getName(), (String)", ");
        return type2 + methodName + "(" + params + ") " + this.myBuilder.rightArrow() + " {";
    }

    @Nullable
    static ClosureFolding prepare(@NotNull PsiAnonymousClass anonymousClass, boolean quick, @NotNull JavaFoldingBuilderBase builder) {
        PsiElement parent = anonymousClass.getParent();
        if (parent instanceof PsiNewExpression && ClosureFolding.hasNoArguments((PsiNewExpression)parent)) {
            PsiMethod method;
            PsiCodeBlock body2;
            PsiClass baseClass = quick ? null : anonymousClass.getBaseClassType().resolve();
            if (ClosureFolding.hasOnlyOneLambdaMethod(anonymousClass, !quick) && (quick || ClosureFolding.seemsLikeLambda(baseClass, (PsiElement)anonymousClass)) && (body2 = (method = anonymousClass.getMethods()[0]).getBody()) != null) {
                return new ClosureFolding(anonymousClass, (PsiNewExpression)parent, quick, baseClass, builder, method, body2);
            }
        }
        return null;
    }

    private static boolean hasNoArguments(@NotNull PsiNewExpression expression2) {
        PsiExpressionList argumentList = expression2.getArgumentList();
        return argumentList != null && argumentList.isEmpty();
    }

    private static boolean hasOnlyOneLambdaMethod(@NotNull PsiAnonymousClass anonymousClass, boolean checkResolve) {
        PsiField[] fields = anonymousClass.getFields();
        if (!(fields.length == 0 || fields.length == 1 && "serialVersionUID".equals(fields[0].getName()) && fields[0].hasModifierProperty("static"))) {
            return false;
        }
        if (anonymousClass.getInitializers().length != 0 || anonymousClass.getInnerClasses().length != 0 || anonymousClass.getMethods().length != 1) {
            return false;
        }
        PsiMethod method = anonymousClass.getMethods()[0];
        if (method.hasModifierProperty("synchronized")) {
            return false;
        }
        if (checkResolve) {
            for (PsiClassType type2 : method.getThrowsList().getReferencedTypes()) {
                if (type2.resolve() != null) continue;
                return false;
            }
        }
        return true;
    }

    static boolean seemsLikeLambda(@Nullable PsiClass baseClass, @NotNull PsiElement context) {
        if (baseClass == null || !PsiUtil.hasDefaultConstructor((PsiClass)baseClass, (boolean)true)) {
            return false;
        }
        return !PsiUtil.isLanguageLevel8OrHigher((PsiElement)context) || !LambdaUtil.isFunctionalClass((PsiClass)baseClass);
    }

    @NotNull
    private String getOptionalLambdaType() {
        String baseClassName;
        if (this.myBuilder.shouldShowExplicitLambdaType(this.myAnonymousClass, this.myNewExpression) && (baseClassName = Objects.requireNonNull(this.myAnonymousClass.getBaseClassType().resolve()).getName()) != null) {
            return "(" + baseClassName + ") ";
        }
        return "";
    }

    private boolean shouldShowMethodName() {
        if (this.myBaseClass == null || !this.myBaseClass.hasModifierProperty("abstract")) {
            return true;
        }
        for (PsiMethod method : this.myBaseClass.getMethods()) {
            if (!method.hasModifierProperty("abstract")) continue;
            return false;
        }
        try {
            return OverrideImplementExploreUtil.getMethodSignaturesToImplement(this.myBaseClass).isEmpty();
        }
        catch (IndexNotReadyException e) {
            return true;
        }
    }
}

