/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiTypeCastExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TypeCastSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof PsiTypeCastExpression;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        ArrayList<TextRange> result = new ArrayList<TextRange>(TypeCastSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)e.getTextRange(), (boolean)false));
        PsiTypeCastExpression expression2 = (PsiTypeCastExpression)e;
        PsiElement[] children = expression2.getChildren();
        PsiJavaToken lParen = null;
        PsiJavaToken rParen = null;
        for (PsiElement child : children) {
            if (!(child instanceof PsiJavaToken)) continue;
            PsiJavaToken token = (PsiJavaToken)child;
            if (token.getTokenType() == JavaTokenType.LPARENTH) {
                lParen = token;
            }
            if (token.getTokenType() != JavaTokenType.RPARENTH) continue;
            rParen = token;
        }
        if (lParen != null && rParen != null) {
            result.addAll(TypeCastSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)new TextRange(lParen.getTextRange().getStartOffset(), rParen.getTextRange().getEndOffset()), (boolean)false));
        }
        return result;
    }
}

