/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;

class TernaryColonFixer
implements Fixer {
    TernaryColonFixer() {
    }

    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof PsiConditionalExpression)) {
            return;
        }
        PsiConditionalExpression ternary = (PsiConditionalExpression)psiElement;
        if (ternary.getThenExpression() == null || ternary.getNode().findChildByType(JavaTokenType.COLON) != null) {
            return;
        }
        editor.getCaretModel().moveToOffset(ternary.getTextRange().getEndOffset());
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)": ");
        processor2.setSkipEnter(true);
    }
}

