/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingIfBranchesFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof PsiIfStatement)) {
            return;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)psiElement;
        Document doc = editor.getDocument();
        PsiKeyword elseElement = ifStatement.getElseElement();
        if (elseElement != null) {
            MissingIfBranchesFixer.handleBranch(doc, ifStatement, (PsiElement)elseElement, ifStatement.getElseBranch());
        }
        PsiJavaToken rParenth = ifStatement.getRParenth();
        assert (rParenth != null);
        MissingIfBranchesFixer.handleBranch(doc, ifStatement, (PsiElement)rParenth, ifStatement.getThenBranch());
    }

    private static void handleBranch(@NotNull Document doc, @NotNull PsiIfStatement ifStatement, @NotNull PsiElement beforeBranch, @Nullable PsiStatement branch) {
        boolean transformingOneLiner;
        if (branch instanceof PsiBlockStatement || beforeBranch.textMatches((CharSequence)"else") && branch instanceof PsiIfStatement) {
            return;
        }
        boolean bl = transformingOneLiner = branch != null && (MissingIfBranchesFixer.startLine(doc, beforeBranch) == MissingIfBranchesFixer.startLine(doc, (PsiElement)branch) || MissingIfBranchesFixer.startCol(doc, (PsiElement)ifStatement) < MissingIfBranchesFixer.startCol(doc, (PsiElement)branch));
        if (!transformingOneLiner) {
            doc.insertString(beforeBranch.getTextRange().getEndOffset(), (CharSequence)"{}");
        } else {
            doc.insertString(beforeBranch.getTextRange().getEndOffset(), (CharSequence)"{");
            doc.insertString(branch.getTextRange().getEndOffset() + 1, (CharSequence)"}");
        }
    }

    private static int startLine(Document doc, @NotNull PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }

    private static int startCol(Document doc, @NotNull PsiElement psiElement) {
        int offset = psiElement.getTextRange().getStartOffset();
        return offset - doc.getLineStartOffset(doc.getLineNumber(offset));
    }
}

