/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaClassReferenceCompletionContributor;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTypedHandler
extends TypedHandlerDelegate {
    static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.SEMICOLON, JavaTokenType.LBRACE, JavaTokenType.RBRACE});
    private boolean myJavaLTTyped;

    private static void autoPopupMemberLookup(Project project, Editor editor) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, file -> {
            int offset = editor.getCaretModel().getOffset();
            PsiElement lastElement = file.findElementAt(offset - 1);
            if (lastElement == null) {
                return false;
            }
            PsiElement prevSibling = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastElement);
            if (prevSibling == null || ".".equals(prevSibling.getText())) {
                return false;
            }
            PsiElement parent = prevSibling;
            while ((parent = parent.getParent()) instanceof PsiJavaCodeReferenceElement || parent instanceof PsiTypeElement) {
            }
            if (parent instanceof PsiParameterList || parent instanceof PsiParameter) {
                return false;
            }
            if (!".".equals(lastElement.getText()) && !"#".equals(lastElement.getText())) {
                return JavaClassReferenceCompletionContributor.findJavaClassReference(file, offset - 1) != null;
            }
            PsiElement element = file.findElementAt(offset);
            return element == null || !"#".equals(lastElement.getText()) || PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class) != null;
        });
    }

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        if (charTyped == ' ' && StringUtil.endsWith((CharSequence)editor.getDocument().getImmutableCharSequence(), (int)0, (int)offset, (CharSequence)"new")) {
            AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor, CompletionType.BASIC, f -> {
                PsiElement leaf = f.findElementAt(offset - "new".length());
                return leaf instanceof PsiKeyword && leaf.textMatches((CharSequence)"new") && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiExpressionStatement())).accepts((Object)leaf);
            });
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.checkAutoPopup(charTyped, project, editor, file);
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (!(file instanceof PsiJavaFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == '@') {
            JavaTypedHandler.autoPopupJavadocLookup(project, editor);
        } else if (c == '#' || c == '.') {
            JavaTypedHandler.autoPopupMemberLookup(project, editor);
        }
        int offsetBefore = editor.getCaretModel().getOffset();
        boolean bl = this.myJavaLTTyped = '<' == c && !(file instanceof JspFile) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && TypedHandlerUtil.isAfterClassLikeIdentifierOrDot((int)offsetBefore, (Editor)editor, (IElementType)JavaTokenType.DOT, (IElementType)JavaTokenType.IDENTIFIER, (boolean)true);
        if ('>' == c && !(file instanceof JspFile) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && TypedHandlerUtil.handleGenericGT((Editor)editor, (IElementType)JavaTokenType.LT, (IElementType)JavaTokenType.GT, (TokenSet)INVALID_INSIDE_REFERENCE)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == ';' && JavaTypedHandler.handleSemicolon(project, editor, file, fileType)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (fileType == JavaFileType.INSTANCE && c == '{') {
            PsiElement prev;
            int offset = editor.getCaretModel().getOffset();
            if (offset == 0) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
            while (!iterator.atEnd() && iterator.getTokenType() == TokenType.WHITE_SPACE) {
                iterator.retreat();
            }
            if (iterator.atEnd() || iterator.getTokenType() == JavaTokenType.RBRACKET || iterator.getTokenType() == JavaTokenType.EQ) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            Document doc = editor.getDocument();
            PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
            PsiElement leaf = file.findElementAt(offset);
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiArrayInitializerExpression.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiMember.class}) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            PsiElement st = leaf != null ? leaf.getParent() : null;
            PsiElement psiElement = prev = offset > 1 ? file.findElementAt(offset - 1) : null;
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && JavaTypedHandler.isRparenth(leaf) && (st instanceof PsiWhileStatement || st instanceof PsiIfStatement) && JavaTypedHandler.shouldInsertStatementBody(st, doc, prev)) {
                CommandProcessor.getInstance().executeCommand(project, () -> new JavaSmartEnterProcessor().process(project, editor, file), JavaBundle.message((String)"command.name.insert.block.statement", (Object[])new Object[0]), null);
                return TypedHandlerDelegate.Result.STOP;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiCodeBlock.class, (boolean)false, (Class[])new Class[]{PsiMember.class}) != null && !JavaTypedHandler.shouldInsertPairedBrace(leaf)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{");
                TypedHandler.indentOpenedBrace((Project)project, (Editor)editor);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean shouldInsertPairedBrace(@NotNull PsiElement leaf) {
        PsiElement prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)leaf);
        if (PsiUtil.isJavaToken((PsiElement)prevLeaf, (IElementType)JavaTokenType.ARROW)) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)prevLeaf, PsiNewExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiMember.class}) != null) {
            return true;
        }
        if (prevLeaf instanceof PsiIdentifier && prevLeaf.getParent() instanceof PsiClass) {
            return true;
        }
        return PsiUtil.isJavaToken((PsiElement)prevLeaf, (IElementType)JavaTokenType.RPARENTH) && prevLeaf.getParent() instanceof PsiRecordHeader;
    }

    private static boolean shouldInsertStatementBody(@NotNull PsiElement statement, @NotNull Document doc, @Nullable PsiElement prev) {
        PsiStatement block = statement instanceof PsiWhileStatement ? ((PsiWhileStatement)statement).getBody() : ((PsiIfStatement)statement).getThenBranch();
        PsiExpression condition2 = (PsiExpression)PsiTreeUtil.getChildOfType((PsiElement)statement, PsiExpression.class);
        PsiExpression latestExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)prev, PsiExpression.class);
        if (latestExpression instanceof PsiNewExpression && ((PsiNewExpression)latestExpression).getAnonymousClass() == null) {
            return false;
        }
        return !(block instanceof PsiBlockStatement) && (block == null || JavaTypedHandler.startLine(doc, (PsiElement)block) != JavaTypedHandler.startLine(doc, statement) || condition2 == null);
    }

    private static boolean isRparenth(@Nullable PsiElement leaf) {
        if (leaf == null) {
            return false;
        }
        if (leaf.getNode().getElementType() == JavaTokenType.RPARENTH) {
            return true;
        }
        PsiElement next = PsiTreeUtil.nextVisibleLeaf((PsiElement)leaf);
        if (next == null) {
            return false;
        }
        return next.getNode().getElementType() == JavaTokenType.RPARENTH;
    }

    private static int startLine(@NotNull Document doc, @NotNull PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (this.myJavaLTTyped) {
            this.myJavaLTTyped = false;
            TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)JavaTokenType.LT, (IElementType)JavaTokenType.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == ':' ? JavaTypedHandler.autoIndentCase(editor, project, file) : c == ',' && JavaTypedHandler.handleAnnotationParameter(project, editor, file)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean handleAnnotationParameter(Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int caret = editor.getCaretModel().getOffset();
        if (JavaTypedHandler.mightBeInsideDefaultAnnotationAttribute(editor, caret - 2)) {
            PsiNameValuePair attr;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiAnnotation anno = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(caret), PsiAnnotation.class, (boolean)false, (Class[])new Class[]{PsiExpression.class, PsiComment.class});
            PsiNameValuePair psiNameValuePair = attr = anno == null ? null : JavaTypedHandler.getTheOnlyDefaultAttribute(anno);
            if (attr != null && JavaTypedHandler.hasDefaultArrayMethod(anno) && !(attr.getValue() instanceof PsiArrayInitializerMemberValue)) {
                editor.getDocument().insertString(caret, (CharSequence)"}");
                editor.getDocument().insertString(attr.getTextRange().getStartOffset(), (CharSequence)"{");
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiNameValuePair getTheOnlyDefaultAttribute(@NotNull PsiAnnotation anno) {
        List attributes = ContainerUtil.findAll((Object[])anno.getParameterList().getAttributes(), a -> !a.getTextRange().isEmpty());
        return attributes.size() == 1 && ((PsiNameValuePair)attributes.get(0)).getNameIdentifier() == null ? (PsiNameValuePair)attributes.get(0) : null;
    }

    private static boolean hasDefaultArrayMethod(@NotNull PsiAnnotation anno) {
        PsiElement annoClass;
        PsiJavaCodeReferenceElement nameRef = anno.getNameReferenceElement();
        PsiElement psiElement = annoClass = nameRef == null ? null : nameRef.resolve();
        if (annoClass instanceof PsiClass) {
            PsiMethod[] methods = ((PsiClass)annoClass).getMethods();
            return methods.length == 1 && PsiUtil.isAnnotationMethod((PsiElement)methods[0]) && "value".equals(methods[0].getName()) && methods[0].getReturnType() instanceof PsiArrayType;
        }
        return false;
    }

    private static boolean mightBeInsideDefaultAnnotationAttribute(@NotNull Editor editor, int offset) {
        if (offset < 0) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        int parenCount = 0;
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == JavaTokenType.AT) {
                return true;
            }
            if (tokenType == JavaTokenType.RPARENTH || tokenType == JavaTokenType.LBRACE || tokenType == JavaTokenType.EQ || tokenType == JavaTokenType.SEMICOLON || tokenType == JavaTokenType.COMMA) {
                return false;
            }
            if (tokenType == JavaTokenType.LPARENTH && ++parenCount > 1) {
                return false;
            }
            iterator.retreat();
        }
        return false;
    }

    private static boolean handleSemicolon(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (fileType != JavaFileType.INSTANCE) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        if (JavaTypedHandler.moveSemicolonAtRParen(project, editor, file, offset)) {
            return true;
        }
        char charAt = editor.getDocument().getCharsSequence().charAt(offset);
        if (charAt != ';') {
            return false;
        }
        HighlighterIterator hi = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (hi.atEnd() || hi.getTokenType() != JavaTokenType.SEMICOLON) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    private static boolean moveSemicolonAtRParen(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int caretOffset) {
        if (!Registry.is((String)"editor.move.semicolon.after.paren")) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        HighlighterIterator it = ((EditorEx)editor).getHighlighter().createIterator(caretOffset);
        int afterLastParenOffset = -1;
        while (!it.atEnd() && !JavaTypedHandler.isAtLineEnd(it) && it.getTokenType() != JavaTokenType.RBRACE) {
            if (it.getTokenType() == JavaTokenType.RPARENTH) {
                afterLastParenOffset = it.getEnd();
            } else if (it.getTokenType() != TokenType.WHITE_SPACE) {
                return false;
            }
            it.advance();
        }
        if (!it.atEnd() && afterLastParenOffset >= 0 && afterLastParenOffset >= caretOffset) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement curElement = file.findElementAt(caretOffset);
            PsiStatement curStmt = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)curElement, PsiStatement.class);
            if (curStmt != null) {
                int stmtEndOffset;
                if (curStmt instanceof PsiTryStatement) {
                    return false;
                }
                if (curStmt instanceof PsiForStatement) {
                    return false;
                }
                if (PsiTreeUtil.getDeepestLast((PsiElement)curStmt) instanceof PsiErrorElement && ((stmtEndOffset = curStmt.getTextRange().getEndOffset()) == afterLastParenOffset || stmtEndOffset == it.getStart())) {
                    editor.getDocument().insertString(stmtEndOffset, (CharSequence)";");
                    editor.getCaretModel().moveToOffset(stmtEndOffset + 1);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isAtLineEnd(HighlighterIterator it) {
        if (it.getTokenType() == TokenType.WHITE_SPACE) {
            CharSequence tokenText = it.getDocument().getImmutableCharSequence().subSequence(it.getStart(), it.getEnd());
            return CharArrayUtil.containLineBreaks((CharSequence)tokenText);
        }
        return false;
    }

    private static void autoPopupJavadocLookup(Project project, Editor editor) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, file -> {
            int offset = editor.getCaretModel().getOffset();
            PsiElement lastElement = file.findElementAt(offset - 1);
            return lastElement != null && StringUtil.endsWithChar((CharSequence)lastElement.getText(), (char)'@');
        });
    }

    private static boolean autoIndentCase(Editor editor, Project project, PsiFile file) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement currElement = file.findElementAt(offset - 1);
        if (currElement != null && (parent = currElement.getParent()) instanceof PsiSwitchLabelStatement) {
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, parent.getTextOffset());
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean handleJavaGT(@NotNull Editor editor, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        return TypedHandlerUtil.handleGenericGT((Editor)editor, (IElementType)lt, (IElementType)gt, (TokenSet)invalidInsideReference);
    }

    @Deprecated
    public static void handleAfterJavaLT(@NotNull Editor editor, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)lt, (IElementType)gt, (TokenSet)invalidInsideReference);
    }

    @Deprecated
    public static boolean isClassLikeIdentifier(int offset, @NotNull Editor editor, @NotNull HighlighterIterator iterator, @NotNull IElementType idType) {
        return TypedHandlerUtil.isClassLikeIdentifier((int)offset, (Editor)editor, (HighlighterIterator)iterator, (IElementType)idType);
    }
}

