/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.problems;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightVisitorImpl;
import com.intellij.codeInsight.daemon.problems.Problem;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 /2\u00020\u0001:\u0002/0B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/codeInsight/daemon/problems/ProblemSearcher;", "Lcom/intellij/psi/JavaElementVisitor;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "problems", "", "Lcom/intellij/codeInsight/daemon/problems/Problem;", "seenReference", "", "findProblem", "", "element", "Lcom/intellij/psi/PsiElement;", "visitAnnotation", "annotation", "Lcom/intellij/psi/PsiAnnotation;", "visitAnonymousClass", "aClass", "Lcom/intellij/psi/PsiAnonymousClass;", "visitCallExpression", "callExpression", "Lcom/intellij/psi/PsiCallExpression;", "visitClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "visitElement", "visitForeachStatement", "statement", "Lcom/intellij/psi/PsiForeachStatement;", "visitMethod", "method", "Lcom/intellij/psi/PsiMethod;", "visitParameter", "parameter", "Lcom/intellij/psi/PsiParameter;", "visitReferenceElement", "reference", "Lcom/intellij/psi/PsiJavaCodeReferenceElement;", "visitReferenceExpression", "expression", "Lcom/intellij/psi/PsiReferenceExpression;", "visitStatement", "Lcom/intellij/psi/PsiStatement;", "visitVariable", "variable", "Lcom/intellij/psi/PsiVariable;", "Companion", "ProblemHolder", "intellij.java.impl"})
public final class ProblemSearcher
extends JavaElementVisitor {
    private final Set<Problem> problems;
    private boolean seenReference;
    private final PsiFile file;
    public static final Companion Companion = new Companion(null);

    public void visitElement(@NotNull PsiElement element) {
        block0: {
            this.findProblem(element);
            PsiElement psiElement = element.getParent();
            if (psiElement == null) break block0;
            psiElement.accept((PsiElementVisitor)this);
        }
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (this.seenReference && reference.resolve() != null) {
            return;
        }
        this.seenReference = true;
        super.visitReferenceElement(reference);
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
        this.visitReferenceElement((PsiJavaCodeReferenceElement)expression2);
    }

    public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
        PsiExpressionList args = callExpression.getArgumentList();
        if (args != null) {
            this.findProblem((PsiElement)args);
        }
        this.visitElement((PsiElement)callExpression);
    }

    public void visitAnnotation(@NotNull PsiAnnotation annotation) {
        PsiAnnotationParameterList paramsList = annotation.getParameterList();
        PsiNameValuePair[] $this$forEach$iv = paramsList.getAttributes();
        boolean $i$f$forEach = false;
        PsiNameValuePair[] psiNameValuePairArray = $this$forEach$iv;
        int n = psiNameValuePairArray.length;
        for (int i = 0; i < n; ++i) {
            PsiNameValuePair element$iv;
            PsiNameValuePair it = element$iv = psiNameValuePairArray[i];
            boolean bl = false;
            PsiAnnotationMemberValue detachedValue = it.getDetachedValue();
            if (detachedValue != null) {
                this.findProblem((PsiElement)detachedValue);
            }
            this.findProblem((PsiElement)it);
        }
        this.visitElement((PsiElement)annotation);
    }

    public void visitParameter(@NotNull PsiParameter parameter2) {
        PsiElement parent = parameter2.getParent();
        if (parent instanceof PsiCatchSection) {
            this.findProblem((PsiElement)((PsiCatchSection)parent).getTryStatement());
        }
        this.findProblem((PsiElement)parameter2);
    }

    public void visitVariable(@NotNull PsiVariable variable) {
        this.findProblem((PsiElement)variable);
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        this.visitStatement((PsiStatement)statement);
        this.findProblem((PsiElement)statement.getIterationParameter());
    }

    public void visitStatement(@NotNull PsiStatement statement) {
        this.findProblem((PsiElement)statement);
    }

    public void visitMethod(@NotNull PsiMethod method) {
        this.findProblem((PsiElement)method);
        PsiTypeElement typeElement = method.getReturnTypeElement();
        if (typeElement != null) {
            this.findProblem((PsiElement)typeElement);
        }
        PsiParameterList params = method.getParameterList();
        this.findProblem((PsiElement)params);
        PsiModifierList modifiers = method.getModifierList();
        this.findProblem((PsiElement)modifiers);
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        this.visitElement((PsiElement)aClass);
    }

    public void visitClass(@NotNull PsiClass psiClass) {
        PsiIdentifier nameIdentifier;
        PsiModifierList modifiers = psiClass.getModifierList();
        if (modifiers != null) {
            this.findProblem((PsiElement)modifiers);
        }
        if ((nameIdentifier = psiClass.getNameIdentifier()) != null) {
            this.findProblem((PsiElement)nameIdentifier);
        }
        this.findProblem((PsiElement)psiClass);
    }

    private final void findProblem(PsiElement element) {
        if (!(element instanceof Navigatable)) {
            return;
        }
        ProblemHolder problemHolder = new ProblemHolder(this.file);
        HighlightVisitorImpl visitor2 = new HighlightVisitorImpl(problemHolder){
            final /* synthetic */ ProblemHolder $problemHolder;
            {
                this.$problemHolder = $captured_local_variable$0;
                this.prepareToRunAsInspection($captured_local_variable$0);
            }
        };
        element.accept((PsiElementVisitor)visitor2);
        PsiElement psiElement = problemHolder.getReportedElement();
        if (psiElement == null) {
            return;
        }
        PsiElement reportedElement = psiElement;
        PsiElement psiElement2 = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiClass.class, PsiMethod.class, PsiVariable.class});
        if (psiElement2 == null) {
            psiElement2 = element;
        }
        PsiElement context = psiElement2;
        this.problems.add(new Problem(reportedElement, context));
    }

    public ProblemSearcher(@NotNull PsiFile file) {
        this.file = file;
        boolean bl = false;
        this.problems = new LinkedHashSet();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/codeInsight/daemon/problems/ProblemSearcher$ProblemHolder;", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "reportedElement", "Lcom/intellij/psi/PsiElement;", "getReportedElement", "()Lcom/intellij/psi/PsiElement;", "setReportedElement", "(Lcom/intellij/psi/PsiElement;)V", "add", "", "info", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "hasErrorResults", "intellij.java.impl"})
    private static final class ProblemHolder
    extends HighlightInfoHolder {
        @Nullable
        private PsiElement reportedElement;
        private final PsiFile file;

        @Nullable
        public final PsiElement getReportedElement() {
            return this.reportedElement;
        }

        public final void setReportedElement(@Nullable PsiElement psiElement) {
            this.reportedElement = psiElement;
        }

        public boolean add(@Nullable HighlightInfo info) {
            if (this.reportedElement != null || info == null || Intrinsics.areEqual((Object)info.getSeverity(), (Object)HighlightSeverity.ERROR) ^ true || info.getDescription() == null) {
                return true;
            }
            this.reportedElement = this.file.findElementAt(info.getActualStartOffset());
            return true;
        }

        public boolean hasErrorResults() {
            return this.reportedElement != null;
        }

        public ProblemHolder(@NotNull PsiFile file) {
            super(file, new HighlightInfoFilter[0]);
            this.file = file;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/daemon/problems/ProblemSearcher$Companion;", "", "()V", "getProblems", "", "Lcom/intellij/codeInsight/daemon/problems/Problem;", "usage", "Lcom/intellij/psi/PsiElement;", "targetFile", "Lcom/intellij/psi/PsiFile;", "getProblems$intellij_java_impl", "getSearchStartElement", "intellij.java.impl"})
    public static final class Companion {
        @NotNull
        public final Set<Problem> getProblems$intellij_java_impl(@NotNull PsiElement usage, @NotNull PsiFile targetFile) {
            PsiElement psiElement = this.getSearchStartElement(usage, targetFile);
            if (psiElement == null) {
                return SetsKt.emptySet();
            }
            PsiElement startElement = psiElement;
            PsiFile psiFile = startElement.getContainingFile();
            ProblemSearcher searcher = new ProblemSearcher(psiFile);
            startElement.accept((PsiElementVisitor)searcher);
            return searcher.problems;
        }

        private final PsiElement getSearchStartElement(PsiElement usage, PsiFile targetFile) {
            PsiElement psiElement = usage;
            if (psiElement instanceof PsiMethod) {
                PsiAnnotation psiAnnotation = ((PsiMethod)usage).getModifierList().findAnnotation("java.lang.Override");
                return psiAnnotation != null ? (PsiElement)psiAnnotation : usage;
            }
            if (psiElement instanceof PsiJavaCodeReferenceElement) {
                JavaResolveResult resolveResult = ((PsiJavaCodeReferenceElement)usage).advancedResolve(false);
                if (resolveResult.isValidResult()) {
                    PsiFile containingFile;
                    PsiElement psiElement2 = resolveResult.getElement();
                    Object object = containingFile = psiElement2 != null ? psiElement2.getContainingFile() : null;
                    if (containingFile != null && Intrinsics.areEqual((Object)containingFile, (Object)targetFile) ^ true) {
                        return null;
                    }
                }
                return ((PsiJavaCodeReferenceElement)usage).getReferenceNameElement();
            }
            return usage;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

