/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceWithListAccessFix
implements IntentionAction {
    private final PsiArrayAccessExpression myArrayAccessExpression;

    public ReplaceWithListAccessFix(@NotNull PsiArrayAccessExpression arrayAccessExpression) {
        this.myArrayAccessExpression = arrayAccessExpression;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("replace.with.list.access.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiExpression lExpression;
        if (!this.myArrayAccessExpression.isValid()) {
            return false;
        }
        if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)PsiType.INT, (PsiExpression)this.myArrayAccessExpression.getIndexExpression())) {
            return false;
        }
        PsiElement parent = this.myArrayAccessExpression.getParent();
        if (parent instanceof PsiAssignmentExpression && (lExpression = ((PsiAssignmentExpression)parent).getLExpression()).equals(this.myArrayAccessExpression) && !(parent.getParent() instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression arrayExpression = this.myArrayAccessExpression.getArrayExpression();
        PsiType type2 = arrayExpression.getType();
        PsiType listType = this.createUtilListType(project);
        if (type2 == null || listType == null) {
            return false;
        }
        return listType.isAssignableFrom(type2);
    }

    @Nullable
    private PsiType createUtilListType(@NotNull Project project) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass listClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.List", this.myArrayAccessExpression.getResolveScope());
        if (listClass == null) {
            return null;
        }
        PsiElementFactory factory = facade.getElementFactory();
        return factory.createType(listClass);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiExpression arrayExpression = this.myArrayAccessExpression.getArrayExpression();
        PsiExpression indexExpression = this.myArrayAccessExpression.getIndexExpression();
        if (indexExpression == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiElement parent = this.myArrayAccessExpression.getParent();
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiExpression lExpression = assignmentExpression.getLExpression();
            PsiExpression rExpression = assignmentExpression.getRExpression();
            if (lExpression.equals(this.myArrayAccessExpression) && parent.getParent() instanceof PsiExpressionStatement && rExpression != null) {
                ReplaceWithListAccessFix.replaceWithSet(factory, codeStyleManager, arrayExpression, indexExpression, rExpression, (PsiElement)assignmentExpression);
                return;
            }
        }
        ReplaceWithListAccessFix.replaceWithGet(factory, codeStyleManager, arrayExpression, indexExpression, (PsiElement)this.myArrayAccessExpression);
    }

    @NotNull
    private static PsiElement replaceWithGet(@NotNull PsiElementFactory factory, @NotNull CodeStyleManager codeStyleManager, @NotNull PsiExpression arrayExpression, @NotNull PsiExpression indexExpression, @NotNull PsiElement anchor) {
        PsiExpression listAccess = factory.createExpressionFromText(arrayExpression.getText() + ".get(" + indexExpression.getText() + ")", anchor);
        return anchor.replace(codeStyleManager.reformat((PsiElement)listAccess));
    }

    private static PsiElement replaceWithSet(@NotNull PsiElementFactory factory, @NotNull CodeStyleManager codeStyleManager, @NotNull PsiExpression arrayExpression, @NotNull PsiExpression indexExpression, @NotNull PsiExpression expression2, @NotNull PsiElement anchor) {
        PsiExpression listAccess = factory.createExpressionFromText(arrayExpression.getText() + ".set(" + indexExpression.getText() + "," + expression2.getText() + ")", anchor);
        return anchor.replace(codeStyleManager.reformat((PsiElement)listAccess));
    }

    public boolean startInWriteAction() {
        return true;
    }
}

