/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyStaticMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportConstantFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QualifyStaticConstantFix
extends StaticImportConstantFix {
    QualifyStaticConstantFix(@NotNull PsiFile file, @NotNull PsiJavaCodeReferenceElement referenceElement) {
        super(file, referenceElement);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        return "Qualify static constant access";
    }

    @Override
    @NotNull
    protected StaticImportMethodQuestionAction<PsiField> createQuestionAction(@NotNull List<? extends PsiField> fieldsToImport, final @NotNull Project project, Editor editor) {
        return new StaticImportMethodQuestionAction<PsiField>(project, editor, fieldsToImport, this.myRef){

            @Override
            @NotNull
            protected String getPopupTitle() {
                return QuickFixBundle.message("field.to.import.chooser.title", new Object[0]);
            }

            @Override
            protected void doImport(PsiField toImport) {
                PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)QualifyStaticConstantFix.this.myRef.getElement();
                if (!(element instanceof PsiReferenceExpression)) {
                    return;
                }
                QualifyStaticMethodCallFix.qualifyStatically((PsiMember)toImport, project, (PsiReferenceExpression)element);
            }
        };
    }

    @Override
    protected boolean toAddStaticImports() {
        return false;
    }
}

